/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the results of WhatsAppSignupCallback.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WhatsAppSignupCallbackResult implements SdkPojo, Serializable,
        ToCopyableBuilder<WhatsAppSignupCallbackResult.Builder, WhatsAppSignupCallbackResult> {
    private static final SdkField<String> ASSOCIATE_IN_PROGRESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associateInProgressToken").getter(getter(WhatsAppSignupCallbackResult::associateInProgressToken))
            .setter(setter(Builder::associateInProgressToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associateInProgressToken").build())
            .build();

    private static final SdkField<Map<String, LinkedWhatsAppBusinessAccountIdMetaData>> LINKED_ACCOUNTS_WITH_INCOMPLETE_SETUP_FIELD = SdkField
            .<Map<String, LinkedWhatsAppBusinessAccountIdMetaData>> builder(MarshallingType.MAP)
            .memberName("linkedAccountsWithIncompleteSetup")
            .getter(getter(WhatsAppSignupCallbackResult::linkedAccountsWithIncompleteSetup))
            .setter(setter(Builder::linkedAccountsWithIncompleteSetup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkedAccountsWithIncompleteSetup")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<LinkedWhatsAppBusinessAccountIdMetaData> builder(MarshallingType.SDK_POJO)
                                            .constructor(LinkedWhatsAppBusinessAccountIdMetaData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSOCIATE_IN_PROGRESS_TOKEN_FIELD, LINKED_ACCOUNTS_WITH_INCOMPLETE_SETUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String associateInProgressToken;

    private final Map<String, LinkedWhatsAppBusinessAccountIdMetaData> linkedAccountsWithIncompleteSetup;

    private WhatsAppSignupCallbackResult(BuilderImpl builder) {
        this.associateInProgressToken = builder.associateInProgressToken;
        this.linkedAccountsWithIncompleteSetup = builder.linkedAccountsWithIncompleteSetup;
    }

    /**
     * <p>
     * An Amazon Web Services access token generated by <code>WhatsAppSignupCallback</code> and used by
     * <code>WhatsAppSetupFinalization</code>.
     * </p>
     * 
     * @return An Amazon Web Services access token generated by <code>WhatsAppSignupCallback</code> and used by
     *         <code>WhatsAppSetupFinalization</code>.
     */
    public final String associateInProgressToken() {
        return associateInProgressToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LinkedAccountsWithIncompleteSetup
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasLinkedAccountsWithIncompleteSetup() {
        return linkedAccountsWithIncompleteSetup != null && !(linkedAccountsWithIncompleteSetup instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A LinkedWhatsAppBusinessAccountIdMetaData object map containing the details of any WhatsAppBusiness accounts that
     * have incomplete setup.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLinkedAccountsWithIncompleteSetup}
     * method.
     * </p>
     * 
     * @return A LinkedWhatsAppBusinessAccountIdMetaData object map containing the details of any WhatsAppBusiness
     *         accounts that have incomplete setup.
     */
    public final Map<String, LinkedWhatsAppBusinessAccountIdMetaData> linkedAccountsWithIncompleteSetup() {
        return linkedAccountsWithIncompleteSetup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associateInProgressToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasLinkedAccountsWithIncompleteSetup() ? linkedAccountsWithIncompleteSetup() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WhatsAppSignupCallbackResult)) {
            return false;
        }
        WhatsAppSignupCallbackResult other = (WhatsAppSignupCallbackResult) obj;
        return Objects.equals(associateInProgressToken(), other.associateInProgressToken())
                && hasLinkedAccountsWithIncompleteSetup() == other.hasLinkedAccountsWithIncompleteSetup()
                && Objects.equals(linkedAccountsWithIncompleteSetup(), other.linkedAccountsWithIncompleteSetup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("WhatsAppSignupCallbackResult")
                .add("AssociateInProgressToken", associateInProgressToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LinkedAccountsWithIncompleteSetup",
                        hasLinkedAccountsWithIncompleteSetup() ? linkedAccountsWithIncompleteSetup() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associateInProgressToken":
            return Optional.ofNullable(clazz.cast(associateInProgressToken()));
        case "linkedAccountsWithIncompleteSetup":
            return Optional.ofNullable(clazz.cast(linkedAccountsWithIncompleteSetup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("associateInProgressToken", ASSOCIATE_IN_PROGRESS_TOKEN_FIELD);
        map.put("linkedAccountsWithIncompleteSetup", LINKED_ACCOUNTS_WITH_INCOMPLETE_SETUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WhatsAppSignupCallbackResult, T> g) {
        return obj -> g.apply((WhatsAppSignupCallbackResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WhatsAppSignupCallbackResult> {
        /**
         * <p>
         * An Amazon Web Services access token generated by <code>WhatsAppSignupCallback</code> and used by
         * <code>WhatsAppSetupFinalization</code>.
         * </p>
         * 
         * @param associateInProgressToken
         *        An Amazon Web Services access token generated by <code>WhatsAppSignupCallback</code> and used by
         *        <code>WhatsAppSetupFinalization</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associateInProgressToken(String associateInProgressToken);

        /**
         * <p>
         * A LinkedWhatsAppBusinessAccountIdMetaData object map containing the details of any WhatsAppBusiness accounts
         * that have incomplete setup.
         * </p>
         * 
         * @param linkedAccountsWithIncompleteSetup
         *        A LinkedWhatsAppBusinessAccountIdMetaData object map containing the details of any WhatsAppBusiness
         *        accounts that have incomplete setup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedAccountsWithIncompleteSetup(
                Map<String, LinkedWhatsAppBusinessAccountIdMetaData> linkedAccountsWithIncompleteSetup);
    }

    static final class BuilderImpl implements Builder {
        private String associateInProgressToken;

        private Map<String, LinkedWhatsAppBusinessAccountIdMetaData> linkedAccountsWithIncompleteSetup = DefaultSdkAutoConstructMap
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WhatsAppSignupCallbackResult model) {
            associateInProgressToken(model.associateInProgressToken);
            linkedAccountsWithIncompleteSetup(model.linkedAccountsWithIncompleteSetup);
        }

        public final String getAssociateInProgressToken() {
            return associateInProgressToken;
        }

        public final void setAssociateInProgressToken(String associateInProgressToken) {
            this.associateInProgressToken = associateInProgressToken;
        }

        @Override
        public final Builder associateInProgressToken(String associateInProgressToken) {
            this.associateInProgressToken = associateInProgressToken;
            return this;
        }

        public final Map<String, LinkedWhatsAppBusinessAccountIdMetaData.Builder> getLinkedAccountsWithIncompleteSetup() {
            Map<String, LinkedWhatsAppBusinessAccountIdMetaData.Builder> result = LinkedAccountWithIncompleteSetupCopier
                    .copyToBuilder(this.linkedAccountsWithIncompleteSetup);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setLinkedAccountsWithIncompleteSetup(
                Map<String, LinkedWhatsAppBusinessAccountIdMetaData.BuilderImpl> linkedAccountsWithIncompleteSetup) {
            this.linkedAccountsWithIncompleteSetup = LinkedAccountWithIncompleteSetupCopier
                    .copyFromBuilder(linkedAccountsWithIncompleteSetup);
        }

        @Override
        public final Builder linkedAccountsWithIncompleteSetup(
                Map<String, LinkedWhatsAppBusinessAccountIdMetaData> linkedAccountsWithIncompleteSetup) {
            this.linkedAccountsWithIncompleteSetup = LinkedAccountWithIncompleteSetupCopier
                    .copy(linkedAccountsWithIncompleteSetup);
            return this;
        }

        @Override
        public WhatsAppSignupCallbackResult build() {
            return new WhatsAppSignupCallbackResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
