/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.socialmessaging.SocialMessagingAsyncClient;
import software.amazon.awssdk.services.socialmessaging.SocialMessagingServiceClientConfiguration;
import software.amazon.awssdk.services.socialmessaging.internal.SocialMessagingServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.socialmessaging.model.AccessDeniedByMetaException;
import software.amazon.awssdk.services.socialmessaging.model.AccessDeniedException;
import software.amazon.awssdk.services.socialmessaging.model.AssociateWhatsAppBusinessAccountRequest;
import software.amazon.awssdk.services.socialmessaging.model.AssociateWhatsAppBusinessAccountResponse;
import software.amazon.awssdk.services.socialmessaging.model.CreateWhatsAppMessageTemplateFromLibraryRequest;
import software.amazon.awssdk.services.socialmessaging.model.CreateWhatsAppMessageTemplateFromLibraryResponse;
import software.amazon.awssdk.services.socialmessaging.model.CreateWhatsAppMessageTemplateMediaRequest;
import software.amazon.awssdk.services.socialmessaging.model.CreateWhatsAppMessageTemplateMediaResponse;
import software.amazon.awssdk.services.socialmessaging.model.CreateWhatsAppMessageTemplateRequest;
import software.amazon.awssdk.services.socialmessaging.model.CreateWhatsAppMessageTemplateResponse;
import software.amazon.awssdk.services.socialmessaging.model.DeleteWhatsAppMessageMediaRequest;
import software.amazon.awssdk.services.socialmessaging.model.DeleteWhatsAppMessageMediaResponse;
import software.amazon.awssdk.services.socialmessaging.model.DeleteWhatsAppMessageTemplateRequest;
import software.amazon.awssdk.services.socialmessaging.model.DeleteWhatsAppMessageTemplateResponse;
import software.amazon.awssdk.services.socialmessaging.model.DependencyException;
import software.amazon.awssdk.services.socialmessaging.model.DisassociateWhatsAppBusinessAccountRequest;
import software.amazon.awssdk.services.socialmessaging.model.DisassociateWhatsAppBusinessAccountResponse;
import software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountPhoneNumberRequest;
import software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountPhoneNumberResponse;
import software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountRequest;
import software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountResponse;
import software.amazon.awssdk.services.socialmessaging.model.GetWhatsAppMessageMediaRequest;
import software.amazon.awssdk.services.socialmessaging.model.GetWhatsAppMessageMediaResponse;
import software.amazon.awssdk.services.socialmessaging.model.GetWhatsAppMessageTemplateRequest;
import software.amazon.awssdk.services.socialmessaging.model.GetWhatsAppMessageTemplateResponse;
import software.amazon.awssdk.services.socialmessaging.model.InternalServiceException;
import software.amazon.awssdk.services.socialmessaging.model.InvalidParametersException;
import software.amazon.awssdk.services.socialmessaging.model.LimitExceededException;
import software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest;
import software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsResponse;
import software.amazon.awssdk.services.socialmessaging.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.socialmessaging.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppMessageTemplatesRequest;
import software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppMessageTemplatesResponse;
import software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppTemplateLibraryRequest;
import software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppTemplateLibraryResponse;
import software.amazon.awssdk.services.socialmessaging.model.PostWhatsAppMessageMediaRequest;
import software.amazon.awssdk.services.socialmessaging.model.PostWhatsAppMessageMediaResponse;
import software.amazon.awssdk.services.socialmessaging.model.PutWhatsAppBusinessAccountEventDestinationsRequest;
import software.amazon.awssdk.services.socialmessaging.model.PutWhatsAppBusinessAccountEventDestinationsResponse;
import software.amazon.awssdk.services.socialmessaging.model.ResourceNotFoundException;
import software.amazon.awssdk.services.socialmessaging.model.SendWhatsAppMessageRequest;
import software.amazon.awssdk.services.socialmessaging.model.SendWhatsAppMessageResponse;
import software.amazon.awssdk.services.socialmessaging.model.SocialMessagingException;
import software.amazon.awssdk.services.socialmessaging.model.TagResourceRequest;
import software.amazon.awssdk.services.socialmessaging.model.TagResourceResponse;
import software.amazon.awssdk.services.socialmessaging.model.ThrottledRequestException;
import software.amazon.awssdk.services.socialmessaging.model.UntagResourceRequest;
import software.amazon.awssdk.services.socialmessaging.model.UntagResourceResponse;
import software.amazon.awssdk.services.socialmessaging.model.UpdateWhatsAppMessageTemplateRequest;
import software.amazon.awssdk.services.socialmessaging.model.UpdateWhatsAppMessageTemplateResponse;
import software.amazon.awssdk.services.socialmessaging.model.ValidationException;
import software.amazon.awssdk.services.socialmessaging.transform.AssociateWhatsAppBusinessAccountRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.CreateWhatsAppMessageTemplateFromLibraryRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.CreateWhatsAppMessageTemplateMediaRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.CreateWhatsAppMessageTemplateRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.DeleteWhatsAppMessageMediaRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.DeleteWhatsAppMessageTemplateRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.DisassociateWhatsAppBusinessAccountRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.GetLinkedWhatsAppBusinessAccountPhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.GetLinkedWhatsAppBusinessAccountRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.GetWhatsAppMessageMediaRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.GetWhatsAppMessageTemplateRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.ListLinkedWhatsAppBusinessAccountsRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.ListWhatsAppMessageTemplatesRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.ListWhatsAppTemplateLibraryRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.PostWhatsAppMessageMediaRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.PutWhatsAppBusinessAccountEventDestinationsRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.SendWhatsAppMessageRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.UpdateWhatsAppMessageTemplateRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultSocialMessagingAsyncClient
implements SocialMessagingAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSocialMessagingAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSocialMessagingAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"SocialMessaging#2.33.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AssociateWhatsAppBusinessAccountResponse> associateWhatsAppBusinessAccount(AssociateWhatsAppBusinessAccountRequest associateWhatsAppBusinessAccountRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateWhatsAppBusinessAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, associateWhatsAppBusinessAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateWhatsAppBusinessAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateWhatsAppBusinessAccountResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateWhatsAppBusinessAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AssociateWhatsAppBusinessAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateWhatsAppBusinessAccountRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$associateWhatsAppBusinessAccount$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$associateWhatsAppBusinessAccount$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateWhatsAppMessageTemplateResponse> createWhatsAppMessageTemplate(CreateWhatsAppMessageTemplateRequest createWhatsAppMessageTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createWhatsAppMessageTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, createWhatsAppMessageTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWhatsAppMessageTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWhatsAppMessageTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWhatsAppMessageTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateWhatsAppMessageTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createWhatsAppMessageTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$createWhatsAppMessageTemplate$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$createWhatsAppMessageTemplate$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateWhatsAppMessageTemplateFromLibraryResponse> createWhatsAppMessageTemplateFromLibrary(CreateWhatsAppMessageTemplateFromLibraryRequest createWhatsAppMessageTemplateFromLibraryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createWhatsAppMessageTemplateFromLibraryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, createWhatsAppMessageTemplateFromLibraryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWhatsAppMessageTemplateFromLibrary");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWhatsAppMessageTemplateFromLibraryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWhatsAppMessageTemplateFromLibrary").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateWhatsAppMessageTemplateFromLibraryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createWhatsAppMessageTemplateFromLibraryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$createWhatsAppMessageTemplateFromLibrary$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$createWhatsAppMessageTemplateFromLibrary$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateWhatsAppMessageTemplateMediaResponse> createWhatsAppMessageTemplateMedia(CreateWhatsAppMessageTemplateMediaRequest createWhatsAppMessageTemplateMediaRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createWhatsAppMessageTemplateMediaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, createWhatsAppMessageTemplateMediaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWhatsAppMessageTemplateMedia");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWhatsAppMessageTemplateMediaResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWhatsAppMessageTemplateMedia").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateWhatsAppMessageTemplateMediaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createWhatsAppMessageTemplateMediaRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$createWhatsAppMessageTemplateMedia$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$createWhatsAppMessageTemplateMedia$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteWhatsAppMessageMediaResponse> deleteWhatsAppMessageMedia(DeleteWhatsAppMessageMediaRequest deleteWhatsAppMessageMediaRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteWhatsAppMessageMediaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, deleteWhatsAppMessageMediaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWhatsAppMessageMedia");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWhatsAppMessageMediaResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWhatsAppMessageMedia").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteWhatsAppMessageMediaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteWhatsAppMessageMediaRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$deleteWhatsAppMessageMedia$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$deleteWhatsAppMessageMedia$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteWhatsAppMessageTemplateResponse> deleteWhatsAppMessageTemplate(DeleteWhatsAppMessageTemplateRequest deleteWhatsAppMessageTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteWhatsAppMessageTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, deleteWhatsAppMessageTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWhatsAppMessageTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWhatsAppMessageTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWhatsAppMessageTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteWhatsAppMessageTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteWhatsAppMessageTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$deleteWhatsAppMessageTemplate$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$deleteWhatsAppMessageTemplate$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateWhatsAppBusinessAccountResponse> disassociateWhatsAppBusinessAccount(DisassociateWhatsAppBusinessAccountRequest disassociateWhatsAppBusinessAccountRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateWhatsAppBusinessAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, disassociateWhatsAppBusinessAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateWhatsAppBusinessAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateWhatsAppBusinessAccountResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateWhatsAppBusinessAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisassociateWhatsAppBusinessAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disassociateWhatsAppBusinessAccountRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$disassociateWhatsAppBusinessAccount$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$disassociateWhatsAppBusinessAccount$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLinkedWhatsAppBusinessAccountResponse> getLinkedWhatsAppBusinessAccount(GetLinkedWhatsAppBusinessAccountRequest getLinkedWhatsAppBusinessAccountRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLinkedWhatsAppBusinessAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, getLinkedWhatsAppBusinessAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLinkedWhatsAppBusinessAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLinkedWhatsAppBusinessAccountResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLinkedWhatsAppBusinessAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLinkedWhatsAppBusinessAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLinkedWhatsAppBusinessAccountRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$getLinkedWhatsAppBusinessAccount$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$getLinkedWhatsAppBusinessAccount$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLinkedWhatsAppBusinessAccountPhoneNumberResponse> getLinkedWhatsAppBusinessAccountPhoneNumber(GetLinkedWhatsAppBusinessAccountPhoneNumberRequest getLinkedWhatsAppBusinessAccountPhoneNumberRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLinkedWhatsAppBusinessAccountPhoneNumberRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, getLinkedWhatsAppBusinessAccountPhoneNumberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLinkedWhatsAppBusinessAccountPhoneNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLinkedWhatsAppBusinessAccountPhoneNumberResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLinkedWhatsAppBusinessAccountPhoneNumber").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLinkedWhatsAppBusinessAccountPhoneNumberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLinkedWhatsAppBusinessAccountPhoneNumberRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$getLinkedWhatsAppBusinessAccountPhoneNumber$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$getLinkedWhatsAppBusinessAccountPhoneNumber$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetWhatsAppMessageMediaResponse> getWhatsAppMessageMedia(GetWhatsAppMessageMediaRequest getWhatsAppMessageMediaRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getWhatsAppMessageMediaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, getWhatsAppMessageMediaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWhatsAppMessageMedia");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWhatsAppMessageMediaResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWhatsAppMessageMedia").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetWhatsAppMessageMediaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getWhatsAppMessageMediaRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$getWhatsAppMessageMedia$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$getWhatsAppMessageMedia$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetWhatsAppMessageTemplateResponse> getWhatsAppMessageTemplate(GetWhatsAppMessageTemplateRequest getWhatsAppMessageTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getWhatsAppMessageTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, getWhatsAppMessageTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWhatsAppMessageTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWhatsAppMessageTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWhatsAppMessageTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetWhatsAppMessageTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getWhatsAppMessageTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$getWhatsAppMessageTemplate$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$getWhatsAppMessageTemplate$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLinkedWhatsAppBusinessAccountsResponse> listLinkedWhatsAppBusinessAccounts(ListLinkedWhatsAppBusinessAccountsRequest listLinkedWhatsAppBusinessAccountsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLinkedWhatsAppBusinessAccountsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, listLinkedWhatsAppBusinessAccountsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLinkedWhatsAppBusinessAccounts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLinkedWhatsAppBusinessAccountsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLinkedWhatsAppBusinessAccounts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLinkedWhatsAppBusinessAccountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLinkedWhatsAppBusinessAccountsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$listLinkedWhatsAppBusinessAccounts$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$listLinkedWhatsAppBusinessAccounts$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$listTagsForResource$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$listTagsForResource$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListWhatsAppMessageTemplatesResponse> listWhatsAppMessageTemplates(ListWhatsAppMessageTemplatesRequest listWhatsAppMessageTemplatesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listWhatsAppMessageTemplatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, listWhatsAppMessageTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWhatsAppMessageTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWhatsAppMessageTemplatesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWhatsAppMessageTemplates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListWhatsAppMessageTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listWhatsAppMessageTemplatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$listWhatsAppMessageTemplates$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$listWhatsAppMessageTemplates$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListWhatsAppTemplateLibraryResponse> listWhatsAppTemplateLibrary(ListWhatsAppTemplateLibraryRequest listWhatsAppTemplateLibraryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listWhatsAppTemplateLibraryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, listWhatsAppTemplateLibraryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWhatsAppTemplateLibrary");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWhatsAppTemplateLibraryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWhatsAppTemplateLibrary").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListWhatsAppTemplateLibraryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listWhatsAppTemplateLibraryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$listWhatsAppTemplateLibrary$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$listWhatsAppTemplateLibrary$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PostWhatsAppMessageMediaResponse> postWhatsAppMessageMedia(PostWhatsAppMessageMediaRequest postWhatsAppMessageMediaRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)postWhatsAppMessageMediaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, postWhatsAppMessageMediaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PostWhatsAppMessageMedia");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PostWhatsAppMessageMediaResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PostWhatsAppMessageMedia").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PostWhatsAppMessageMediaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)postWhatsAppMessageMediaRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$postWhatsAppMessageMedia$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$postWhatsAppMessageMedia$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutWhatsAppBusinessAccountEventDestinationsResponse> putWhatsAppBusinessAccountEventDestinations(PutWhatsAppBusinessAccountEventDestinationsRequest putWhatsAppBusinessAccountEventDestinationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putWhatsAppBusinessAccountEventDestinationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, putWhatsAppBusinessAccountEventDestinationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutWhatsAppBusinessAccountEventDestinations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutWhatsAppBusinessAccountEventDestinationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutWhatsAppBusinessAccountEventDestinations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutWhatsAppBusinessAccountEventDestinationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putWhatsAppBusinessAccountEventDestinationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$putWhatsAppBusinessAccountEventDestinations$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$putWhatsAppBusinessAccountEventDestinations$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SendWhatsAppMessageResponse> sendWhatsAppMessage(SendWhatsAppMessageRequest sendWhatsAppMessageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendWhatsAppMessageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, sendWhatsAppMessageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendWhatsAppMessage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendWhatsAppMessageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendWhatsAppMessage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SendWhatsAppMessageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)sendWhatsAppMessageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$sendWhatsAppMessage$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$sendWhatsAppMessage$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$tagResource$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$tagResource$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$untagResource$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$untagResource$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateWhatsAppMessageTemplateResponse> updateWhatsAppMessageTemplate(UpdateWhatsAppMessageTemplateRequest updateWhatsAppMessageTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateWhatsAppMessageTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingAsyncClient.resolveMetricPublishers(clientConfiguration, updateWhatsAppMessageTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWhatsAppMessageTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWhatsAppMessageTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ThrottledRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                    }
                    case "AccessDeniedByMetaException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                    }
                    case "DependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWhatsAppMessageTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateWhatsAppMessageTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateWhatsAppMessageTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSocialMessagingAsyncClient.lambda$updateWhatsAppMessageTemplate$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingAsyncClient.lambda$updateWhatsAppMessageTemplate$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final SocialMessagingServiceClientConfiguration serviceClientConfiguration() {
        return new SocialMessagingServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "social-messaging";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SocialMessagingException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        SocialMessagingServiceClientConfigurationBuilder serviceConfigBuilder = new SocialMessagingServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateWhatsAppMessageTemplate$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateWhatsAppMessageTemplate$82(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateWhatsAppMessageTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$78(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$74(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$sendWhatsAppMessage$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendWhatsAppMessage$70(List metricPublishers, MetricCollector apiCallMetricCollector, SendWhatsAppMessageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putWhatsAppBusinessAccountEventDestinations$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putWhatsAppBusinessAccountEventDestinations$66(List metricPublishers, MetricCollector apiCallMetricCollector, PutWhatsAppBusinessAccountEventDestinationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$postWhatsAppMessageMedia$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$postWhatsAppMessageMedia$62(List metricPublishers, MetricCollector apiCallMetricCollector, PostWhatsAppMessageMediaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listWhatsAppTemplateLibrary$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWhatsAppTemplateLibrary$58(List metricPublishers, MetricCollector apiCallMetricCollector, ListWhatsAppTemplateLibraryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listWhatsAppMessageTemplates$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWhatsAppMessageTemplates$54(List metricPublishers, MetricCollector apiCallMetricCollector, ListWhatsAppMessageTemplatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$50(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listLinkedWhatsAppBusinessAccounts$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLinkedWhatsAppBusinessAccounts$46(List metricPublishers, MetricCollector apiCallMetricCollector, ListLinkedWhatsAppBusinessAccountsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getWhatsAppMessageTemplate$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWhatsAppMessageTemplate$42(List metricPublishers, MetricCollector apiCallMetricCollector, GetWhatsAppMessageTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getWhatsAppMessageMedia$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWhatsAppMessageMedia$38(List metricPublishers, MetricCollector apiCallMetricCollector, GetWhatsAppMessageMediaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLinkedWhatsAppBusinessAccountPhoneNumber$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLinkedWhatsAppBusinessAccountPhoneNumber$34(List metricPublishers, MetricCollector apiCallMetricCollector, GetLinkedWhatsAppBusinessAccountPhoneNumberResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLinkedWhatsAppBusinessAccount$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLinkedWhatsAppBusinessAccount$30(List metricPublishers, MetricCollector apiCallMetricCollector, GetLinkedWhatsAppBusinessAccountResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disassociateWhatsAppBusinessAccount$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateWhatsAppBusinessAccount$26(List metricPublishers, MetricCollector apiCallMetricCollector, DisassociateWhatsAppBusinessAccountResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteWhatsAppMessageTemplate$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWhatsAppMessageTemplate$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteWhatsAppMessageTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteWhatsAppMessageMedia$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWhatsAppMessageMedia$18(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteWhatsAppMessageMediaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createWhatsAppMessageTemplateMedia$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWhatsAppMessageTemplateMedia$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreateWhatsAppMessageTemplateMediaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createWhatsAppMessageTemplateFromLibrary$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWhatsAppMessageTemplateFromLibrary$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateWhatsAppMessageTemplateFromLibraryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createWhatsAppMessageTemplate$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWhatsAppMessageTemplate$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateWhatsAppMessageTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associateWhatsAppBusinessAccount$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateWhatsAppBusinessAccount$2(List metricPublishers, MetricCollector apiCallMetricCollector, AssociateWhatsAppBusinessAccountResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

