/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.socialmessaging.model.LibraryTemplateButtonList;
import software.amazon.awssdk.services.socialmessaging.model.MetaIndustriesCopier;
import software.amazon.awssdk.services.socialmessaging.model.MetaLibraryTemplateButtonListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetaLibraryTemplateDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetaLibraryTemplateDefinition> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(MetaLibraryTemplateDefinition.getter(MetaLibraryTemplateDefinition::templateName)).setter(MetaLibraryTemplateDefinition.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()}).build();
    private static final SdkField<String> TEMPLATE_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateLanguage").getter(MetaLibraryTemplateDefinition.getter(MetaLibraryTemplateDefinition::templateLanguage)).setter(MetaLibraryTemplateDefinition.setter(Builder::templateLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateLanguage").build()}).build();
    private static final SdkField<String> TEMPLATE_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateCategory").getter(MetaLibraryTemplateDefinition.getter(MetaLibraryTemplateDefinition::templateCategory)).setter(MetaLibraryTemplateDefinition.setter(Builder::templateCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateCategory").build()}).build();
    private static final SdkField<String> TEMPLATE_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateTopic").getter(MetaLibraryTemplateDefinition.getter(MetaLibraryTemplateDefinition::templateTopic)).setter(MetaLibraryTemplateDefinition.setter(Builder::templateTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateTopic").build()}).build();
    private static final SdkField<String> TEMPLATE_USE_CASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateUseCase").getter(MetaLibraryTemplateDefinition.getter(MetaLibraryTemplateDefinition::templateUseCase)).setter(MetaLibraryTemplateDefinition.setter(Builder::templateUseCase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateUseCase").build()}).build();
    private static final SdkField<List<String>> TEMPLATE_INDUSTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("templateIndustry").getter(MetaLibraryTemplateDefinition.getter(MetaLibraryTemplateDefinition::templateIndustry)).setter(MetaLibraryTemplateDefinition.setter(Builder::templateIndustry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateIndustry").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateHeader").getter(MetaLibraryTemplateDefinition.getter(MetaLibraryTemplateDefinition::templateHeader)).setter(MetaLibraryTemplateDefinition.setter(Builder::templateHeader)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateHeader").build()}).build();
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateBody").getter(MetaLibraryTemplateDefinition.getter(MetaLibraryTemplateDefinition::templateBody)).setter(MetaLibraryTemplateDefinition.setter(Builder::templateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateBody").build()}).build();
    private static final SdkField<List<LibraryTemplateButtonList>> TEMPLATE_BUTTONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("templateButtons").getter(MetaLibraryTemplateDefinition.getter(MetaLibraryTemplateDefinition::templateButtons)).setter(MetaLibraryTemplateDefinition.setter(Builder::templateButtons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateButtons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LibraryTemplateButtonList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateId").getter(MetaLibraryTemplateDefinition.getter(MetaLibraryTemplateDefinition::templateId)).setter(MetaLibraryTemplateDefinition.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD, TEMPLATE_LANGUAGE_FIELD, TEMPLATE_CATEGORY_FIELD, TEMPLATE_TOPIC_FIELD, TEMPLATE_USE_CASE_FIELD, TEMPLATE_INDUSTRY_FIELD, TEMPLATE_HEADER_FIELD, TEMPLATE_BODY_FIELD, TEMPLATE_BUTTONS_FIELD, TEMPLATE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetaLibraryTemplateDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String templateName;
    private final String templateLanguage;
    private final String templateCategory;
    private final String templateTopic;
    private final String templateUseCase;
    private final List<String> templateIndustry;
    private final String templateHeader;
    private final String templateBody;
    private final List<LibraryTemplateButtonList> templateButtons;
    private final String templateId;

    private MetaLibraryTemplateDefinition(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.templateLanguage = builder.templateLanguage;
        this.templateCategory = builder.templateCategory;
        this.templateTopic = builder.templateTopic;
        this.templateUseCase = builder.templateUseCase;
        this.templateIndustry = builder.templateIndustry;
        this.templateHeader = builder.templateHeader;
        this.templateBody = builder.templateBody;
        this.templateButtons = builder.templateButtons;
        this.templateId = builder.templateId;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String templateLanguage() {
        return this.templateLanguage;
    }

    public final String templateCategory() {
        return this.templateCategory;
    }

    public final String templateTopic() {
        return this.templateTopic;
    }

    public final String templateUseCase() {
        return this.templateUseCase;
    }

    public final boolean hasTemplateIndustry() {
        return this.templateIndustry != null && !(this.templateIndustry instanceof SdkAutoConstructList);
    }

    public final List<String> templateIndustry() {
        return this.templateIndustry;
    }

    public final String templateHeader() {
        return this.templateHeader;
    }

    public final String templateBody() {
        return this.templateBody;
    }

    public final boolean hasTemplateButtons() {
        return this.templateButtons != null && !(this.templateButtons instanceof SdkAutoConstructList);
    }

    public final List<LibraryTemplateButtonList> templateButtons() {
        return this.templateButtons;
    }

    public final String templateId() {
        return this.templateId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateCategory());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateUseCase());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplateIndustry() ? this.templateIndustry() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templateHeader());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplateButtons() ? this.templateButtons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetaLibraryTemplateDefinition)) {
            return false;
        }
        MetaLibraryTemplateDefinition other = (MetaLibraryTemplateDefinition)obj;
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.templateLanguage(), other.templateLanguage()) && Objects.equals(this.templateCategory(), other.templateCategory()) && Objects.equals(this.templateTopic(), other.templateTopic()) && Objects.equals(this.templateUseCase(), other.templateUseCase()) && this.hasTemplateIndustry() == other.hasTemplateIndustry() && Objects.equals(this.templateIndustry(), other.templateIndustry()) && Objects.equals(this.templateHeader(), other.templateHeader()) && Objects.equals(this.templateBody(), other.templateBody()) && this.hasTemplateButtons() == other.hasTemplateButtons() && Objects.equals(this.templateButtons(), other.templateButtons()) && Objects.equals(this.templateId(), other.templateId());
    }

    public final String toString() {
        return ToString.builder((String)"MetaLibraryTemplateDefinition").add("TemplateName", (Object)this.templateName()).add("TemplateLanguage", (Object)this.templateLanguage()).add("TemplateCategory", (Object)this.templateCategory()).add("TemplateTopic", (Object)this.templateTopic()).add("TemplateUseCase", (Object)this.templateUseCase()).add("TemplateIndustry", this.hasTemplateIndustry() ? this.templateIndustry() : null).add("TemplateHeader", (Object)this.templateHeader()).add("TemplateBody", (Object)this.templateBody()).add("TemplateButtons", this.hasTemplateButtons() ? this.templateButtons() : null).add("TemplateId", (Object)this.templateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "templateLanguage": {
                return Optional.ofNullable(clazz.cast(this.templateLanguage()));
            }
            case "templateCategory": {
                return Optional.ofNullable(clazz.cast(this.templateCategory()));
            }
            case "templateTopic": {
                return Optional.ofNullable(clazz.cast(this.templateTopic()));
            }
            case "templateUseCase": {
                return Optional.ofNullable(clazz.cast(this.templateUseCase()));
            }
            case "templateIndustry": {
                return Optional.ofNullable(clazz.cast(this.templateIndustry()));
            }
            case "templateHeader": {
                return Optional.ofNullable(clazz.cast(this.templateHeader()));
            }
            case "templateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "templateButtons": {
                return Optional.ofNullable(clazz.cast(this.templateButtons()));
            }
            case "templateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("templateName", TEMPLATE_NAME_FIELD);
        map.put("templateLanguage", TEMPLATE_LANGUAGE_FIELD);
        map.put("templateCategory", TEMPLATE_CATEGORY_FIELD);
        map.put("templateTopic", TEMPLATE_TOPIC_FIELD);
        map.put("templateUseCase", TEMPLATE_USE_CASE_FIELD);
        map.put("templateIndustry", TEMPLATE_INDUSTRY_FIELD);
        map.put("templateHeader", TEMPLATE_HEADER_FIELD);
        map.put("templateBody", TEMPLATE_BODY_FIELD);
        map.put("templateButtons", TEMPLATE_BUTTONS_FIELD);
        map.put("templateId", TEMPLATE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetaLibraryTemplateDefinition, T> g) {
        return obj -> g.apply((MetaLibraryTemplateDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String templateName;
        private String templateLanguage;
        private String templateCategory;
        private String templateTopic;
        private String templateUseCase;
        private List<String> templateIndustry = DefaultSdkAutoConstructList.getInstance();
        private String templateHeader;
        private String templateBody;
        private List<LibraryTemplateButtonList> templateButtons = DefaultSdkAutoConstructList.getInstance();
        private String templateId;

        private BuilderImpl() {
        }

        private BuilderImpl(MetaLibraryTemplateDefinition model) {
            this.templateName(model.templateName);
            this.templateLanguage(model.templateLanguage);
            this.templateCategory(model.templateCategory);
            this.templateTopic(model.templateTopic);
            this.templateUseCase(model.templateUseCase);
            this.templateIndustry(model.templateIndustry);
            this.templateHeader(model.templateHeader);
            this.templateBody(model.templateBody);
            this.templateButtons(model.templateButtons);
            this.templateId(model.templateId);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateLanguage() {
            return this.templateLanguage;
        }

        public final void setTemplateLanguage(String templateLanguage) {
            this.templateLanguage = templateLanguage;
        }

        @Override
        public final Builder templateLanguage(String templateLanguage) {
            this.templateLanguage = templateLanguage;
            return this;
        }

        public final String getTemplateCategory() {
            return this.templateCategory;
        }

        public final void setTemplateCategory(String templateCategory) {
            this.templateCategory = templateCategory;
        }

        @Override
        public final Builder templateCategory(String templateCategory) {
            this.templateCategory = templateCategory;
            return this;
        }

        public final String getTemplateTopic() {
            return this.templateTopic;
        }

        public final void setTemplateTopic(String templateTopic) {
            this.templateTopic = templateTopic;
        }

        @Override
        public final Builder templateTopic(String templateTopic) {
            this.templateTopic = templateTopic;
            return this;
        }

        public final String getTemplateUseCase() {
            return this.templateUseCase;
        }

        public final void setTemplateUseCase(String templateUseCase) {
            this.templateUseCase = templateUseCase;
        }

        @Override
        public final Builder templateUseCase(String templateUseCase) {
            this.templateUseCase = templateUseCase;
            return this;
        }

        public final Collection<String> getTemplateIndustry() {
            if (this.templateIndustry instanceof SdkAutoConstructList) {
                return null;
            }
            return this.templateIndustry;
        }

        public final void setTemplateIndustry(Collection<String> templateIndustry) {
            this.templateIndustry = MetaIndustriesCopier.copy(templateIndustry);
        }

        @Override
        public final Builder templateIndustry(Collection<String> templateIndustry) {
            this.templateIndustry = MetaIndustriesCopier.copy(templateIndustry);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateIndustry(String ... templateIndustry) {
            this.templateIndustry(Arrays.asList(templateIndustry));
            return this;
        }

        public final String getTemplateHeader() {
            return this.templateHeader;
        }

        public final void setTemplateHeader(String templateHeader) {
            this.templateHeader = templateHeader;
        }

        @Override
        public final Builder templateHeader(String templateHeader) {
            this.templateHeader = templateHeader;
            return this;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final List<LibraryTemplateButtonList.Builder> getTemplateButtons() {
            List<LibraryTemplateButtonList.Builder> result = MetaLibraryTemplateButtonListCopier.copyToBuilder(this.templateButtons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplateButtons(Collection<LibraryTemplateButtonList.BuilderImpl> templateButtons) {
            this.templateButtons = MetaLibraryTemplateButtonListCopier.copyFromBuilder(templateButtons);
        }

        @Override
        public final Builder templateButtons(Collection<LibraryTemplateButtonList> templateButtons) {
            this.templateButtons = MetaLibraryTemplateButtonListCopier.copy(templateButtons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateButtons(LibraryTemplateButtonList ... templateButtons) {
            this.templateButtons(Arrays.asList(templateButtons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateButtons(Consumer<LibraryTemplateButtonList.Builder> ... templateButtons) {
            this.templateButtons(Stream.of(templateButtons).map(c -> (LibraryTemplateButtonList)((LibraryTemplateButtonList.Builder)LibraryTemplateButtonList.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public MetaLibraryTemplateDefinition build() {
            return new MetaLibraryTemplateDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetaLibraryTemplateDefinition> {
        public Builder templateName(String var1);

        public Builder templateLanguage(String var1);

        public Builder templateCategory(String var1);

        public Builder templateTopic(String var1);

        public Builder templateUseCase(String var1);

        public Builder templateIndustry(Collection<String> var1);

        public Builder templateIndustry(String ... var1);

        public Builder templateHeader(String var1);

        public Builder templateBody(String var1);

        public Builder templateButtons(Collection<LibraryTemplateButtonList> var1);

        public Builder templateButtons(LibraryTemplateButtonList ... var1);

        public Builder templateButtons(Consumer<LibraryTemplateButtonList.Builder> ... var1);

        public Builder templateId(String var1);
    }
}

