/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.socialmessaging.SocialMessagingClient;
import software.amazon.awssdk.services.socialmessaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppTemplateLibraryRequest;
import software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppTemplateLibraryResponse;
import software.amazon.awssdk.services.socialmessaging.model.MetaLibraryTemplateDefinition;

public class ListWhatsAppTemplateLibraryIterable
implements SdkIterable<ListWhatsAppTemplateLibraryResponse> {
    private final SocialMessagingClient client;
    private final ListWhatsAppTemplateLibraryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWhatsAppTemplateLibraryIterable(SocialMessagingClient client, ListWhatsAppTemplateLibraryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWhatsAppTemplateLibraryResponseFetcher();
    }

    public Iterator<ListWhatsAppTemplateLibraryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MetaLibraryTemplateDefinition> metaLibraryTemplates() {
        Function<ListWhatsAppTemplateLibraryResponse, Iterator> getIterator = response -> {
            if (response != null && response.metaLibraryTemplates() != null) {
                return response.metaLibraryTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWhatsAppTemplateLibraryResponseFetcher
    implements SyncPageFetcher<ListWhatsAppTemplateLibraryResponse> {
        private ListWhatsAppTemplateLibraryResponseFetcher() {
        }

        public boolean hasNextPage(ListWhatsAppTemplateLibraryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWhatsAppTemplateLibraryResponse nextPage(ListWhatsAppTemplateLibraryResponse previousPage) {
            if (previousPage == null) {
                return ListWhatsAppTemplateLibraryIterable.this.client.listWhatsAppTemplateLibrary(ListWhatsAppTemplateLibraryIterable.this.firstRequest);
            }
            return ListWhatsAppTemplateLibraryIterable.this.client.listWhatsAppTemplateLibrary((ListWhatsAppTemplateLibraryRequest)((Object)ListWhatsAppTemplateLibraryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

