/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWhatsAppMessageTemplateFromLibraryRequest extends SocialMessagingRequest
        implements
        ToCopyableBuilder<CreateWhatsAppMessageTemplateFromLibraryRequest.Builder, CreateWhatsAppMessageTemplateFromLibraryRequest> {
    private static final SdkField<MetaLibraryTemplate> META_LIBRARY_TEMPLATE_FIELD = SdkField
            .<MetaLibraryTemplate> builder(MarshallingType.SDK_POJO).memberName("metaLibraryTemplate")
            .getter(getter(CreateWhatsAppMessageTemplateFromLibraryRequest::metaLibraryTemplate))
            .setter(setter(Builder::metaLibraryTemplate)).constructor(MetaLibraryTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metaLibraryTemplate").build())
            .build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateWhatsAppMessageTemplateFromLibraryRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(META_LIBRARY_TEMPLATE_FIELD,
            ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final MetaLibraryTemplate metaLibraryTemplate;

    private final String id;

    private CreateWhatsAppMessageTemplateFromLibraryRequest(BuilderImpl builder) {
        super(builder);
        this.metaLibraryTemplate = builder.metaLibraryTemplate;
        this.id = builder.id;
    }

    /**
     * <p>
     * The template configuration from Meta's library, including customizations for buttons and body text.
     * </p>
     * 
     * @return The template configuration from Meta's library, including customizations for buttons and body text.
     */
    public final MetaLibraryTemplate metaLibraryTemplate() {
        return metaLibraryTemplate;
    }

    /**
     * <p>
     * The ID of the WhatsApp Business Account to associate with this template.
     * </p>
     * 
     * @return The ID of the WhatsApp Business Account to associate with this template.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metaLibraryTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWhatsAppMessageTemplateFromLibraryRequest)) {
            return false;
        }
        CreateWhatsAppMessageTemplateFromLibraryRequest other = (CreateWhatsAppMessageTemplateFromLibraryRequest) obj;
        return Objects.equals(metaLibraryTemplate(), other.metaLibraryTemplate()) && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWhatsAppMessageTemplateFromLibraryRequest")
                .add("MetaLibraryTemplate", metaLibraryTemplate()).add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metaLibraryTemplate":
            return Optional.ofNullable(clazz.cast(metaLibraryTemplate()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metaLibraryTemplate", META_LIBRARY_TEMPLATE_FIELD);
        map.put("id", ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWhatsAppMessageTemplateFromLibraryRequest, T> g) {
        return obj -> g.apply((CreateWhatsAppMessageTemplateFromLibraryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SocialMessagingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateWhatsAppMessageTemplateFromLibraryRequest> {
        /**
         * <p>
         * The template configuration from Meta's library, including customizations for buttons and body text.
         * </p>
         * 
         * @param metaLibraryTemplate
         *        The template configuration from Meta's library, including customizations for buttons and body text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metaLibraryTemplate(MetaLibraryTemplate metaLibraryTemplate);

        /**
         * <p>
         * The template configuration from Meta's library, including customizations for buttons and body text.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetaLibraryTemplate.Builder} avoiding the
         * need to create one manually via {@link MetaLibraryTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetaLibraryTemplate.Builder#build()} is called immediately and
         * its result is passed to {@link #metaLibraryTemplate(MetaLibraryTemplate)}.
         * 
         * @param metaLibraryTemplate
         *        a consumer that will call methods on {@link MetaLibraryTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metaLibraryTemplate(MetaLibraryTemplate)
         */
        default Builder metaLibraryTemplate(Consumer<MetaLibraryTemplate.Builder> metaLibraryTemplate) {
            return metaLibraryTemplate(MetaLibraryTemplate.builder().applyMutation(metaLibraryTemplate).build());
        }

        /**
         * <p>
         * The ID of the WhatsApp Business Account to associate with this template.
         * </p>
         * 
         * @param id
         *        The ID of the WhatsApp Business Account to associate with this template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SocialMessagingRequest.BuilderImpl implements Builder {
        private MetaLibraryTemplate metaLibraryTemplate;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWhatsAppMessageTemplateFromLibraryRequest model) {
            super(model);
            metaLibraryTemplate(model.metaLibraryTemplate);
            id(model.id);
        }

        public final MetaLibraryTemplate.Builder getMetaLibraryTemplate() {
            return metaLibraryTemplate != null ? metaLibraryTemplate.toBuilder() : null;
        }

        public final void setMetaLibraryTemplate(MetaLibraryTemplate.BuilderImpl metaLibraryTemplate) {
            this.metaLibraryTemplate = metaLibraryTemplate != null ? metaLibraryTemplate.build() : null;
        }

        @Override
        public final Builder metaLibraryTemplate(MetaLibraryTemplate metaLibraryTemplate) {
            this.metaLibraryTemplate = metaLibraryTemplate;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWhatsAppMessageTemplateFromLibraryRequest build() {
            return new CreateWhatsAppMessageTemplateFromLibraryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
