/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWhatsAppMessageTemplateMediaRequest extends SocialMessagingRequest implements
        ToCopyableBuilder<CreateWhatsAppMessageTemplateMediaRequest.Builder, CreateWhatsAppMessageTemplateMediaRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateWhatsAppMessageTemplateMediaRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<S3File> SOURCE_S3_FILE_FIELD = SdkField.<S3File> builder(MarshallingType.SDK_POJO)
            .memberName("sourceS3File").getter(getter(CreateWhatsAppMessageTemplateMediaRequest::sourceS3File))
            .setter(setter(Builder::sourceS3File)).constructor(S3File::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceS3File").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ID_FIELD, SOURCE_S3_FILE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final S3File sourceS3File;

    private CreateWhatsAppMessageTemplateMediaRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.sourceS3File = builder.sourceS3File;
    }

    /**
     * <p>
     * The ID of the WhatsApp Business Account associated with this media upload.
     * </p>
     * 
     * @return The ID of the WhatsApp Business Account associated with this media upload.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the SourceS3File property for this object.
     * 
     * @return The value of the SourceS3File property for this object.
     */
    public final S3File sourceS3File() {
        return sourceS3File;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(sourceS3File());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWhatsAppMessageTemplateMediaRequest)) {
            return false;
        }
        CreateWhatsAppMessageTemplateMediaRequest other = (CreateWhatsAppMessageTemplateMediaRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(sourceS3File(), other.sourceS3File());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWhatsAppMessageTemplateMediaRequest").add("Id", id())
                .add("SourceS3File", sourceS3File() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "sourceS3File":
            return Optional.ofNullable(clazz.cast(sourceS3File()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("sourceS3File", SOURCE_S3_FILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWhatsAppMessageTemplateMediaRequest, T> g) {
        return obj -> g.apply((CreateWhatsAppMessageTemplateMediaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SocialMessagingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateWhatsAppMessageTemplateMediaRequest> {
        /**
         * <p>
         * The ID of the WhatsApp Business Account associated with this media upload.
         * </p>
         * 
         * @param id
         *        The ID of the WhatsApp Business Account associated with this media upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the SourceS3File property for this object.
         *
         * @param sourceS3File
         *        The new value for the SourceS3File property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceS3File(S3File sourceS3File);

        /**
         * Sets the value of the SourceS3File property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3File.Builder} avoiding the need to
         * create one manually via {@link S3File#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3File.Builder#build()} is called immediately and its result is
         * passed to {@link #sourceS3File(S3File)}.
         * 
         * @param sourceS3File
         *        a consumer that will call methods on {@link S3File.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceS3File(S3File)
         */
        default Builder sourceS3File(Consumer<S3File.Builder> sourceS3File) {
            return sourceS3File(S3File.builder().applyMutation(sourceS3File).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SocialMessagingRequest.BuilderImpl implements Builder {
        private String id;

        private S3File sourceS3File;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWhatsAppMessageTemplateMediaRequest model) {
            super(model);
            id(model.id);
            sourceS3File(model.sourceS3File);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final S3File.Builder getSourceS3File() {
            return sourceS3File != null ? sourceS3File.toBuilder() : null;
        }

        public final void setSourceS3File(S3File.BuilderImpl sourceS3File) {
            this.sourceS3File = sourceS3File != null ? sourceS3File.build() : null;
        }

        @Override
        public final Builder sourceS3File(S3File sourceS3File) {
            this.sourceS3File = sourceS3File;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWhatsAppMessageTemplateMediaRequest build() {
            return new CreateWhatsAppMessageTemplateMediaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
