/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteWhatsAppMessageTemplateRequest extends SocialMessagingRequest implements
        ToCopyableBuilder<DeleteWhatsAppMessageTemplateRequest.Builder, DeleteWhatsAppMessageTemplateRequest> {
    private static final SdkField<String> META_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metaTemplateId").getter(getter(DeleteWhatsAppMessageTemplateRequest::metaTemplateId))
            .setter(setter(Builder::metaTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("metaTemplateId").build())
            .build();

    private static final SdkField<Boolean> DELETE_ALL_LANGUAGES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deleteAllLanguages").getter(getter(DeleteWhatsAppMessageTemplateRequest::deleteAllLanguages))
            .setter(setter(Builder::deleteAllLanguages))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("deleteAllTemplates").build())
            .build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(DeleteWhatsAppMessageTemplateRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("id").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(DeleteWhatsAppMessageTemplateRequest::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("templateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(META_TEMPLATE_ID_FIELD,
            DELETE_ALL_LANGUAGES_FIELD, ID_FIELD, TEMPLATE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String metaTemplateId;

    private final Boolean deleteAllLanguages;

    private final String id;

    private final String templateName;

    private DeleteWhatsAppMessageTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.metaTemplateId = builder.metaTemplateId;
        this.deleteAllLanguages = builder.deleteAllLanguages;
        this.id = builder.id;
        this.templateName = builder.templateName;
    }

    /**
     * <p>
     * The numeric ID of the template assigned by Meta.
     * </p>
     * 
     * @return The numeric ID of the template assigned by Meta.
     */
    public final String metaTemplateId() {
        return metaTemplateId;
    }

    /**
     * <p>
     * If true, deletes all language versions of the template.
     * </p>
     * 
     * @return If true, deletes all language versions of the template.
     */
    public final Boolean deleteAllLanguages() {
        return deleteAllLanguages;
    }

    /**
     * <p>
     * The ID of the WhatsApp Business Account associated with this template.
     * </p>
     * 
     * @return The ID of the WhatsApp Business Account associated with this template.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the template to delete.
     * </p>
     * 
     * @return The name of the template to delete.
     */
    public final String templateName() {
        return templateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metaTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(deleteAllLanguages());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteWhatsAppMessageTemplateRequest)) {
            return false;
        }
        DeleteWhatsAppMessageTemplateRequest other = (DeleteWhatsAppMessageTemplateRequest) obj;
        return Objects.equals(metaTemplateId(), other.metaTemplateId())
                && Objects.equals(deleteAllLanguages(), other.deleteAllLanguages()) && Objects.equals(id(), other.id())
                && Objects.equals(templateName(), other.templateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteWhatsAppMessageTemplateRequest").add("MetaTemplateId", metaTemplateId())
                .add("DeleteAllLanguages", deleteAllLanguages()).add("Id", id()).add("TemplateName", templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metaTemplateId":
            return Optional.ofNullable(clazz.cast(metaTemplateId()));
        case "deleteAllLanguages":
            return Optional.ofNullable(clazz.cast(deleteAllLanguages()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metaTemplateId", META_TEMPLATE_ID_FIELD);
        map.put("deleteAllTemplates", DELETE_ALL_LANGUAGES_FIELD);
        map.put("id", ID_FIELD);
        map.put("templateName", TEMPLATE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteWhatsAppMessageTemplateRequest, T> g) {
        return obj -> g.apply((DeleteWhatsAppMessageTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SocialMessagingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteWhatsAppMessageTemplateRequest> {
        /**
         * <p>
         * The numeric ID of the template assigned by Meta.
         * </p>
         * 
         * @param metaTemplateId
         *        The numeric ID of the template assigned by Meta.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metaTemplateId(String metaTemplateId);

        /**
         * <p>
         * If true, deletes all language versions of the template.
         * </p>
         * 
         * @param deleteAllLanguages
         *        If true, deletes all language versions of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteAllLanguages(Boolean deleteAllLanguages);

        /**
         * <p>
         * The ID of the WhatsApp Business Account associated with this template.
         * </p>
         * 
         * @param id
         *        The ID of the WhatsApp Business Account associated with this template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the template to delete.
         * </p>
         * 
         * @param templateName
         *        The name of the template to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SocialMessagingRequest.BuilderImpl implements Builder {
        private String metaTemplateId;

        private Boolean deleteAllLanguages;

        private String id;

        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteWhatsAppMessageTemplateRequest model) {
            super(model);
            metaTemplateId(model.metaTemplateId);
            deleteAllLanguages(model.deleteAllLanguages);
            id(model.id);
            templateName(model.templateName);
        }

        public final String getMetaTemplateId() {
            return metaTemplateId;
        }

        public final void setMetaTemplateId(String metaTemplateId) {
            this.metaTemplateId = metaTemplateId;
        }

        @Override
        public final Builder metaTemplateId(String metaTemplateId) {
            this.metaTemplateId = metaTemplateId;
            return this;
        }

        public final Boolean getDeleteAllLanguages() {
            return deleteAllLanguages;
        }

        public final void setDeleteAllLanguages(Boolean deleteAllLanguages) {
            this.deleteAllLanguages = deleteAllLanguages;
        }

        @Override
        public final Builder deleteAllLanguages(Boolean deleteAllLanguages) {
            this.deleteAllLanguages = deleteAllLanguages;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteWhatsAppMessageTemplateRequest build() {
            return new DeleteWhatsAppMessageTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
