/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration options for customizing the body content of a template from Meta's library.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LibraryTemplateBodyInputs implements SdkPojo, Serializable,
        ToCopyableBuilder<LibraryTemplateBodyInputs.Builder, LibraryTemplateBodyInputs> {
    private static final SdkField<Boolean> ADD_CONTACT_NUMBER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("addContactNumber").getter(getter(LibraryTemplateBodyInputs::addContactNumber))
            .setter(setter(Builder::addContactNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addContactNumber").build()).build();

    private static final SdkField<Boolean> ADD_LEARN_MORE_LINK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("addLearnMoreLink").getter(getter(LibraryTemplateBodyInputs::addLearnMoreLink))
            .setter(setter(Builder::addLearnMoreLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addLearnMoreLink").build()).build();

    private static final SdkField<Boolean> ADD_SECURITY_RECOMMENDATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("addSecurityRecommendation")
            .getter(getter(LibraryTemplateBodyInputs::addSecurityRecommendation))
            .setter(setter(Builder::addSecurityRecommendation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addSecurityRecommendation").build())
            .build();

    private static final SdkField<Boolean> ADD_TRACK_PACKAGE_LINK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("addTrackPackageLink").getter(getter(LibraryTemplateBodyInputs::addTrackPackageLink))
            .setter(setter(Builder::addTrackPackageLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addTrackPackageLink").build())
            .build();

    private static final SdkField<Integer> CODE_EXPIRATION_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("codeExpirationMinutes").getter(getter(LibraryTemplateBodyInputs::codeExpirationMinutes))
            .setter(setter(Builder::codeExpirationMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeExpirationMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_CONTACT_NUMBER_FIELD,
            ADD_LEARN_MORE_LINK_FIELD, ADD_SECURITY_RECOMMENDATION_FIELD, ADD_TRACK_PACKAGE_LINK_FIELD,
            CODE_EXPIRATION_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean addContactNumber;

    private final Boolean addLearnMoreLink;

    private final Boolean addSecurityRecommendation;

    private final Boolean addTrackPackageLink;

    private final Integer codeExpirationMinutes;

    private LibraryTemplateBodyInputs(BuilderImpl builder) {
        this.addContactNumber = builder.addContactNumber;
        this.addLearnMoreLink = builder.addLearnMoreLink;
        this.addSecurityRecommendation = builder.addSecurityRecommendation;
        this.addTrackPackageLink = builder.addTrackPackageLink;
        this.codeExpirationMinutes = builder.codeExpirationMinutes;
    }

    /**
     * <p>
     * When true, includes a contact number in the template body.
     * </p>
     * 
     * @return When true, includes a contact number in the template body.
     */
    public final Boolean addContactNumber() {
        return addContactNumber;
    }

    /**
     * <p>
     * When true, includes a "learn more" link in the template body.
     * </p>
     * 
     * @return When true, includes a "learn more" link in the template body.
     */
    public final Boolean addLearnMoreLink() {
        return addLearnMoreLink;
    }

    /**
     * <p>
     * When true, includes security recommendations in the template body.
     * </p>
     * 
     * @return When true, includes security recommendations in the template body.
     */
    public final Boolean addSecurityRecommendation() {
        return addSecurityRecommendation;
    }

    /**
     * <p>
     * When true, includes a package tracking link in the template body.
     * </p>
     * 
     * @return When true, includes a package tracking link in the template body.
     */
    public final Boolean addTrackPackageLink() {
        return addTrackPackageLink;
    }

    /**
     * <p>
     * The number of minutes until a verification code or OTP expires.
     * </p>
     * 
     * @return The number of minutes until a verification code or OTP expires.
     */
    public final Integer codeExpirationMinutes() {
        return codeExpirationMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addContactNumber());
        hashCode = 31 * hashCode + Objects.hashCode(addLearnMoreLink());
        hashCode = 31 * hashCode + Objects.hashCode(addSecurityRecommendation());
        hashCode = 31 * hashCode + Objects.hashCode(addTrackPackageLink());
        hashCode = 31 * hashCode + Objects.hashCode(codeExpirationMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LibraryTemplateBodyInputs)) {
            return false;
        }
        LibraryTemplateBodyInputs other = (LibraryTemplateBodyInputs) obj;
        return Objects.equals(addContactNumber(), other.addContactNumber())
                && Objects.equals(addLearnMoreLink(), other.addLearnMoreLink())
                && Objects.equals(addSecurityRecommendation(), other.addSecurityRecommendation())
                && Objects.equals(addTrackPackageLink(), other.addTrackPackageLink())
                && Objects.equals(codeExpirationMinutes(), other.codeExpirationMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LibraryTemplateBodyInputs").add("AddContactNumber", addContactNumber())
                .add("AddLearnMoreLink", addLearnMoreLink()).add("AddSecurityRecommendation", addSecurityRecommendation())
                .add("AddTrackPackageLink", addTrackPackageLink()).add("CodeExpirationMinutes", codeExpirationMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addContactNumber":
            return Optional.ofNullable(clazz.cast(addContactNumber()));
        case "addLearnMoreLink":
            return Optional.ofNullable(clazz.cast(addLearnMoreLink()));
        case "addSecurityRecommendation":
            return Optional.ofNullable(clazz.cast(addSecurityRecommendation()));
        case "addTrackPackageLink":
            return Optional.ofNullable(clazz.cast(addTrackPackageLink()));
        case "codeExpirationMinutes":
            return Optional.ofNullable(clazz.cast(codeExpirationMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("addContactNumber", ADD_CONTACT_NUMBER_FIELD);
        map.put("addLearnMoreLink", ADD_LEARN_MORE_LINK_FIELD);
        map.put("addSecurityRecommendation", ADD_SECURITY_RECOMMENDATION_FIELD);
        map.put("addTrackPackageLink", ADD_TRACK_PACKAGE_LINK_FIELD);
        map.put("codeExpirationMinutes", CODE_EXPIRATION_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LibraryTemplateBodyInputs, T> g) {
        return obj -> g.apply((LibraryTemplateBodyInputs) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LibraryTemplateBodyInputs> {
        /**
         * <p>
         * When true, includes a contact number in the template body.
         * </p>
         * 
         * @param addContactNumber
         *        When true, includes a contact number in the template body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addContactNumber(Boolean addContactNumber);

        /**
         * <p>
         * When true, includes a "learn more" link in the template body.
         * </p>
         * 
         * @param addLearnMoreLink
         *        When true, includes a "learn more" link in the template body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addLearnMoreLink(Boolean addLearnMoreLink);

        /**
         * <p>
         * When true, includes security recommendations in the template body.
         * </p>
         * 
         * @param addSecurityRecommendation
         *        When true, includes security recommendations in the template body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSecurityRecommendation(Boolean addSecurityRecommendation);

        /**
         * <p>
         * When true, includes a package tracking link in the template body.
         * </p>
         * 
         * @param addTrackPackageLink
         *        When true, includes a package tracking link in the template body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addTrackPackageLink(Boolean addTrackPackageLink);

        /**
         * <p>
         * The number of minutes until a verification code or OTP expires.
         * </p>
         * 
         * @param codeExpirationMinutes
         *        The number of minutes until a verification code or OTP expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeExpirationMinutes(Integer codeExpirationMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Boolean addContactNumber;

        private Boolean addLearnMoreLink;

        private Boolean addSecurityRecommendation;

        private Boolean addTrackPackageLink;

        private Integer codeExpirationMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(LibraryTemplateBodyInputs model) {
            addContactNumber(model.addContactNumber);
            addLearnMoreLink(model.addLearnMoreLink);
            addSecurityRecommendation(model.addSecurityRecommendation);
            addTrackPackageLink(model.addTrackPackageLink);
            codeExpirationMinutes(model.codeExpirationMinutes);
        }

        public final Boolean getAddContactNumber() {
            return addContactNumber;
        }

        public final void setAddContactNumber(Boolean addContactNumber) {
            this.addContactNumber = addContactNumber;
        }

        @Override
        public final Builder addContactNumber(Boolean addContactNumber) {
            this.addContactNumber = addContactNumber;
            return this;
        }

        public final Boolean getAddLearnMoreLink() {
            return addLearnMoreLink;
        }

        public final void setAddLearnMoreLink(Boolean addLearnMoreLink) {
            this.addLearnMoreLink = addLearnMoreLink;
        }

        @Override
        public final Builder addLearnMoreLink(Boolean addLearnMoreLink) {
            this.addLearnMoreLink = addLearnMoreLink;
            return this;
        }

        public final Boolean getAddSecurityRecommendation() {
            return addSecurityRecommendation;
        }

        public final void setAddSecurityRecommendation(Boolean addSecurityRecommendation) {
            this.addSecurityRecommendation = addSecurityRecommendation;
        }

        @Override
        public final Builder addSecurityRecommendation(Boolean addSecurityRecommendation) {
            this.addSecurityRecommendation = addSecurityRecommendation;
            return this;
        }

        public final Boolean getAddTrackPackageLink() {
            return addTrackPackageLink;
        }

        public final void setAddTrackPackageLink(Boolean addTrackPackageLink) {
            this.addTrackPackageLink = addTrackPackageLink;
        }

        @Override
        public final Builder addTrackPackageLink(Boolean addTrackPackageLink) {
            this.addTrackPackageLink = addTrackPackageLink;
            return this;
        }

        public final Integer getCodeExpirationMinutes() {
            return codeExpirationMinutes;
        }

        public final void setCodeExpirationMinutes(Integer codeExpirationMinutes) {
            this.codeExpirationMinutes = codeExpirationMinutes;
        }

        @Override
        public final Builder codeExpirationMinutes(Integer codeExpirationMinutes) {
            this.codeExpirationMinutes = codeExpirationMinutes;
            return this;
        }

        @Override
        public LibraryTemplateBodyInputs build() {
            return new LibraryTemplateBodyInputs(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
