/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration options for customizing buttons in a template from Meta's library.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LibraryTemplateButtonInput implements SdkPojo, Serializable,
        ToCopyableBuilder<LibraryTemplateButtonInput.Builder, LibraryTemplateButtonInput> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(LibraryTemplateButtonInput::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("phoneNumber").getter(getter(LibraryTemplateButtonInput::phoneNumber))
            .setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phoneNumber").build()).build();

    private static final SdkField<Map<String, String>> URL_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("url")
            .getter(getter(LibraryTemplateButtonInput::url))
            .setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> OTP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("otpType").getter(getter(LibraryTemplateButtonInput::otpType)).setter(setter(Builder::otpType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otpType").build()).build();

    private static final SdkField<Boolean> ZERO_TAP_TERMS_ACCEPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("zeroTapTermsAccepted").getter(getter(LibraryTemplateButtonInput::zeroTapTermsAccepted))
            .setter(setter(Builder::zeroTapTermsAccepted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zeroTapTermsAccepted").build())
            .build();

    private static final SdkField<List<Map<String, String>>> SUPPORTED_APPS_FIELD = SdkField
            .<List<Map<String, String>>> builder(MarshallingType.LIST)
            .memberName("supportedApps")
            .getter(getter(LibraryTemplateButtonInput::supportedApps))
            .setter(setter(Builder::supportedApps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedApps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            PHONE_NUMBER_FIELD, URL_FIELD, OTP_TYPE_FIELD, ZERO_TAP_TERMS_ACCEPTED_FIELD, SUPPORTED_APPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String phoneNumber;

    private final Map<String, String> url;

    private final String otpType;

    private final Boolean zeroTapTermsAccepted;

    private final List<Map<String, String>> supportedApps;

    private LibraryTemplateButtonInput(BuilderImpl builder) {
        this.type = builder.type;
        this.phoneNumber = builder.phoneNumber;
        this.url = builder.url;
        this.otpType = builder.otpType;
        this.zeroTapTermsAccepted = builder.zeroTapTermsAccepted;
        this.supportedApps = builder.supportedApps;
    }

    /**
     * <p>
     * The type of button (for example, QUICK_REPLY, CALL, or URL).
     * </p>
     * 
     * @return The type of button (for example, QUICK_REPLY, CALL, or URL).
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The phone number in E.164 format for CALL-type buttons.
     * </p>
     * 
     * @return The phone number in E.164 format for CALL-type buttons.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * For responses, this returns true if the service returned a value for the Url property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUrl() {
        return url != null && !(url instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The URL with dynamic parameters for URL-type buttons.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUrl} method.
     * </p>
     * 
     * @return The URL with dynamic parameters for URL-type buttons.
     */
    public final Map<String, String> url() {
        return url;
    }

    /**
     * <p>
     * The type of one-time password for OTP buttons.
     * </p>
     * 
     * @return The type of one-time password for OTP buttons.
     */
    public final String otpType() {
        return otpType;
    }

    /**
     * <p>
     * When true, indicates acceptance of zero-tap terms for the button.
     * </p>
     * 
     * @return When true, indicates acceptance of zero-tap terms for the button.
     */
    public final Boolean zeroTapTermsAccepted() {
        return zeroTapTermsAccepted;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedApps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedApps() {
        return supportedApps != null && !(supportedApps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of supported applications for this button type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedApps} method.
     * </p>
     * 
     * @return List of supported applications for this button type.
     */
    public final List<Map<String, String>> supportedApps() {
        return supportedApps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(hasUrl() ? url() : null);
        hashCode = 31 * hashCode + Objects.hashCode(otpType());
        hashCode = 31 * hashCode + Objects.hashCode(zeroTapTermsAccepted());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedApps() ? supportedApps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LibraryTemplateButtonInput)) {
            return false;
        }
        LibraryTemplateButtonInput other = (LibraryTemplateButtonInput) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(phoneNumber(), other.phoneNumber())
                && hasUrl() == other.hasUrl() && Objects.equals(url(), other.url()) && Objects.equals(otpType(), other.otpType())
                && Objects.equals(zeroTapTermsAccepted(), other.zeroTapTermsAccepted())
                && hasSupportedApps() == other.hasSupportedApps() && Objects.equals(supportedApps(), other.supportedApps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LibraryTemplateButtonInput").add("Type", type()).add("PhoneNumber", phoneNumber())
                .add("Url", hasUrl() ? url() : null).add("OtpType", otpType())
                .add("ZeroTapTermsAccepted", zeroTapTermsAccepted())
                .add("SupportedApps", hasSupportedApps() ? supportedApps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "phoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        case "otpType":
            return Optional.ofNullable(clazz.cast(otpType()));
        case "zeroTapTermsAccepted":
            return Optional.ofNullable(clazz.cast(zeroTapTermsAccepted()));
        case "supportedApps":
            return Optional.ofNullable(clazz.cast(supportedApps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("phoneNumber", PHONE_NUMBER_FIELD);
        map.put("url", URL_FIELD);
        map.put("otpType", OTP_TYPE_FIELD);
        map.put("zeroTapTermsAccepted", ZERO_TAP_TERMS_ACCEPTED_FIELD);
        map.put("supportedApps", SUPPORTED_APPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LibraryTemplateButtonInput, T> g) {
        return obj -> g.apply((LibraryTemplateButtonInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LibraryTemplateButtonInput> {
        /**
         * <p>
         * The type of button (for example, QUICK_REPLY, CALL, or URL).
         * </p>
         * 
         * @param type
         *        The type of button (for example, QUICK_REPLY, CALL, or URL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The phone number in E.164 format for CALL-type buttons.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number in E.164 format for CALL-type buttons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The URL with dynamic parameters for URL-type buttons.
         * </p>
         * 
         * @param url
         *        The URL with dynamic parameters for URL-type buttons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(Map<String, String> url);

        /**
         * <p>
         * The type of one-time password for OTP buttons.
         * </p>
         * 
         * @param otpType
         *        The type of one-time password for OTP buttons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otpType(String otpType);

        /**
         * <p>
         * When true, indicates acceptance of zero-tap terms for the button.
         * </p>
         * 
         * @param zeroTapTermsAccepted
         *        When true, indicates acceptance of zero-tap terms for the button.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zeroTapTermsAccepted(Boolean zeroTapTermsAccepted);

        /**
         * <p>
         * List of supported applications for this button type.
         * </p>
         * 
         * @param supportedApps
         *        List of supported applications for this button type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedApps(Collection<? extends Map<String, String>> supportedApps);

        /**
         * <p>
         * List of supported applications for this button type.
         * </p>
         * 
         * @param supportedApps
         *        List of supported applications for this button type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedApps(Map<String, String>... supportedApps);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String phoneNumber;

        private Map<String, String> url = DefaultSdkAutoConstructMap.getInstance();

        private String otpType;

        private Boolean zeroTapTermsAccepted;

        private List<Map<String, String>> supportedApps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LibraryTemplateButtonInput model) {
            type(model.type);
            phoneNumber(model.phoneNumber);
            url(model.url);
            otpType(model.otpType);
            zeroTapTermsAccepted(model.zeroTapTermsAccepted);
            supportedApps(model.supportedApps);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final Map<String, String> getUrl() {
            if (url instanceof SdkAutoConstructMap) {
                return null;
            }
            return url;
        }

        public final void setUrl(Map<String, String> url) {
            this.url = MetaUrlWithSuffixExampleCopier.copy(url);
        }

        @Override
        public final Builder url(Map<String, String> url) {
            this.url = MetaUrlWithSuffixExampleCopier.copy(url);
            return this;
        }

        public final String getOtpType() {
            return otpType;
        }

        public final void setOtpType(String otpType) {
            this.otpType = otpType;
        }

        @Override
        public final Builder otpType(String otpType) {
            this.otpType = otpType;
            return this;
        }

        public final Boolean getZeroTapTermsAccepted() {
            return zeroTapTermsAccepted;
        }

        public final void setZeroTapTermsAccepted(Boolean zeroTapTermsAccepted) {
            this.zeroTapTermsAccepted = zeroTapTermsAccepted;
        }

        @Override
        public final Builder zeroTapTermsAccepted(Boolean zeroTapTermsAccepted) {
            this.zeroTapTermsAccepted = zeroTapTermsAccepted;
            return this;
        }

        public final Collection<? extends Map<String, String>> getSupportedApps() {
            if (supportedApps instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedApps;
        }

        public final void setSupportedApps(Collection<? extends Map<String, String>> supportedApps) {
            this.supportedApps = SupportedAppsCopier.copy(supportedApps);
        }

        @Override
        public final Builder supportedApps(Collection<? extends Map<String, String>> supportedApps) {
            this.supportedApps = SupportedAppsCopier.copy(supportedApps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedApps(Map<String, String>... supportedApps) {
            supportedApps(Arrays.asList(supportedApps));
            return this;
        }

        @Override
        public LibraryTemplateButtonInput build() {
            return new LibraryTemplateButtonInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
