/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a template from Meta's library with customization options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetaLibraryTemplate implements SdkPojo, Serializable,
        ToCopyableBuilder<MetaLibraryTemplate.Builder, MetaLibraryTemplate> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(MetaLibraryTemplate::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final SdkField<String> LIBRARY_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("libraryTemplateName").getter(getter(MetaLibraryTemplate::libraryTemplateName))
            .setter(setter(Builder::libraryTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("libraryTemplateName").build())
            .build();

    private static final SdkField<String> TEMPLATE_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateCategory").getter(getter(MetaLibraryTemplate::templateCategory))
            .setter(setter(Builder::templateCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateCategory").build()).build();

    private static final SdkField<String> TEMPLATE_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateLanguage").getter(getter(MetaLibraryTemplate::templateLanguage))
            .setter(setter(Builder::templateLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateLanguage").build()).build();

    private static final SdkField<List<LibraryTemplateButtonInput>> LIBRARY_TEMPLATE_BUTTON_INPUTS_FIELD = SdkField
            .<List<LibraryTemplateButtonInput>> builder(MarshallingType.LIST)
            .memberName("libraryTemplateButtonInputs")
            .getter(getter(MetaLibraryTemplate::libraryTemplateButtonInputs))
            .setter(setter(Builder::libraryTemplateButtonInputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("libraryTemplateButtonInputs")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LibraryTemplateButtonInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(LibraryTemplateButtonInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LibraryTemplateBodyInputs> LIBRARY_TEMPLATE_BODY_INPUTS_FIELD = SdkField
            .<LibraryTemplateBodyInputs> builder(MarshallingType.SDK_POJO).memberName("libraryTemplateBodyInputs")
            .getter(getter(MetaLibraryTemplate::libraryTemplateBodyInputs)).setter(setter(Builder::libraryTemplateBodyInputs))
            .constructor(LibraryTemplateBodyInputs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("libraryTemplateBodyInputs").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD,
            LIBRARY_TEMPLATE_NAME_FIELD, TEMPLATE_CATEGORY_FIELD, TEMPLATE_LANGUAGE_FIELD, LIBRARY_TEMPLATE_BUTTON_INPUTS_FIELD,
            LIBRARY_TEMPLATE_BODY_INPUTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String templateName;

    private final String libraryTemplateName;

    private final String templateCategory;

    private final String templateLanguage;

    private final List<LibraryTemplateButtonInput> libraryTemplateButtonInputs;

    private final LibraryTemplateBodyInputs libraryTemplateBodyInputs;

    private MetaLibraryTemplate(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.libraryTemplateName = builder.libraryTemplateName;
        this.templateCategory = builder.templateCategory;
        this.templateLanguage = builder.templateLanguage;
        this.libraryTemplateButtonInputs = builder.libraryTemplateButtonInputs;
        this.libraryTemplateBodyInputs = builder.libraryTemplateBodyInputs;
    }

    /**
     * <p>
     * The name to assign to the template.
     * </p>
     * 
     * @return The name to assign to the template.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The name of the template in Meta's library.
     * </p>
     * 
     * @return The name of the template in Meta's library.
     */
    public final String libraryTemplateName() {
        return libraryTemplateName;
    }

    /**
     * <p>
     * The category of the template (for example, UTILITY or MARKETING).
     * </p>
     * 
     * @return The category of the template (for example, UTILITY or MARKETING).
     */
    public final String templateCategory() {
        return templateCategory;
    }

    /**
     * <p>
     * The language code for the template (for example, en_US).
     * </p>
     * 
     * @return The language code for the template (for example, en_US).
     */
    public final String templateLanguage() {
        return templateLanguage;
    }

    /**
     * For responses, this returns true if the service returned a value for the LibraryTemplateButtonInputs property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLibraryTemplateButtonInputs() {
        return libraryTemplateButtonInputs != null && !(libraryTemplateButtonInputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Button customizations for the template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLibraryTemplateButtonInputs} method.
     * </p>
     * 
     * @return Button customizations for the template.
     */
    public final List<LibraryTemplateButtonInput> libraryTemplateButtonInputs() {
        return libraryTemplateButtonInputs;
    }

    /**
     * <p>
     * Body text customizations for the template.
     * </p>
     * 
     * @return Body text customizations for the template.
     */
    public final LibraryTemplateBodyInputs libraryTemplateBodyInputs() {
        return libraryTemplateBodyInputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(libraryTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(templateCategory());
        hashCode = 31 * hashCode + Objects.hashCode(templateLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(hasLibraryTemplateButtonInputs() ? libraryTemplateButtonInputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(libraryTemplateBodyInputs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetaLibraryTemplate)) {
            return false;
        }
        MetaLibraryTemplate other = (MetaLibraryTemplate) obj;
        return Objects.equals(templateName(), other.templateName())
                && Objects.equals(libraryTemplateName(), other.libraryTemplateName())
                && Objects.equals(templateCategory(), other.templateCategory())
                && Objects.equals(templateLanguage(), other.templateLanguage())
                && hasLibraryTemplateButtonInputs() == other.hasLibraryTemplateButtonInputs()
                && Objects.equals(libraryTemplateButtonInputs(), other.libraryTemplateButtonInputs())
                && Objects.equals(libraryTemplateBodyInputs(), other.libraryTemplateBodyInputs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetaLibraryTemplate").add("TemplateName", templateName())
                .add("LibraryTemplateName", libraryTemplateName()).add("TemplateCategory", templateCategory())
                .add("TemplateLanguage", templateLanguage())
                .add("LibraryTemplateButtonInputs", hasLibraryTemplateButtonInputs() ? libraryTemplateButtonInputs() : null)
                .add("LibraryTemplateBodyInputs", libraryTemplateBodyInputs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "libraryTemplateName":
            return Optional.ofNullable(clazz.cast(libraryTemplateName()));
        case "templateCategory":
            return Optional.ofNullable(clazz.cast(templateCategory()));
        case "templateLanguage":
            return Optional.ofNullable(clazz.cast(templateLanguage()));
        case "libraryTemplateButtonInputs":
            return Optional.ofNullable(clazz.cast(libraryTemplateButtonInputs()));
        case "libraryTemplateBodyInputs":
            return Optional.ofNullable(clazz.cast(libraryTemplateBodyInputs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("templateName", TEMPLATE_NAME_FIELD);
        map.put("libraryTemplateName", LIBRARY_TEMPLATE_NAME_FIELD);
        map.put("templateCategory", TEMPLATE_CATEGORY_FIELD);
        map.put("templateLanguage", TEMPLATE_LANGUAGE_FIELD);
        map.put("libraryTemplateButtonInputs", LIBRARY_TEMPLATE_BUTTON_INPUTS_FIELD);
        map.put("libraryTemplateBodyInputs", LIBRARY_TEMPLATE_BODY_INPUTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetaLibraryTemplate, T> g) {
        return obj -> g.apply((MetaLibraryTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetaLibraryTemplate> {
        /**
         * <p>
         * The name to assign to the template.
         * </p>
         * 
         * @param templateName
         *        The name to assign to the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The name of the template in Meta's library.
         * </p>
         * 
         * @param libraryTemplateName
         *        The name of the template in Meta's library.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder libraryTemplateName(String libraryTemplateName);

        /**
         * <p>
         * The category of the template (for example, UTILITY or MARKETING).
         * </p>
         * 
         * @param templateCategory
         *        The category of the template (for example, UTILITY or MARKETING).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateCategory(String templateCategory);

        /**
         * <p>
         * The language code for the template (for example, en_US).
         * </p>
         * 
         * @param templateLanguage
         *        The language code for the template (for example, en_US).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateLanguage(String templateLanguage);

        /**
         * <p>
         * Button customizations for the template.
         * </p>
         * 
         * @param libraryTemplateButtonInputs
         *        Button customizations for the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder libraryTemplateButtonInputs(Collection<LibraryTemplateButtonInput> libraryTemplateButtonInputs);

        /**
         * <p>
         * Button customizations for the template.
         * </p>
         * 
         * @param libraryTemplateButtonInputs
         *        Button customizations for the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder libraryTemplateButtonInputs(LibraryTemplateButtonInput... libraryTemplateButtonInputs);

        /**
         * <p>
         * Button customizations for the template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.socialmessaging.model.LibraryTemplateButtonInput.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.socialmessaging.model.LibraryTemplateButtonInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.socialmessaging.model.LibraryTemplateButtonInput.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #libraryTemplateButtonInputs(List<LibraryTemplateButtonInput>)}.
         * 
         * @param libraryTemplateButtonInputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.socialmessaging.model.LibraryTemplateButtonInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #libraryTemplateButtonInputs(java.util.Collection<LibraryTemplateButtonInput>)
         */
        Builder libraryTemplateButtonInputs(Consumer<LibraryTemplateButtonInput.Builder>... libraryTemplateButtonInputs);

        /**
         * <p>
         * Body text customizations for the template.
         * </p>
         * 
         * @param libraryTemplateBodyInputs
         *        Body text customizations for the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder libraryTemplateBodyInputs(LibraryTemplateBodyInputs libraryTemplateBodyInputs);

        /**
         * <p>
         * Body text customizations for the template.
         * </p>
         * This is a convenience method that creates an instance of the {@link LibraryTemplateBodyInputs.Builder}
         * avoiding the need to create one manually via {@link LibraryTemplateBodyInputs#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LibraryTemplateBodyInputs.Builder#build()} is called immediately
         * and its result is passed to {@link #libraryTemplateBodyInputs(LibraryTemplateBodyInputs)}.
         * 
         * @param libraryTemplateBodyInputs
         *        a consumer that will call methods on {@link LibraryTemplateBodyInputs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #libraryTemplateBodyInputs(LibraryTemplateBodyInputs)
         */
        default Builder libraryTemplateBodyInputs(Consumer<LibraryTemplateBodyInputs.Builder> libraryTemplateBodyInputs) {
            return libraryTemplateBodyInputs(LibraryTemplateBodyInputs.builder().applyMutation(libraryTemplateBodyInputs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String templateName;

        private String libraryTemplateName;

        private String templateCategory;

        private String templateLanguage;

        private List<LibraryTemplateButtonInput> libraryTemplateButtonInputs = DefaultSdkAutoConstructList.getInstance();

        private LibraryTemplateBodyInputs libraryTemplateBodyInputs;

        private BuilderImpl() {
        }

        private BuilderImpl(MetaLibraryTemplate model) {
            templateName(model.templateName);
            libraryTemplateName(model.libraryTemplateName);
            templateCategory(model.templateCategory);
            templateLanguage(model.templateLanguage);
            libraryTemplateButtonInputs(model.libraryTemplateButtonInputs);
            libraryTemplateBodyInputs(model.libraryTemplateBodyInputs);
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getLibraryTemplateName() {
            return libraryTemplateName;
        }

        public final void setLibraryTemplateName(String libraryTemplateName) {
            this.libraryTemplateName = libraryTemplateName;
        }

        @Override
        public final Builder libraryTemplateName(String libraryTemplateName) {
            this.libraryTemplateName = libraryTemplateName;
            return this;
        }

        public final String getTemplateCategory() {
            return templateCategory;
        }

        public final void setTemplateCategory(String templateCategory) {
            this.templateCategory = templateCategory;
        }

        @Override
        public final Builder templateCategory(String templateCategory) {
            this.templateCategory = templateCategory;
            return this;
        }

        public final String getTemplateLanguage() {
            return templateLanguage;
        }

        public final void setTemplateLanguage(String templateLanguage) {
            this.templateLanguage = templateLanguage;
        }

        @Override
        public final Builder templateLanguage(String templateLanguage) {
            this.templateLanguage = templateLanguage;
            return this;
        }

        public final List<LibraryTemplateButtonInput.Builder> getLibraryTemplateButtonInputs() {
            List<LibraryTemplateButtonInput.Builder> result = MetaLibraryTemplateButtonInputsCopier
                    .copyToBuilder(this.libraryTemplateButtonInputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLibraryTemplateButtonInputs(
                Collection<LibraryTemplateButtonInput.BuilderImpl> libraryTemplateButtonInputs) {
            this.libraryTemplateButtonInputs = MetaLibraryTemplateButtonInputsCopier.copyFromBuilder(libraryTemplateButtonInputs);
        }

        @Override
        public final Builder libraryTemplateButtonInputs(Collection<LibraryTemplateButtonInput> libraryTemplateButtonInputs) {
            this.libraryTemplateButtonInputs = MetaLibraryTemplateButtonInputsCopier.copy(libraryTemplateButtonInputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder libraryTemplateButtonInputs(LibraryTemplateButtonInput... libraryTemplateButtonInputs) {
            libraryTemplateButtonInputs(Arrays.asList(libraryTemplateButtonInputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder libraryTemplateButtonInputs(
                Consumer<LibraryTemplateButtonInput.Builder>... libraryTemplateButtonInputs) {
            libraryTemplateButtonInputs(Stream.of(libraryTemplateButtonInputs)
                    .map(c -> LibraryTemplateButtonInput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final LibraryTemplateBodyInputs.Builder getLibraryTemplateBodyInputs() {
            return libraryTemplateBodyInputs != null ? libraryTemplateBodyInputs.toBuilder() : null;
        }

        public final void setLibraryTemplateBodyInputs(LibraryTemplateBodyInputs.BuilderImpl libraryTemplateBodyInputs) {
            this.libraryTemplateBodyInputs = libraryTemplateBodyInputs != null ? libraryTemplateBodyInputs.build() : null;
        }

        @Override
        public final Builder libraryTemplateBodyInputs(LibraryTemplateBodyInputs libraryTemplateBodyInputs) {
            this.libraryTemplateBodyInputs = libraryTemplateBodyInputs;
            return this;
        }

        @Override
        public MetaLibraryTemplate build() {
            return new MetaLibraryTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
