/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWhatsAppMessageTemplateRequest extends SocialMessagingRequest implements
        ToCopyableBuilder<UpdateWhatsAppMessageTemplateRequest.Builder, UpdateWhatsAppMessageTemplateRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateWhatsAppMessageTemplateRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> META_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metaTemplateId").getter(getter(UpdateWhatsAppMessageTemplateRequest::metaTemplateId))
            .setter(setter(Builder::metaTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metaTemplateId").build()).build();

    private static final SdkField<String> TEMPLATE_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateCategory").getter(getter(UpdateWhatsAppMessageTemplateRequest::templateCategory))
            .setter(setter(Builder::templateCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateCategory").build()).build();

    private static final SdkField<SdkBytes> TEMPLATE_COMPONENTS_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("templateComponents").getter(getter(UpdateWhatsAppMessageTemplateRequest::templateComponents))
            .setter(setter(Builder::templateComponents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateComponents").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            META_TEMPLATE_ID_FIELD, TEMPLATE_CATEGORY_FIELD, TEMPLATE_COMPONENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String metaTemplateId;

    private final String templateCategory;

    private final SdkBytes templateComponents;

    private UpdateWhatsAppMessageTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.metaTemplateId = builder.metaTemplateId;
        this.templateCategory = builder.templateCategory;
        this.templateComponents = builder.templateComponents;
    }

    /**
     * <p>
     * The ID of the WhatsApp Business Account associated with this template.
     * </p>
     * 
     * @return The ID of the WhatsApp Business Account associated with this template.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The numeric ID of the template assigned by Meta.
     * </p>
     * 
     * @return The numeric ID of the template assigned by Meta.
     */
    public final String metaTemplateId() {
        return metaTemplateId;
    }

    /**
     * <p>
     * The new category for the template (for example, UTILITY or MARKETING).
     * </p>
     * 
     * @return The new category for the template (for example, UTILITY or MARKETING).
     */
    public final String templateCategory() {
        return templateCategory;
    }

    /**
     * <p>
     * The updated components of the template as a JSON blob (maximum 3000 characters).
     * </p>
     * 
     * @return The updated components of the template as a JSON blob (maximum 3000 characters).
     */
    public final SdkBytes templateComponents() {
        return templateComponents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(metaTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(templateCategory());
        hashCode = 31 * hashCode + Objects.hashCode(templateComponents());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWhatsAppMessageTemplateRequest)) {
            return false;
        }
        UpdateWhatsAppMessageTemplateRequest other = (UpdateWhatsAppMessageTemplateRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(metaTemplateId(), other.metaTemplateId())
                && Objects.equals(templateCategory(), other.templateCategory())
                && Objects.equals(templateComponents(), other.templateComponents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWhatsAppMessageTemplateRequest").add("Id", id()).add("MetaTemplateId", metaTemplateId())
                .add("TemplateCategory", templateCategory()).add("TemplateComponents", templateComponents()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "metaTemplateId":
            return Optional.ofNullable(clazz.cast(metaTemplateId()));
        case "templateCategory":
            return Optional.ofNullable(clazz.cast(templateCategory()));
        case "templateComponents":
            return Optional.ofNullable(clazz.cast(templateComponents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("metaTemplateId", META_TEMPLATE_ID_FIELD);
        map.put("templateCategory", TEMPLATE_CATEGORY_FIELD);
        map.put("templateComponents", TEMPLATE_COMPONENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWhatsAppMessageTemplateRequest, T> g) {
        return obj -> g.apply((UpdateWhatsAppMessageTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SocialMessagingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateWhatsAppMessageTemplateRequest> {
        /**
         * <p>
         * The ID of the WhatsApp Business Account associated with this template.
         * </p>
         * 
         * @param id
         *        The ID of the WhatsApp Business Account associated with this template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The numeric ID of the template assigned by Meta.
         * </p>
         * 
         * @param metaTemplateId
         *        The numeric ID of the template assigned by Meta.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metaTemplateId(String metaTemplateId);

        /**
         * <p>
         * The new category for the template (for example, UTILITY or MARKETING).
         * </p>
         * 
         * @param templateCategory
         *        The new category for the template (for example, UTILITY or MARKETING).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateCategory(String templateCategory);

        /**
         * <p>
         * The updated components of the template as a JSON blob (maximum 3000 characters).
         * </p>
         * 
         * @param templateComponents
         *        The updated components of the template as a JSON blob (maximum 3000 characters).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateComponents(SdkBytes templateComponents);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SocialMessagingRequest.BuilderImpl implements Builder {
        private String id;

        private String metaTemplateId;

        private String templateCategory;

        private SdkBytes templateComponents;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWhatsAppMessageTemplateRequest model) {
            super(model);
            id(model.id);
            metaTemplateId(model.metaTemplateId);
            templateCategory(model.templateCategory);
            templateComponents(model.templateComponents);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMetaTemplateId() {
            return metaTemplateId;
        }

        public final void setMetaTemplateId(String metaTemplateId) {
            this.metaTemplateId = metaTemplateId;
        }

        @Override
        public final Builder metaTemplateId(String metaTemplateId) {
            this.metaTemplateId = metaTemplateId;
            return this;
        }

        public final String getTemplateCategory() {
            return templateCategory;
        }

        public final void setTemplateCategory(String templateCategory) {
            this.templateCategory = templateCategory;
        }

        @Override
        public final Builder templateCategory(String templateCategory) {
            this.templateCategory = templateCategory;
            return this;
        }

        public final ByteBuffer getTemplateComponents() {
            return templateComponents == null ? null : templateComponents.asByteBuffer();
        }

        public final void setTemplateComponents(ByteBuffer templateComponents) {
            templateComponents(templateComponents == null ? null : SdkBytes.fromByteBuffer(templateComponents));
        }

        @Override
        public final Builder templateComponents(SdkBytes templateComponents) {
            this.templateComponents = templateComponents;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWhatsAppMessageTemplateRequest build() {
            return new UpdateWhatsAppMessageTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
