/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the <code>accessToken</code> provided by Meta during signup.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WhatsAppSignupCallback implements SdkPojo, Serializable,
        ToCopyableBuilder<WhatsAppSignupCallback.Builder, WhatsAppSignupCallback> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessToken").getter(getter(WhatsAppSignupCallback::accessToken)).setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()).build();

    private static final SdkField<String> CALLBACK_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("callbackUrl").getter(getter(WhatsAppSignupCallback::callbackUrl)).setter(setter(Builder::callbackUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("callbackUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD,
            CALLBACK_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accessToken;

    private final String callbackUrl;

    private WhatsAppSignupCallback(BuilderImpl builder) {
        this.accessToken = builder.accessToken;
        this.callbackUrl = builder.callbackUrl;
    }

    /**
     * <p>
     * The access token for your WhatsApp Business Account. The <code>accessToken</code> value is provided by Meta.
     * </p>
     * 
     * @return The access token for your WhatsApp Business Account. The <code>accessToken</code> value is provided by
     *         Meta.
     */
    public final String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * The URL where WhatsApp will send callback notifications for this account.
     * </p>
     * 
     * @return The URL where WhatsApp will send callback notifications for this account.
     */
    public final String callbackUrl() {
        return callbackUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(callbackUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WhatsAppSignupCallback)) {
            return false;
        }
        WhatsAppSignupCallback other = (WhatsAppSignupCallback) obj;
        return Objects.equals(accessToken(), other.accessToken()) && Objects.equals(callbackUrl(), other.callbackUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WhatsAppSignupCallback").add("AccessToken", accessToken()).add("CallbackUrl", callbackUrl())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "callbackUrl":
            return Optional.ofNullable(clazz.cast(callbackUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessToken", ACCESS_TOKEN_FIELD);
        map.put("callbackUrl", CALLBACK_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WhatsAppSignupCallback, T> g) {
        return obj -> g.apply((WhatsAppSignupCallback) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WhatsAppSignupCallback> {
        /**
         * <p>
         * The access token for your WhatsApp Business Account. The <code>accessToken</code> value is provided by Meta.
         * </p>
         * 
         * @param accessToken
         *        The access token for your WhatsApp Business Account. The <code>accessToken</code> value is provided by
         *        Meta.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The URL where WhatsApp will send callback notifications for this account.
         * </p>
         * 
         * @param callbackUrl
         *        The URL where WhatsApp will send callback notifications for this account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackUrl(String callbackUrl);
    }

    static final class BuilderImpl implements Builder {
        private String accessToken;

        private String callbackUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(WhatsAppSignupCallback model) {
            accessToken(model.accessToken);
            callbackUrl(model.callbackUrl);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getCallbackUrl() {
            return callbackUrl;
        }

        public final void setCallbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
        }

        @Override
        public final Builder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        @Override
        public WhatsAppSignupCallback build() {
            return new WhatsAppSignupCallback(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
