/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class ChangeMessageVisibilityBatchRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ChangeMessageVisibilityBatchRequest.Builder, ChangeMessageVisibilityBatchRequest> {
    private final String queueUrl;

    private final List<ChangeMessageVisibilityBatchRequestEntry> entries;

    private ChangeMessageVisibilityBatchRequest(BuilderImpl builder) {
        this.queueUrl = builder.queueUrl;
        this.entries = builder.entries;
    }

    /**
     * <p>
     * The URL of the Amazon SQS queue whose messages' visibility is changed.
     * </p>
     * <p>
     * Queue URLs are case-sensitive.
     * </p>
     * 
     * @return The URL of the Amazon SQS queue whose messages' visibility is changed.</p>
     *         <p>
     *         Queue URLs are case-sensitive.
     */
    public String queueUrl() {
        return queueUrl;
    }

    /**
     * <p>
     * A list of receipt handles of the messages for which the visibility timeout must be changed.
     * </p>
     * 
     * @return A list of receipt handles of the messages for which the visibility timeout must be changed.
     */
    public List<ChangeMessageVisibilityBatchRequestEntry> entries() {
        return entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((queueUrl() == null) ? 0 : queueUrl().hashCode());
        hashCode = 31 * hashCode + ((entries() == null) ? 0 : entries().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeMessageVisibilityBatchRequest)) {
            return false;
        }
        ChangeMessageVisibilityBatchRequest other = (ChangeMessageVisibilityBatchRequest) obj;
        if (other.queueUrl() == null ^ this.queueUrl() == null) {
            return false;
        }
        if (other.queueUrl() != null && !other.queueUrl().equals(this.queueUrl())) {
            return false;
        }
        if (other.entries() == null ^ this.entries() == null) {
            return false;
        }
        if (other.entries() != null && !other.entries().equals(this.entries())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (queueUrl() != null) {
            sb.append("QueueUrl: ").append(queueUrl()).append(",");
        }
        if (entries() != null) {
            sb.append("Entries: ").append(entries()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ChangeMessageVisibilityBatchRequest> {
        /**
         * <p>
         * The URL of the Amazon SQS queue whose messages' visibility is changed.
         * </p>
         * <p>
         * Queue URLs are case-sensitive.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the Amazon SQS queue whose messages' visibility is changed.</p>
         *        <p>
         *        Queue URLs are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * A list of receipt handles of the messages for which the visibility timeout must be changed.
         * </p>
         * 
         * @param entries
         *        A list of receipt handles of the messages for which the visibility timeout must be changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<ChangeMessageVisibilityBatchRequestEntry> entries);

        /**
         * <p>
         * A list of receipt handles of the messages for which the visibility timeout must be changed.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEntries(java.util.Collection)} or {@link #withEntries(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param entries
         *        A list of receipt handles of the messages for which the visibility timeout must be changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(ChangeMessageVisibilityBatchRequestEntry... entries);
    }

    private static final class BuilderImpl implements Builder {
        private String queueUrl;

        private List<ChangeMessageVisibilityBatchRequestEntry> entries = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeMessageVisibilityBatchRequest model) {
            setQueueUrl(model.queueUrl);
            setEntries(model.entries);
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Collection<ChangeMessageVisibilityBatchRequestEntry> getEntries() {
            return entries;
        }

        @Override
        public final Builder entries(Collection<ChangeMessageVisibilityBatchRequestEntry> entries) {
            this.entries = ChangeMessageVisibilityBatchRequestEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(ChangeMessageVisibilityBatchRequestEntry... entries) {
            if (this.entries == null) {
                this.entries = new SdkInternalList<>(entries.length);
            }
            for (ChangeMessageVisibilityBatchRequestEntry e : entries) {
                this.entries.add(e);
            }
            return this;
        }

        public final void setEntries(Collection<ChangeMessageVisibilityBatchRequestEntry> entries) {
            this.entries = ChangeMessageVisibilityBatchRequestEntryListCopier.copy(entries);
        }

        @SafeVarargs
        public final void setEntries(ChangeMessageVisibilityBatchRequestEntry... entries) {
            if (this.entries == null) {
                this.entries = new SdkInternalList<>(entries.length);
            }
            for (ChangeMessageVisibilityBatchRequestEntry e : entries) {
                this.entries.add(e);
            }
        }

        @Override
        public ChangeMessageVisibilityBatchRequest build() {
            return new ChangeMessageVisibilityBatchRequest(this);
        }
    }
}
