/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ChangeMessageVisibilityRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ChangeMessageVisibilityRequest.Builder, ChangeMessageVisibilityRequest> {
    private final String queueUrl;

    private final String receiptHandle;

    private final Integer visibilityTimeout;

    private ChangeMessageVisibilityRequest(BuilderImpl builder) {
        this.queueUrl = builder.queueUrl;
        this.receiptHandle = builder.receiptHandle;
        this.visibilityTimeout = builder.visibilityTimeout;
    }

    /**
     * <p>
     * The URL of the Amazon SQS queue whose message's visibility is changed.
     * </p>
     * <p>
     * Queue URLs are case-sensitive.
     * </p>
     * 
     * @return The URL of the Amazon SQS queue whose message's visibility is changed.</p>
     *         <p>
     *         Queue URLs are case-sensitive.
     */
    public String queueUrl() {
        return queueUrl;
    }

    /**
     * <p>
     * The receipt handle associated with the message whose visibility timeout is changed. This parameter is returned by
     * the <code> <a>ReceiveMessage</a> </code> action.
     * </p>
     * 
     * @return The receipt handle associated with the message whose visibility timeout is changed. This parameter is
     *         returned by the <code> <a>ReceiveMessage</a> </code> action.
     */
    public String receiptHandle() {
        return receiptHandle;
    }

    /**
     * <p>
     * The new value for the message's visibility timeout (in seconds). Values values: <code>0</code> to
     * <code>43200</code>. Maximum: 12 hours.
     * </p>
     * 
     * @return The new value for the message's visibility timeout (in seconds). Values values: <code>0</code> to
     *         <code>43200</code>. Maximum: 12 hours.
     */
    public Integer visibilityTimeout() {
        return visibilityTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((queueUrl() == null) ? 0 : queueUrl().hashCode());
        hashCode = 31 * hashCode + ((receiptHandle() == null) ? 0 : receiptHandle().hashCode());
        hashCode = 31 * hashCode + ((visibilityTimeout() == null) ? 0 : visibilityTimeout().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeMessageVisibilityRequest)) {
            return false;
        }
        ChangeMessageVisibilityRequest other = (ChangeMessageVisibilityRequest) obj;
        if (other.queueUrl() == null ^ this.queueUrl() == null) {
            return false;
        }
        if (other.queueUrl() != null && !other.queueUrl().equals(this.queueUrl())) {
            return false;
        }
        if (other.receiptHandle() == null ^ this.receiptHandle() == null) {
            return false;
        }
        if (other.receiptHandle() != null && !other.receiptHandle().equals(this.receiptHandle())) {
            return false;
        }
        if (other.visibilityTimeout() == null ^ this.visibilityTimeout() == null) {
            return false;
        }
        if (other.visibilityTimeout() != null && !other.visibilityTimeout().equals(this.visibilityTimeout())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (queueUrl() != null) {
            sb.append("QueueUrl: ").append(queueUrl()).append(",");
        }
        if (receiptHandle() != null) {
            sb.append("ReceiptHandle: ").append(receiptHandle()).append(",");
        }
        if (visibilityTimeout() != null) {
            sb.append("VisibilityTimeout: ").append(visibilityTimeout()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ChangeMessageVisibilityRequest> {
        /**
         * <p>
         * The URL of the Amazon SQS queue whose message's visibility is changed.
         * </p>
         * <p>
         * Queue URLs are case-sensitive.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the Amazon SQS queue whose message's visibility is changed.</p>
         *        <p>
         *        Queue URLs are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * The receipt handle associated with the message whose visibility timeout is changed. This parameter is
         * returned by the <code> <a>ReceiveMessage</a> </code> action.
         * </p>
         * 
         * @param receiptHandle
         *        The receipt handle associated with the message whose visibility timeout is changed. This parameter is
         *        returned by the <code> <a>ReceiveMessage</a> </code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiptHandle(String receiptHandle);

        /**
         * <p>
         * The new value for the message's visibility timeout (in seconds). Values values: <code>0</code> to
         * <code>43200</code>. Maximum: 12 hours.
         * </p>
         * 
         * @param visibilityTimeout
         *        The new value for the message's visibility timeout (in seconds). Values values: <code>0</code> to
         *        <code>43200</code>. Maximum: 12 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibilityTimeout(Integer visibilityTimeout);
    }

    private static final class BuilderImpl implements Builder {
        private String queueUrl;

        private String receiptHandle;

        private Integer visibilityTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeMessageVisibilityRequest model) {
            setQueueUrl(model.queueUrl);
            setReceiptHandle(model.receiptHandle);
            setVisibilityTimeout(model.visibilityTimeout);
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final String getReceiptHandle() {
            return receiptHandle;
        }

        @Override
        public final Builder receiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
            return this;
        }

        public final void setReceiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
        }

        public final Integer getVisibilityTimeout() {
            return visibilityTimeout;
        }

        @Override
        public final Builder visibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        public final void setVisibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
        }

        @Override
        public ChangeMessageVisibilityRequest build() {
            return new ChangeMessageVisibilityRequest(this);
        }
    }
}
