/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Encloses a receipt handle and an identifier for it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteMessageBatchRequestEntry implements
        ToCopyableBuilder<DeleteMessageBatchRequestEntry.Builder, DeleteMessageBatchRequestEntry> {
    private final String id;

    private final String receiptHandle;

    private DeleteMessageBatchRequestEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.receiptHandle = builder.receiptHandle;
    }

    /**
     * <p>
     * An identifier for this particular receipt handle. This is used to communicate the result.
     * </p>
     * <note>
     * <p>
     * The <code>Id</code>s of a batch request need to be unique within a request
     * </p>
     * </note>
     * 
     * @return An identifier for this particular receipt handle. This is used to communicate the result.</p> <note>
     *         <p>
     *         The <code>Id</code>s of a batch request need to be unique within a request
     *         </p>
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * A receipt handle.
     * </p>
     * 
     * @return A receipt handle.
     */
    public String receiptHandle() {
        return receiptHandle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((receiptHandle() == null) ? 0 : receiptHandle().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMessageBatchRequestEntry)) {
            return false;
        }
        DeleteMessageBatchRequestEntry other = (DeleteMessageBatchRequestEntry) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.receiptHandle() == null ^ this.receiptHandle() == null) {
            return false;
        }
        if (other.receiptHandle() != null && !other.receiptHandle().equals(this.receiptHandle())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (receiptHandle() != null) {
            sb.append("ReceiptHandle: ").append(receiptHandle()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteMessageBatchRequestEntry> {
        /**
         * <p>
         * An identifier for this particular receipt handle. This is used to communicate the result.
         * </p>
         * <note>
         * <p>
         * The <code>Id</code>s of a batch request need to be unique within a request
         * </p>
         * </note>
         * 
         * @param id
         *        An identifier for this particular receipt handle. This is used to communicate the result.</p> <note>
         *        <p>
         *        The <code>Id</code>s of a batch request need to be unique within a request
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A receipt handle.
         * </p>
         * 
         * @param receiptHandle
         *        A receipt handle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiptHandle(String receiptHandle);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String receiptHandle;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMessageBatchRequestEntry model) {
            setId(model.id);
            setReceiptHandle(model.receiptHandle);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getReceiptHandle() {
            return receiptHandle;
        }

        @Override
        public final Builder receiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
            return this;
        }

        public final void setReceiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
        }

        @Override
        public DeleteMessageBatchRequestEntry build() {
            return new DeleteMessageBatchRequestEntry(this);
        }
    }
}
