/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListQueuesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListQueuesRequest.Builder, ListQueuesRequest> {
    private final String queueNamePrefix;

    private ListQueuesRequest(BuilderImpl builder) {
        this.queueNamePrefix = builder.queueNamePrefix;
    }

    /**
     * <p>
     * A string to use for filtering the list results. Only those queues whose name begins with the specified string are
     * returned.
     * </p>
     * <p>
     * Queue names are case-sensitive.
     * </p>
     * 
     * @return A string to use for filtering the list results. Only those queues whose name begins with the specified
     *         string are returned.</p>
     *         <p>
     *         Queue names are case-sensitive.
     */
    public String queueNamePrefix() {
        return queueNamePrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((queueNamePrefix() == null) ? 0 : queueNamePrefix().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuesRequest)) {
            return false;
        }
        ListQueuesRequest other = (ListQueuesRequest) obj;
        if (other.queueNamePrefix() == null ^ this.queueNamePrefix() == null) {
            return false;
        }
        if (other.queueNamePrefix() != null && !other.queueNamePrefix().equals(this.queueNamePrefix())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (queueNamePrefix() != null) {
            sb.append("QueueNamePrefix: ").append(queueNamePrefix()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListQueuesRequest> {
        /**
         * <p>
         * A string to use for filtering the list results. Only those queues whose name begins with the specified string
         * are returned.
         * </p>
         * <p>
         * Queue names are case-sensitive.
         * </p>
         * 
         * @param queueNamePrefix
         *        A string to use for filtering the list results. Only those queues whose name begins with the specified
         *        string are returned.</p>
         *        <p>
         *        Queue names are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueNamePrefix(String queueNamePrefix);
    }

    private static final class BuilderImpl implements Builder {
        private String queueNamePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueuesRequest model) {
            setQueueNamePrefix(model.queueNamePrefix);
        }

        public final String getQueueNamePrefix() {
            return queueNamePrefix;
        }

        @Override
        public final Builder queueNamePrefix(String queueNamePrefix) {
            this.queueNamePrefix = queueNamePrefix;
            return this;
        }

        public final void setQueueNamePrefix(String queueNamePrefix) {
            this.queueNamePrefix = queueNamePrefix;
        }

        @Override
        public ListQueuesRequest build() {
            return new ListQueuesRequest(this);
        }
    }
}
