/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReceiveMessageRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ReceiveMessageRequest.Builder, ReceiveMessageRequest> {
    private final String queueUrl;

    private final List<String> attributeNames;

    private final List<String> messageAttributeNames;

    private final Integer maxNumberOfMessages;

    private final Integer visibilityTimeout;

    private final Integer waitTimeSeconds;

    private final String receiveRequestAttemptId;

    private ReceiveMessageRequest(BuilderImpl builder) {
        this.queueUrl = builder.queueUrl;
        this.attributeNames = builder.attributeNames;
        this.messageAttributeNames = builder.messageAttributeNames;
        this.maxNumberOfMessages = builder.maxNumberOfMessages;
        this.visibilityTimeout = builder.visibilityTimeout;
        this.waitTimeSeconds = builder.waitTimeSeconds;
        this.receiveRequestAttemptId = builder.receiveRequestAttemptId;
    }

    /**
     * <p>
     * The URL of the Amazon SQS queue from which messages are received.
     * </p>
     * <p>
     * Queue URLs are case-sensitive.
     * </p>
     * 
     * @return The URL of the Amazon SQS queue from which messages are received.</p>
     *         <p>
     *         Queue URLs are case-sensitive.
     */
    public String queueUrl() {
        return queueUrl;
    }

    /**
     * <p>
     * A list of attributes that need to be returned along with each message. These attributes include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>All</code> - Returns all values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApproximateFirstReceiveTimestamp</code> - Returns the time the message was first received from the queue
     * (<a href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApproximateReceiveCount</code> - Returns the number of times a message has been received from the queue but
     * not deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SenderId</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * For an IAM user, returns the IAM user ID, for example <code>ABCDEFGHI1JKLMNOPQ23R</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For an IAM role, returns the IAM role ID, for example <code>ABCDE1F2GH3I4JK5LMNOP:i-a123b456</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>SentTimestamp</code> - Returns the time the message was sent to the queue (<a
     * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MessageDeduplicationId</code> - Returns the value provided by the sender that calls the
     * <code> <a>SendMessage</a> </code> action.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MessageGroupId</code> - Returns the value provided by the sender that calls the
     * <code> <a>SendMessage</a> </code> action. Messages with the same <code>MessageGroupId</code> are returned in
     * sequence.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SequenceNumber</code> - Returns the value provided by Amazon SQS.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Any other valid special request parameters (such as the following) are ignored:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ApproximateNumberOfMessages</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApproximateNumberOfMessagesDelayed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApproximateNumberOfMessagesNotVisible</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreatedTimestamp</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ContentBasedDeduplication</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DelaySeconds</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FifoQueue</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModifiedTimestamp</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumMessageSize</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MessageRetentionPeriod</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Policy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QueueArn</code>,
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReceiveMessageWaitTimeSeconds</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RedrivePolicy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VisibilityTimeout</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return A list of attributes that need to be returned along with each message. These attributes include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>All</code> - Returns all values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ApproximateFirstReceiveTimestamp</code> - Returns the time the message was first received from the
     *         queue (<a href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ApproximateReceiveCount</code> - Returns the number of times a message has been received from the
     *         queue but not deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SenderId</code>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For an IAM user, returns the IAM user ID, for example <code>ABCDEFGHI1JKLMNOPQ23R</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For an IAM role, returns the IAM role ID, for example <code>ABCDE1F2GH3I4JK5LMNOP:i-a123b456</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SentTimestamp</code> - Returns the time the message was sent to the queue (<a
     *         href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MessageDeduplicationId</code> - Returns the value provided by the sender that calls the
     *         <code> <a>SendMessage</a> </code> action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MessageGroupId</code> - Returns the value provided by the sender that calls the
     *         <code> <a>SendMessage</a> </code> action. Messages with the same <code>MessageGroupId</code> are returned
     *         in sequence.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SequenceNumber</code> - Returns the value provided by Amazon SQS.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Any other valid special request parameters (such as the following) are ignored:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ApproximateNumberOfMessages</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ApproximateNumberOfMessagesDelayed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ApproximateNumberOfMessagesNotVisible</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreatedTimestamp</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ContentBasedDeduplication</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DelaySeconds</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FifoQueue</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LastModifiedTimestamp</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MaximumMessageSize</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MessageRetentionPeriod</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Policy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>QueueArn</code>,
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReceiveMessageWaitTimeSeconds</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RedrivePolicy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VisibilityTimeout</code>
     *         </p>
     *         </li>
     * @see QueueAttributeName
     */
    public List<String> attributeNames() {
        return attributeNames;
    }

    /**
     * <p>
     * The name of the message attribute, where <i>N</i> is the index.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The name can contain alphanumeric characters and the underscore (<code>_</code>), hyphen (<code>-</code>), and
     * period (<code>.</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The name is case-sensitive and must be unique among all attribute names for the message.
     * </p>
     * </li>
     * <li>
     * <p>
     * The name must not start with AWS-reserved prefixes such as <code>AWS.</code> or <code>Amazon.</code> (or any
     * casing variants).
     * </p>
     * </li>
     * <li>
     * <p>
     * The name must not start or end with a period (<code>.</code>), and it should not have periods in succession (
     * <code>..</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The name can be up to 256 characters long.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When using <code>ReceiveMessage</code>, you can send a list of attribute names to receive, or you can return all
     * of the attributes by specifying <code>All</code> or <code>.*</code> in your request. You can also use all message
     * attributes starting with a prefix, for example <code>bar.*</code>.
     * </p>
     * 
     * @return The name of the message attribute, where <i>N</i> is the index.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The name can contain alphanumeric characters and the underscore (<code>_</code>), hyphen (<code>-</code>
     *         ), and period (<code>.</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The name is case-sensitive and must be unique among all attribute names for the message.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The name must not start with AWS-reserved prefixes such as <code>AWS.</code> or <code>Amazon.</code> (or
     *         any casing variants).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The name must not start or end with a period (<code>.</code>), and it should not have periods in
     *         succession (<code>..</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The name can be up to 256 characters long.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When using <code>ReceiveMessage</code>, you can send a list of attribute names to receive, or you can
     *         return all of the attributes by specifying <code>All</code> or <code>.*</code> in your request. You can
     *         also use all message attributes starting with a prefix, for example <code>bar.*</code>.
     */
    public List<String> messageAttributeNames() {
        return messageAttributeNames;
    }

    /**
     * <p>
     * The maximum number of messages to return. Amazon SQS never returns more messages than this value (however, fewer
     * messages might be returned). Valid values are 1 to 10. Default is 1.
     * </p>
     * 
     * @return The maximum number of messages to return. Amazon SQS never returns more messages than this value
     *         (however, fewer messages might be returned). Valid values are 1 to 10. Default is 1.
     */
    public Integer maxNumberOfMessages() {
        return maxNumberOfMessages;
    }

    /**
     * <p>
     * The duration (in seconds) that the received messages are hidden from subsequent retrieve requests after being
     * retrieved by a <code>ReceiveMessage</code> request.
     * </p>
     * 
     * @return The duration (in seconds) that the received messages are hidden from subsequent retrieve requests after
     *         being retrieved by a <code>ReceiveMessage</code> request.
     */
    public Integer visibilityTimeout() {
        return visibilityTimeout;
    }

    /**
     * <p>
     * The duration (in seconds) for which the call waits for a message to arrive in the queue before returning. If a
     * message is available, the call returns sooner than <code>WaitTimeSeconds</code>.
     * </p>
     * 
     * @return The duration (in seconds) for which the call waits for a message to arrive in the queue before returning.
     *         If a message is available, the call returns sooner than <code>WaitTimeSeconds</code>.
     */
    public Integer waitTimeSeconds() {
        return waitTimeSeconds;
    }

    /**
     * <p>
     * This parameter applies only to FIFO (first-in-first-out) queues.
     * </p>
     * <p>
     * The token used for deduplication of <code>ReceiveMessage</code> calls. If a networking issue occurs after a
     * <code>ReceiveMessage</code> action, and instead of a response you receive a generic error, you can retry the same
     * action with an identical <code>ReceiveRequestAttemptId</code> to retrieve the same set of messages, even if their
     * visibility timeout has not yet expired.
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can use <code>ReceiveRequestAttemptId</code> only for 5 minutes after a <code>ReceiveMessage</code> action.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you set <code>FifoQueue</code>, a caller of the <code>ReceiveMessage</code> action can provide a
     * <code>ReceiveRequestAttemptId</code> explicitly.
     * </p>
     * </li>
     * <li>
     * <p>
     * If a caller of the <code>ReceiveMessage</code> action doesn't provide a <code>ReceiveRequestAttemptId</code>,
     * Amazon SQS generates a <code>ReceiveRequestAttemptId</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can retry the <code>ReceiveMessage</code> action with the same <code>ReceiveRequestAttemptId</code> if none
     * of the messages have been modified (deleted or had their visibility changes).
     * </p>
     * </li>
     * <li>
     * <p>
     * During a visibility timeout, subsequent calls with the same <code>ReceiveRequestAttemptId</code> return the same
     * messages and receipt handles. If a retry occurs within the deduplication interval, it resets the visibility
     * timeout. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
     * >Visibility Timeout</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
     * </p>
     * <important>
     * <p>
     * If a caller of the <code>ReceiveMessage</code> action is still processing messages when the visibility timeout
     * expires and messages become visible, another worker reading from the same queue can receive the same messages and
     * therefore process duplicates. Also, if a reader whose message processing time is longer than the visibility
     * timeout tries to delete the processed messages, the action fails with an error.
     * </p>
     * <p>
     * To mitigate this effect, ensure that your application observes a safe threshold before the visibility timeout
     * expires and extend the visibility timeout as necessary.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * While messages with a particular <code>MessageGroupId</code> are invisible, no more messages belonging to the
     * same <code>MessageGroupId</code> are returned until the visibility timeout expires. You can still receive
     * messages with another <code>MessageGroupId</code> as long as it is also visible.
     * </p>
     * </li>
     * <li>
     * <p>
     * If a caller of <code>ReceiveMessage</code> can't track the <code>ReceiveRequestAttemptId</code>, no retries work
     * until the original visibility timeout expires. As a result, delays might occur but the messages in the queue
     * remain in a strict order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The length of <code>ReceiveRequestAttemptId</code> is 128 characters. <code>ReceiveRequestAttemptId</code> can
     * contain alphanumeric characters (<code>a-z</code>, <code>A-Z</code>, <code>0-9</code>) and punctuation (
     * <code>!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~</code>).
     * </p>
     * <p>
     * For best practices of using <code>ReceiveRequestAttemptId</code>, see <a href=
     * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queue-recommendations.html#using-receiverequestattemptid-request-parameter"
     * >Using the ReceiveRequestAttemptId Request Parameter</a> in the <i>Amazon Simple Queue Service Developer
     * Guide</i>.
     * </p>
     * 
     * @return This parameter applies only to FIFO (first-in-first-out) queues.</p>
     *         <p>
     *         The token used for deduplication of <code>ReceiveMessage</code> calls. If a networking issue occurs after
     *         a <code>ReceiveMessage</code> action, and instead of a response you receive a generic error, you can
     *         retry the same action with an identical <code>ReceiveRequestAttemptId</code> to retrieve the same set of
     *         messages, even if their visibility timeout has not yet expired.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You can use <code>ReceiveRequestAttemptId</code> only for 5 minutes after a <code>ReceiveMessage</code>
     *         action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When you set <code>FifoQueue</code>, a caller of the <code>ReceiveMessage</code> action can provide a
     *         <code>ReceiveRequestAttemptId</code> explicitly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If a caller of the <code>ReceiveMessage</code> action doesn't provide a
     *         <code>ReceiveRequestAttemptId</code>, Amazon SQS generates a <code>ReceiveRequestAttemptId</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You can retry the <code>ReceiveMessage</code> action with the same <code>ReceiveRequestAttemptId</code>
     *         if none of the messages have been modified (deleted or had their visibility changes).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         During a visibility timeout, subsequent calls with the same <code>ReceiveRequestAttemptId</code> return
     *         the same messages and receipt handles. If a retry occurs within the deduplication interval, it resets the
     *         visibility timeout. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
     *         >Visibility Timeout</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
     *         </p>
     *         <important>
     *         <p>
     *         If a caller of the <code>ReceiveMessage</code> action is still processing messages when the visibility
     *         timeout expires and messages become visible, another worker reading from the same queue can receive the
     *         same messages and therefore process duplicates. Also, if a reader whose message processing time is longer
     *         than the visibility timeout tries to delete the processed messages, the action fails with an error.
     *         </p>
     *         <p>
     *         To mitigate this effect, ensure that your application observes a safe threshold before the visibility
     *         timeout expires and extend the visibility timeout as necessary.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         While messages with a particular <code>MessageGroupId</code> are invisible, no more messages belonging to
     *         the same <code>MessageGroupId</code> are returned until the visibility timeout expires. You can still
     *         receive messages with another <code>MessageGroupId</code> as long as it is also visible.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If a caller of <code>ReceiveMessage</code> can't track the <code>ReceiveRequestAttemptId</code>, no
     *         retries work until the original visibility timeout expires. As a result, delays might occur but the
     *         messages in the queue remain in a strict order.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The length of <code>ReceiveRequestAttemptId</code> is 128 characters.
     *         <code>ReceiveRequestAttemptId</code> can contain alphanumeric characters (<code>a-z</code>,
     *         <code>A-Z</code>, <code>0-9</code>) and punctuation (
     *         <code>!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~</code>).
     *         </p>
     *         <p>
     *         For best practices of using <code>ReceiveRequestAttemptId</code>, see <a href=
     *         "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queue-recommendations.html#using-receiverequestattemptid-request-parameter"
     *         >Using the ReceiveRequestAttemptId Request Parameter</a> in the <i>Amazon Simple Queue Service Developer
     *         Guide</i>.
     */
    public String receiveRequestAttemptId() {
        return receiveRequestAttemptId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((queueUrl() == null) ? 0 : queueUrl().hashCode());
        hashCode = 31 * hashCode + ((attributeNames() == null) ? 0 : attributeNames().hashCode());
        hashCode = 31 * hashCode + ((messageAttributeNames() == null) ? 0 : messageAttributeNames().hashCode());
        hashCode = 31 * hashCode + ((maxNumberOfMessages() == null) ? 0 : maxNumberOfMessages().hashCode());
        hashCode = 31 * hashCode + ((visibilityTimeout() == null) ? 0 : visibilityTimeout().hashCode());
        hashCode = 31 * hashCode + ((waitTimeSeconds() == null) ? 0 : waitTimeSeconds().hashCode());
        hashCode = 31 * hashCode + ((receiveRequestAttemptId() == null) ? 0 : receiveRequestAttemptId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiveMessageRequest)) {
            return false;
        }
        ReceiveMessageRequest other = (ReceiveMessageRequest) obj;
        if (other.queueUrl() == null ^ this.queueUrl() == null) {
            return false;
        }
        if (other.queueUrl() != null && !other.queueUrl().equals(this.queueUrl())) {
            return false;
        }
        if (other.attributeNames() == null ^ this.attributeNames() == null) {
            return false;
        }
        if (other.attributeNames() != null && !other.attributeNames().equals(this.attributeNames())) {
            return false;
        }
        if (other.messageAttributeNames() == null ^ this.messageAttributeNames() == null) {
            return false;
        }
        if (other.messageAttributeNames() != null && !other.messageAttributeNames().equals(this.messageAttributeNames())) {
            return false;
        }
        if (other.maxNumberOfMessages() == null ^ this.maxNumberOfMessages() == null) {
            return false;
        }
        if (other.maxNumberOfMessages() != null && !other.maxNumberOfMessages().equals(this.maxNumberOfMessages())) {
            return false;
        }
        if (other.visibilityTimeout() == null ^ this.visibilityTimeout() == null) {
            return false;
        }
        if (other.visibilityTimeout() != null && !other.visibilityTimeout().equals(this.visibilityTimeout())) {
            return false;
        }
        if (other.waitTimeSeconds() == null ^ this.waitTimeSeconds() == null) {
            return false;
        }
        if (other.waitTimeSeconds() != null && !other.waitTimeSeconds().equals(this.waitTimeSeconds())) {
            return false;
        }
        if (other.receiveRequestAttemptId() == null ^ this.receiveRequestAttemptId() == null) {
            return false;
        }
        if (other.receiveRequestAttemptId() != null && !other.receiveRequestAttemptId().equals(this.receiveRequestAttemptId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (queueUrl() != null) {
            sb.append("QueueUrl: ").append(queueUrl()).append(",");
        }
        if (attributeNames() != null) {
            sb.append("AttributeNames: ").append(attributeNames()).append(",");
        }
        if (messageAttributeNames() != null) {
            sb.append("MessageAttributeNames: ").append(messageAttributeNames()).append(",");
        }
        if (maxNumberOfMessages() != null) {
            sb.append("MaxNumberOfMessages: ").append(maxNumberOfMessages()).append(",");
        }
        if (visibilityTimeout() != null) {
            sb.append("VisibilityTimeout: ").append(visibilityTimeout()).append(",");
        }
        if (waitTimeSeconds() != null) {
            sb.append("WaitTimeSeconds: ").append(waitTimeSeconds()).append(",");
        }
        if (receiveRequestAttemptId() != null) {
            sb.append("ReceiveRequestAttemptId: ").append(receiveRequestAttemptId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ReceiveMessageRequest> {
        /**
         * <p>
         * The URL of the Amazon SQS queue from which messages are received.
         * </p>
         * <p>
         * Queue URLs are case-sensitive.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the Amazon SQS queue from which messages are received.</p>
         *        <p>
         *        Queue URLs are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * A list of attributes that need to be returned along with each message. These attributes include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>All</code> - Returns all values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateFirstReceiveTimestamp</code> - Returns the time the message was first received from the
         * queue (<a href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateReceiveCount</code> - Returns the number of times a message has been received from the queue
         * but not deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SenderId</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * For an IAM user, returns the IAM user ID, for example <code>ABCDEFGHI1JKLMNOPQ23R</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For an IAM role, returns the IAM role ID, for example <code>ABCDE1F2GH3I4JK5LMNOP:i-a123b456</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>SentTimestamp</code> - Returns the time the message was sent to the queue (<a
         * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MessageDeduplicationId</code> - Returns the value provided by the sender that calls the
         * <code> <a>SendMessage</a> </code> action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MessageGroupId</code> - Returns the value provided by the sender that calls the
         * <code> <a>SendMessage</a> </code> action. Messages with the same <code>MessageGroupId</code> are returned in
         * sequence.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SequenceNumber</code> - Returns the value provided by Amazon SQS.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Any other valid special request parameters (such as the following) are ignored:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessages</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesDelayed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesNotVisible</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreatedTimestamp</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ContentBasedDeduplication</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DelaySeconds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FifoQueue</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastModifiedTimestamp</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MaximumMessageSize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MessageRetentionPeriod</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Policy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QueueArn</code>,
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReceiveMessageWaitTimeSeconds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RedrivePolicy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VisibilityTimeout</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributeNames
         *        A list of attributes that need to be returned along with each message. These attributes include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>All</code> - Returns all values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateFirstReceiveTimestamp</code> - Returns the time the message was first received from
         *        the queue (<a href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateReceiveCount</code> - Returns the number of times a message has been received from
         *        the queue but not deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SenderId</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For an IAM user, returns the IAM user ID, for example <code>ABCDEFGHI1JKLMNOPQ23R</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For an IAM role, returns the IAM role ID, for example <code>ABCDE1F2GH3I4JK5LMNOP:i-a123b456</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SentTimestamp</code> - Returns the time the message was sent to the queue (<a
         *        href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MessageDeduplicationId</code> - Returns the value provided by the sender that calls the
         *        <code> <a>SendMessage</a> </code> action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MessageGroupId</code> - Returns the value provided by the sender that calls the
         *        <code> <a>SendMessage</a> </code> action. Messages with the same <code>MessageGroupId</code> are
         *        returned in sequence.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SequenceNumber</code> - Returns the value provided by Amazon SQS.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Any other valid special request parameters (such as the following) are ignored:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessages</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesDelayed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesNotVisible</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreatedTimestamp</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ContentBasedDeduplication</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DelaySeconds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FifoQueue</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LastModifiedTimestamp</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MaximumMessageSize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MessageRetentionPeriod</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Policy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QueueArn</code>,
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReceiveMessageWaitTimeSeconds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RedrivePolicy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VisibilityTimeout</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueAttributeName
         */
        Builder attributeNames(Collection<String> attributeNames);

        /**
         * <p>
         * A list of attributes that need to be returned along with each message. These attributes include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>All</code> - Returns all values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateFirstReceiveTimestamp</code> - Returns the time the message was first received from the
         * queue (<a href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateReceiveCount</code> - Returns the number of times a message has been received from the queue
         * but not deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SenderId</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * For an IAM user, returns the IAM user ID, for example <code>ABCDEFGHI1JKLMNOPQ23R</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For an IAM role, returns the IAM role ID, for example <code>ABCDE1F2GH3I4JK5LMNOP:i-a123b456</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>SentTimestamp</code> - Returns the time the message was sent to the queue (<a
         * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MessageDeduplicationId</code> - Returns the value provided by the sender that calls the
         * <code> <a>SendMessage</a> </code> action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MessageGroupId</code> - Returns the value provided by the sender that calls the
         * <code> <a>SendMessage</a> </code> action. Messages with the same <code>MessageGroupId</code> are returned in
         * sequence.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SequenceNumber</code> - Returns the value provided by Amazon SQS.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Any other valid special request parameters (such as the following) are ignored:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessages</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesDelayed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesNotVisible</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreatedTimestamp</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ContentBasedDeduplication</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DelaySeconds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FifoQueue</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastModifiedTimestamp</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MaximumMessageSize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MessageRetentionPeriod</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Policy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QueueArn</code>,
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReceiveMessageWaitTimeSeconds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RedrivePolicy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VisibilityTimeout</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setAttributeNames(java.util.Collection)} or {@link #withAttributeNames(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param attributeNames
         *        A list of attributes that need to be returned along with each message. These attributes include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>All</code> - Returns all values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateFirstReceiveTimestamp</code> - Returns the time the message was first received from
         *        the queue (<a href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateReceiveCount</code> - Returns the number of times a message has been received from
         *        the queue but not deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SenderId</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For an IAM user, returns the IAM user ID, for example <code>ABCDEFGHI1JKLMNOPQ23R</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For an IAM role, returns the IAM role ID, for example <code>ABCDE1F2GH3I4JK5LMNOP:i-a123b456</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SentTimestamp</code> - Returns the time the message was sent to the queue (<a
         *        href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MessageDeduplicationId</code> - Returns the value provided by the sender that calls the
         *        <code> <a>SendMessage</a> </code> action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MessageGroupId</code> - Returns the value provided by the sender that calls the
         *        <code> <a>SendMessage</a> </code> action. Messages with the same <code>MessageGroupId</code> are
         *        returned in sequence.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SequenceNumber</code> - Returns the value provided by Amazon SQS.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Any other valid special request parameters (such as the following) are ignored:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessages</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesDelayed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesNotVisible</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreatedTimestamp</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ContentBasedDeduplication</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DelaySeconds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FifoQueue</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LastModifiedTimestamp</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MaximumMessageSize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MessageRetentionPeriod</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Policy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QueueArn</code>,
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReceiveMessageWaitTimeSeconds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RedrivePolicy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VisibilityTimeout</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueAttributeName
         */
        Builder attributeNames(String... attributeNames);

        /**
         * <p>
         * A list of attributes that need to be returned along with each message. These attributes include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>All</code> - Returns all values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateFirstReceiveTimestamp</code> - Returns the time the message was first received from the
         * queue (<a href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateReceiveCount</code> - Returns the number of times a message has been received from the queue
         * but not deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SenderId</code>
         * </p>
         * <ul>
         * <li>
         * <p>
         * For an IAM user, returns the IAM user ID, for example <code>ABCDEFGHI1JKLMNOPQ23R</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For an IAM role, returns the IAM role ID, for example <code>ABCDE1F2GH3I4JK5LMNOP:i-a123b456</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>SentTimestamp</code> - Returns the time the message was sent to the queue (<a
         * href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MessageDeduplicationId</code> - Returns the value provided by the sender that calls the
         * <code> <a>SendMessage</a> </code> action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MessageGroupId</code> - Returns the value provided by the sender that calls the
         * <code> <a>SendMessage</a> </code> action. Messages with the same <code>MessageGroupId</code> are returned in
         * sequence.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SequenceNumber</code> - Returns the value provided by Amazon SQS.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Any other valid special request parameters (such as the following) are ignored:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessages</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesDelayed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ApproximateNumberOfMessagesNotVisible</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreatedTimestamp</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ContentBasedDeduplication</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DelaySeconds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FifoQueue</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastModifiedTimestamp</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MaximumMessageSize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MessageRetentionPeriod</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Policy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QueueArn</code>,
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReceiveMessageWaitTimeSeconds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RedrivePolicy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VisibilityTimeout</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setAttributeNames(java.util.Collection)} or {@link #withAttributeNames(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param attributeNames
         *        A list of attributes that need to be returned along with each message. These attributes include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>All</code> - Returns all values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateFirstReceiveTimestamp</code> - Returns the time the message was first received from
         *        the queue (<a href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateReceiveCount</code> - Returns the number of times a message has been received from
         *        the queue but not deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SenderId</code>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For an IAM user, returns the IAM user ID, for example <code>ABCDEFGHI1JKLMNOPQ23R</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For an IAM role, returns the IAM role ID, for example <code>ABCDE1F2GH3I4JK5LMNOP:i-a123b456</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SentTimestamp</code> - Returns the time the message was sent to the queue (<a
         *        href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MessageDeduplicationId</code> - Returns the value provided by the sender that calls the
         *        <code> <a>SendMessage</a> </code> action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MessageGroupId</code> - Returns the value provided by the sender that calls the
         *        <code> <a>SendMessage</a> </code> action. Messages with the same <code>MessageGroupId</code> are
         *        returned in sequence.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SequenceNumber</code> - Returns the value provided by Amazon SQS.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Any other valid special request parameters (such as the following) are ignored:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessages</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesDelayed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ApproximateNumberOfMessagesNotVisible</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreatedTimestamp</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ContentBasedDeduplication</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DelaySeconds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FifoQueue</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LastModifiedTimestamp</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MaximumMessageSize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MessageRetentionPeriod</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Policy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QueueArn</code>,
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReceiveMessageWaitTimeSeconds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RedrivePolicy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VisibilityTimeout</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueAttributeName
         */
        Builder attributeNames(QueueAttributeName... attributeNames);

        /**
         * <p>
         * The name of the message attribute, where <i>N</i> is the index.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The name can contain alphanumeric characters and the underscore (<code>_</code>), hyphen (<code>-</code>),
         * and period (<code>.</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * The name is case-sensitive and must be unique among all attribute names for the message.
         * </p>
         * </li>
         * <li>
         * <p>
         * The name must not start with AWS-reserved prefixes such as <code>AWS.</code> or <code>Amazon.</code> (or any
         * casing variants).
         * </p>
         * </li>
         * <li>
         * <p>
         * The name must not start or end with a period (<code>.</code>), and it should not have periods in succession (
         * <code>..</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * The name can be up to 256 characters long.
         * </p>
         * </li>
         * </ul>
         * <p>
         * When using <code>ReceiveMessage</code>, you can send a list of attribute names to receive, or you can return
         * all of the attributes by specifying <code>All</code> or <code>.*</code> in your request. You can also use all
         * message attributes starting with a prefix, for example <code>bar.*</code>.
         * </p>
         * 
         * @param messageAttributeNames
         *        The name of the message attribute, where <i>N</i> is the index.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The name can contain alphanumeric characters and the underscore (<code>_</code>), hyphen (
         *        <code>-</code>), and period (<code>.</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The name is case-sensitive and must be unique among all attribute names for the message.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The name must not start with AWS-reserved prefixes such as <code>AWS.</code> or <code>Amazon.</code>
         *        (or any casing variants).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The name must not start or end with a period (<code>.</code>), and it should not have periods in
         *        succession (<code>..</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The name can be up to 256 characters long.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When using <code>ReceiveMessage</code>, you can send a list of attribute names to receive, or you can
         *        return all of the attributes by specifying <code>All</code> or <code>.*</code> in your request. You
         *        can also use all message attributes starting with a prefix, for example <code>bar.*</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageAttributeNames(Collection<String> messageAttributeNames);

        /**
         * <p>
         * The name of the message attribute, where <i>N</i> is the index.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The name can contain alphanumeric characters and the underscore (<code>_</code>), hyphen (<code>-</code>),
         * and period (<code>.</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * The name is case-sensitive and must be unique among all attribute names for the message.
         * </p>
         * </li>
         * <li>
         * <p>
         * The name must not start with AWS-reserved prefixes such as <code>AWS.</code> or <code>Amazon.</code> (or any
         * casing variants).
         * </p>
         * </li>
         * <li>
         * <p>
         * The name must not start or end with a period (<code>.</code>), and it should not have periods in succession (
         * <code>..</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * The name can be up to 256 characters long.
         * </p>
         * </li>
         * </ul>
         * <p>
         * When using <code>ReceiveMessage</code>, you can send a list of attribute names to receive, or you can return
         * all of the attributes by specifying <code>All</code> or <code>.*</code> in your request. You can also use all
         * message attributes starting with a prefix, for example <code>bar.*</code>.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setMessageAttributeNames(java.util.Collection)} or
         * {@link #withMessageAttributeNames(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param messageAttributeNames
         *        The name of the message attribute, where <i>N</i> is the index.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The name can contain alphanumeric characters and the underscore (<code>_</code>), hyphen (
         *        <code>-</code>), and period (<code>.</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The name is case-sensitive and must be unique among all attribute names for the message.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The name must not start with AWS-reserved prefixes such as <code>AWS.</code> or <code>Amazon.</code>
         *        (or any casing variants).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The name must not start or end with a period (<code>.</code>), and it should not have periods in
         *        succession (<code>..</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The name can be up to 256 characters long.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When using <code>ReceiveMessage</code>, you can send a list of attribute names to receive, or you can
         *        return all of the attributes by specifying <code>All</code> or <code>.*</code> in your request. You
         *        can also use all message attributes starting with a prefix, for example <code>bar.*</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageAttributeNames(String... messageAttributeNames);

        /**
         * <p>
         * The maximum number of messages to return. Amazon SQS never returns more messages than this value (however,
         * fewer messages might be returned). Valid values are 1 to 10. Default is 1.
         * </p>
         * 
         * @param maxNumberOfMessages
         *        The maximum number of messages to return. Amazon SQS never returns more messages than this value
         *        (however, fewer messages might be returned). Valid values are 1 to 10. Default is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxNumberOfMessages(Integer maxNumberOfMessages);

        /**
         * <p>
         * The duration (in seconds) that the received messages are hidden from subsequent retrieve requests after being
         * retrieved by a <code>ReceiveMessage</code> request.
         * </p>
         * 
         * @param visibilityTimeout
         *        The duration (in seconds) that the received messages are hidden from subsequent retrieve requests
         *        after being retrieved by a <code>ReceiveMessage</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibilityTimeout(Integer visibilityTimeout);

        /**
         * <p>
         * The duration (in seconds) for which the call waits for a message to arrive in the queue before returning. If
         * a message is available, the call returns sooner than <code>WaitTimeSeconds</code>.
         * </p>
         * 
         * @param waitTimeSeconds
         *        The duration (in seconds) for which the call waits for a message to arrive in the queue before
         *        returning. If a message is available, the call returns sooner than <code>WaitTimeSeconds</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitTimeSeconds(Integer waitTimeSeconds);

        /**
         * <p>
         * This parameter applies only to FIFO (first-in-first-out) queues.
         * </p>
         * <p>
         * The token used for deduplication of <code>ReceiveMessage</code> calls. If a networking issue occurs after a
         * <code>ReceiveMessage</code> action, and instead of a response you receive a generic error, you can retry the
         * same action with an identical <code>ReceiveRequestAttemptId</code> to retrieve the same set of messages, even
         * if their visibility timeout has not yet expired.
         * </p>
         * <ul>
         * <li>
         * <p>
         * You can use <code>ReceiveRequestAttemptId</code> only for 5 minutes after a <code>ReceiveMessage</code>
         * action.
         * </p>
         * </li>
         * <li>
         * <p>
         * When you set <code>FifoQueue</code>, a caller of the <code>ReceiveMessage</code> action can provide a
         * <code>ReceiveRequestAttemptId</code> explicitly.
         * </p>
         * </li>
         * <li>
         * <p>
         * If a caller of the <code>ReceiveMessage</code> action doesn't provide a <code>ReceiveRequestAttemptId</code>,
         * Amazon SQS generates a <code>ReceiveRequestAttemptId</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can retry the <code>ReceiveMessage</code> action with the same <code>ReceiveRequestAttemptId</code> if
         * none of the messages have been modified (deleted or had their visibility changes).
         * </p>
         * </li>
         * <li>
         * <p>
         * During a visibility timeout, subsequent calls with the same <code>ReceiveRequestAttemptId</code> return the
         * same messages and receipt handles. If a retry occurs within the deduplication interval, it resets the
         * visibility timeout. For more information, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
         * >Visibility Timeout</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
         * </p>
         * <important>
         * <p>
         * If a caller of the <code>ReceiveMessage</code> action is still processing messages when the visibility
         * timeout expires and messages become visible, another worker reading from the same queue can receive the same
         * messages and therefore process duplicates. Also, if a reader whose message processing time is longer than the
         * visibility timeout tries to delete the processed messages, the action fails with an error.
         * </p>
         * <p>
         * To mitigate this effect, ensure that your application observes a safe threshold before the visibility timeout
         * expires and extend the visibility timeout as necessary.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * While messages with a particular <code>MessageGroupId</code> are invisible, no more messages belonging to the
         * same <code>MessageGroupId</code> are returned until the visibility timeout expires. You can still receive
         * messages with another <code>MessageGroupId</code> as long as it is also visible.
         * </p>
         * </li>
         * <li>
         * <p>
         * If a caller of <code>ReceiveMessage</code> can't track the <code>ReceiveRequestAttemptId</code>, no retries
         * work until the original visibility timeout expires. As a result, delays might occur but the messages in the
         * queue remain in a strict order.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The length of <code>ReceiveRequestAttemptId</code> is 128 characters. <code>ReceiveRequestAttemptId</code>
         * can contain alphanumeric characters (<code>a-z</code>, <code>A-Z</code>, <code>0-9</code>) and punctuation (
         * <code>!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~</code>).
         * </p>
         * <p>
         * For best practices of using <code>ReceiveRequestAttemptId</code>, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queue-recommendations.html#using-receiverequestattemptid-request-parameter"
         * >Using the ReceiveRequestAttemptId Request Parameter</a> in the <i>Amazon Simple Queue Service Developer
         * Guide</i>.
         * </p>
         * 
         * @param receiveRequestAttemptId
         *        This parameter applies only to FIFO (first-in-first-out) queues.</p>
         *        <p>
         *        The token used for deduplication of <code>ReceiveMessage</code> calls. If a networking issue occurs
         *        after a <code>ReceiveMessage</code> action, and instead of a response you receive a generic error, you
         *        can retry the same action with an identical <code>ReceiveRequestAttemptId</code> to retrieve the same
         *        set of messages, even if their visibility timeout has not yet expired.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You can use <code>ReceiveRequestAttemptId</code> only for 5 minutes after a
         *        <code>ReceiveMessage</code> action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When you set <code>FifoQueue</code>, a caller of the <code>ReceiveMessage</code> action can provide a
         *        <code>ReceiveRequestAttemptId</code> explicitly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If a caller of the <code>ReceiveMessage</code> action doesn't provide a
         *        <code>ReceiveRequestAttemptId</code>, Amazon SQS generates a <code>ReceiveRequestAttemptId</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can retry the <code>ReceiveMessage</code> action with the same
         *        <code>ReceiveRequestAttemptId</code> if none of the messages have been modified (deleted or had their
         *        visibility changes).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        During a visibility timeout, subsequent calls with the same <code>ReceiveRequestAttemptId</code>
         *        return the same messages and receipt handles. If a retry occurs within the deduplication interval, it
         *        resets the visibility timeout. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html"
         *        >Visibility Timeout</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
         *        </p>
         *        <important>
         *        <p>
         *        If a caller of the <code>ReceiveMessage</code> action is still processing messages when the visibility
         *        timeout expires and messages become visible, another worker reading from the same queue can receive
         *        the same messages and therefore process duplicates. Also, if a reader whose message processing time is
         *        longer than the visibility timeout tries to delete the processed messages, the action fails with an
         *        error.
         *        </p>
         *        <p>
         *        To mitigate this effect, ensure that your application observes a safe threshold before the visibility
         *        timeout expires and extend the visibility timeout as necessary.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        While messages with a particular <code>MessageGroupId</code> are invisible, no more messages belonging
         *        to the same <code>MessageGroupId</code> are returned until the visibility timeout expires. You can
         *        still receive messages with another <code>MessageGroupId</code> as long as it is also visible.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If a caller of <code>ReceiveMessage</code> can't track the <code>ReceiveRequestAttemptId</code>, no
         *        retries work until the original visibility timeout expires. As a result, delays might occur but the
         *        messages in the queue remain in a strict order.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The length of <code>ReceiveRequestAttemptId</code> is 128 characters.
         *        <code>ReceiveRequestAttemptId</code> can contain alphanumeric characters (<code>a-z</code>,
         *        <code>A-Z</code>, <code>0-9</code>) and punctuation (
         *        <code>!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~</code>).
         *        </p>
         *        <p>
         *        For best practices of using <code>ReceiveRequestAttemptId</code>, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queue-recommendations.html#using-receiverequestattemptid-request-parameter"
         *        >Using the ReceiveRequestAttemptId Request Parameter</a> in the <i>Amazon Simple Queue Service
         *        Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiveRequestAttemptId(String receiveRequestAttemptId);
    }

    private static final class BuilderImpl implements Builder {
        private String queueUrl;

        private List<String> attributeNames = new SdkInternalList<>();

        private List<String> messageAttributeNames = new SdkInternalList<>();

        private Integer maxNumberOfMessages;

        private Integer visibilityTimeout;

        private Integer waitTimeSeconds;

        private String receiveRequestAttemptId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiveMessageRequest model) {
            setQueueUrl(model.queueUrl);
            setAttributeNames(model.attributeNames);
            setMessageAttributeNames(model.messageAttributeNames);
            setMaxNumberOfMessages(model.maxNumberOfMessages);
            setVisibilityTimeout(model.visibilityTimeout);
            setWaitTimeSeconds(model.waitTimeSeconds);
            setReceiveRequestAttemptId(model.receiveRequestAttemptId);
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Collection<String> getAttributeNames() {
            return attributeNames;
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String... attributeNames) {
            if (this.attributeNames == null) {
                this.attributeNames = new SdkInternalList<>(attributeNames.length);
            }
            for (String e : attributeNames) {
                this.attributeNames.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(QueueAttributeName... attributeNames) {
            if (this.attributeNames == null) {
                this.attributeNames = new SdkInternalList<String>(attributeNames.length);
            }
            for (QueueAttributeName ele : attributeNames) {
                this.attributeNames.add(ele.toString());
            }
            return this;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        @SafeVarargs
        public final void setAttributeNames(String... attributeNames) {
            if (this.attributeNames == null) {
                this.attributeNames = new SdkInternalList<>(attributeNames.length);
            }
            for (String e : attributeNames) {
                this.attributeNames.add(e);
            }
        }

        @SafeVarargs
        public final void setAttributeNames(QueueAttributeName... attributeNames) {
            if (this.attributeNames == null) {
                this.attributeNames = new SdkInternalList<String>(attributeNames.length);
            }
            for (QueueAttributeName ele : attributeNames) {
                this.attributeNames.add(ele.toString());
            }
        }

        public final Collection<String> getMessageAttributeNames() {
            return messageAttributeNames;
        }

        @Override
        public final Builder messageAttributeNames(Collection<String> messageAttributeNames) {
            this.messageAttributeNames = MessageAttributeNameListCopier.copy(messageAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageAttributeNames(String... messageAttributeNames) {
            if (this.messageAttributeNames == null) {
                this.messageAttributeNames = new SdkInternalList<>(messageAttributeNames.length);
            }
            for (String e : messageAttributeNames) {
                this.messageAttributeNames.add(e);
            }
            return this;
        }

        public final void setMessageAttributeNames(Collection<String> messageAttributeNames) {
            this.messageAttributeNames = MessageAttributeNameListCopier.copy(messageAttributeNames);
        }

        @SafeVarargs
        public final void setMessageAttributeNames(String... messageAttributeNames) {
            if (this.messageAttributeNames == null) {
                this.messageAttributeNames = new SdkInternalList<>(messageAttributeNames.length);
            }
            for (String e : messageAttributeNames) {
                this.messageAttributeNames.add(e);
            }
        }

        public final Integer getMaxNumberOfMessages() {
            return maxNumberOfMessages;
        }

        @Override
        public final Builder maxNumberOfMessages(Integer maxNumberOfMessages) {
            this.maxNumberOfMessages = maxNumberOfMessages;
            return this;
        }

        public final void setMaxNumberOfMessages(Integer maxNumberOfMessages) {
            this.maxNumberOfMessages = maxNumberOfMessages;
        }

        public final Integer getVisibilityTimeout() {
            return visibilityTimeout;
        }

        @Override
        public final Builder visibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        public final void setVisibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
        }

        public final Integer getWaitTimeSeconds() {
            return waitTimeSeconds;
        }

        @Override
        public final Builder waitTimeSeconds(Integer waitTimeSeconds) {
            this.waitTimeSeconds = waitTimeSeconds;
            return this;
        }

        public final void setWaitTimeSeconds(Integer waitTimeSeconds) {
            this.waitTimeSeconds = waitTimeSeconds;
        }

        public final String getReceiveRequestAttemptId() {
            return receiveRequestAttemptId;
        }

        @Override
        public final Builder receiveRequestAttemptId(String receiveRequestAttemptId) {
            this.receiveRequestAttemptId = receiveRequestAttemptId;
            return this;
        }

        public final void setReceiveRequestAttemptId(String receiveRequestAttemptId) {
            this.receiveRequestAttemptId = receiveRequestAttemptId;
        }

        @Override
        public ReceiveMessageRequest build() {
            return new ReceiveMessageRequest(this);
        }
    }
}
