/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of received messages.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReceiveMessageResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ReceiveMessageResponse.Builder, ReceiveMessageResponse> {
    private final List<Message> messages;

    private ReceiveMessageResponse(BuilderImpl builder) {
        this.messages = builder.messages;
    }

    /**
     * <p>
     * A list of messages.
     * </p>
     * 
     * @return A list of messages.
     */
    public List<Message> messages() {
        return messages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((messages() == null) ? 0 : messages().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiveMessageResponse)) {
            return false;
        }
        ReceiveMessageResponse other = (ReceiveMessageResponse) obj;
        if (other.messages() == null ^ this.messages() == null) {
            return false;
        }
        if (other.messages() != null && !other.messages().equals(this.messages())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (messages() != null) {
            sb.append("Messages: ").append(messages()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ReceiveMessageResponse> {
        /**
         * <p>
         * A list of messages.
         * </p>
         * 
         * @param messages
         *        A list of messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<Message> messages);

        /**
         * <p>
         * A list of messages.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setMessages(java.util.Collection)} or {@link #withMessages(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param messages
         *        A list of messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Message... messages);
    }

    private static final class BuilderImpl implements Builder {
        private List<Message> messages = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiveMessageResponse model) {
            setMessages(model.messages);
        }

        public final Collection<Message> getMessages() {
            return messages;
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message... messages) {
            if (this.messages == null) {
                this.messages = new SdkInternalList<>(messages.length);
            }
            for (Message e : messages) {
                this.messages.add(e);
            }
            return this;
        }

        public final void setMessages(Collection<Message> messages) {
            this.messages = MessageListCopier.copy(messages);
        }

        @SafeVarargs
        public final void setMessages(Message... messages) {
            if (this.messages == null) {
                this.messages = new SdkInternalList<>(messages.length);
            }
            for (Message e : messages) {
                this.messages.add(e);
            }
        }

        @Override
        public ReceiveMessageResponse build() {
            return new ReceiveMessageResponse(this);
        }
    }
}
