/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class RemovePermissionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RemovePermissionRequest.Builder, RemovePermissionRequest> {
    private final String queueUrl;

    private final String label;

    private RemovePermissionRequest(BuilderImpl builder) {
        this.queueUrl = builder.queueUrl;
        this.label = builder.label;
    }

    /**
     * <p>
     * The URL of the Amazon SQS queue from which permissions are removed.
     * </p>
     * <p>
     * Queue URLs are case-sensitive.
     * </p>
     * 
     * @return The URL of the Amazon SQS queue from which permissions are removed.</p>
     *         <p>
     *         Queue URLs are case-sensitive.
     */
    public String queueUrl() {
        return queueUrl;
    }

    /**
     * <p>
     * The identification of the permission to remove. This is the label added using the
     * <code> <a>AddPermission</a> </code> action.
     * </p>
     * 
     * @return The identification of the permission to remove. This is the label added using the
     *         <code> <a>AddPermission</a> </code> action.
     */
    public String label() {
        return label;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((queueUrl() == null) ? 0 : queueUrl().hashCode());
        hashCode = 31 * hashCode + ((label() == null) ? 0 : label().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemovePermissionRequest)) {
            return false;
        }
        RemovePermissionRequest other = (RemovePermissionRequest) obj;
        if (other.queueUrl() == null ^ this.queueUrl() == null) {
            return false;
        }
        if (other.queueUrl() != null && !other.queueUrl().equals(this.queueUrl())) {
            return false;
        }
        if (other.label() == null ^ this.label() == null) {
            return false;
        }
        if (other.label() != null && !other.label().equals(this.label())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (queueUrl() != null) {
            sb.append("QueueUrl: ").append(queueUrl()).append(",");
        }
        if (label() != null) {
            sb.append("Label: ").append(label()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RemovePermissionRequest> {
        /**
         * <p>
         * The URL of the Amazon SQS queue from which permissions are removed.
         * </p>
         * <p>
         * Queue URLs are case-sensitive.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the Amazon SQS queue from which permissions are removed.</p>
         *        <p>
         *        Queue URLs are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * The identification of the permission to remove. This is the label added using the
         * <code> <a>AddPermission</a> </code> action.
         * </p>
         * 
         * @param label
         *        The identification of the permission to remove. This is the label added using the
         *        <code> <a>AddPermission</a> </code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);
    }

    private static final class BuilderImpl implements Builder {
        private String queueUrl;

        private String label;

        private BuilderImpl() {
        }

        private BuilderImpl(RemovePermissionRequest model) {
            setQueueUrl(model.queueUrl);
            setLabel(model.label);
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final String getLabel() {
            return label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public RemovePermissionRequest build() {
            return new RemovePermissionRequest(this);
        }
    }
}
