/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class SendMessageRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SendMessageRequest.Builder, SendMessageRequest> {
    private final String queueUrl;

    private final String messageBody;

    private final Integer delaySeconds;

    private final Map<String, MessageAttributeValue> messageAttributes;

    private final String messageDeduplicationId;

    private final String messageGroupId;

    private SendMessageRequest(BuilderImpl builder) {
        this.queueUrl = builder.queueUrl;
        this.messageBody = builder.messageBody;
        this.delaySeconds = builder.delaySeconds;
        this.messageAttributes = builder.messageAttributes;
        this.messageDeduplicationId = builder.messageDeduplicationId;
        this.messageGroupId = builder.messageGroupId;
    }

    /**
     * <p>
     * The URL of the Amazon SQS queue to which a message is sent.
     * </p>
     * <p>
     * Queue URLs are case-sensitive.
     * </p>
     * 
     * @return The URL of the Amazon SQS queue to which a message is sent.</p>
     *         <p>
     *         Queue URLs are case-sensitive.
     */
    public String queueUrl() {
        return queueUrl;
    }

    /**
     * <p>
     * The message to send. The maximum string size is 256 KB.
     * </p>
     * <important>
     * <p>
     * A message can include only XML, JSON, and unformatted text. The following Unicode characters are allowed:
     * </p>
     * <p>
     * <code>#x9</code> | <code>#xA</code> | <code>#xD</code> | <code>#x20</code> to <code>#xD7FF</code> |
     * <code>#xE000</code> to <code>#xFFFD</code> | <code>#x10000</code> to <code>#x10FFFF</code>
     * </p>
     * <p>
     * Any characters not included in this list will be rejected. For more information, see the <a
     * href="http://www.w3.org/TR/REC-xml/#charsets">W3C specification for characters</a>.
     * </p>
     * </important>
     * 
     * @return The message to send. The maximum string size is 256 KB.</p> <important>
     *         <p>
     *         A message can include only XML, JSON, and unformatted text. The following Unicode characters are allowed:
     *         </p>
     *         <p>
     *         <code>#x9</code> | <code>#xA</code> | <code>#xD</code> | <code>#x20</code> to <code>#xD7FF</code> |
     *         <code>#xE000</code> to <code>#xFFFD</code> | <code>#x10000</code> to <code>#x10FFFF</code>
     *         </p>
     *         <p>
     *         Any characters not included in this list will be rejected. For more information, see the <a
     *         href="http://www.w3.org/TR/REC-xml/#charsets">W3C specification for characters</a>.
     *         </p>
     */
    public String messageBody() {
        return messageBody;
    }

    /**
     * <p>
     * The length of time, in seconds, for which to delay a specific message. Valid values: 0 to 900. Maximum: 15
     * minutes. Messages with a positive <code>DelaySeconds</code> value become available for processing after the delay
     * period is finished. If you don't specify a value, the default value for the queue applies.
     * </p>
     * <note>
     * <p>
     * When you set <code>FifoQueue</code>, you can't set <code>DelaySeconds</code> per message. You can set this
     * parameter only on a queue level.
     * </p>
     * </note>
     * 
     * @return The length of time, in seconds, for which to delay a specific message. Valid values: 0 to 900. Maximum:
     *         15 minutes. Messages with a positive <code>DelaySeconds</code> value become available for processing
     *         after the delay period is finished. If you don't specify a value, the default value for the queue
     *         applies. </p> <note>
     *         <p>
     *         When you set <code>FifoQueue</code>, you can't set <code>DelaySeconds</code> per message. You can set
     *         this parameter only on a queue level.
     *         </p>
     */
    public Integer delaySeconds() {
        return delaySeconds;
    }

    /**
     * <p>
     * Each message attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>. For more
     * information, see <a href=
     * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-attributes.html#message-attributes-items-validation"
     * >Message Attribute Items and Validation</a> in the <i>Amazon SQS Developer Guide</i>.
     * </p>
     * 
     * @return Each message attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>. For
     *         more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-attributes.html#message-attributes-items-validation"
     *         >Message Attribute Items and Validation</a> in the <i>Amazon SQS Developer Guide</i>.
     */
    public Map<String, MessageAttributeValue> messageAttributes() {
        return messageAttributes;
    }

    /**
     * <p>
     * This parameter applies only to FIFO (first-in-first-out) queues.
     * </p>
     * <p>
     * The token used for deduplication of sent messages. If a message with a particular
     * <code>MessageDeduplicationId</code> is sent successfully, any messages sent with the same
     * <code>MessageDeduplicationId</code> are accepted successfully but aren't delivered during the 5-minute
     * deduplication interval. For more information, see <a href=
     * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-exactly-once-processing"
     * > Exactly-Once Processing</a> in the <i>Amazon SQS Developer Guide</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Every message must have a unique <code>MessageDeduplicationId</code>,
     * </p>
     * <ul>
     * <li>
     * <p>
     * You may provide a <code>MessageDeduplicationId</code> explicitly.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you aren't able to provide a <code>MessageDeduplicationId</code> and you enable
     * <code>ContentBasedDeduplication</code> for your queue, Amazon SQS uses a SHA-256 hash to generate the
     * <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't provide a <code>MessageDeduplicationId</code> and the queue doesn't have
     * <code>ContentBasedDeduplication</code> set, the action fails with an error.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the queue has <code>ContentBasedDeduplication</code> set, your <code>MessageDeduplicationId</code> overrides
     * the generated one.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * When <code>ContentBasedDeduplication</code> is in effect, messages with identical content sent within the
     * deduplication interval are treated as duplicates and only one copy of the message is delivered.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you send one message with <code>ContentBasedDeduplication</code> enabled and then another message with a
     * <code>MessageDeduplicationId</code> that is the same as the one generated for the first
     * <code>MessageDeduplicationId</code>, the two messages are treated as duplicates and only one copy of the message
     * is delivered.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>MessageDeduplicationId</code> is available to the recipient of the message (this can be useful for
     * troubleshooting delivery issues).
     * </p>
     * <p>
     * If a message is sent successfully but the acknowledgement is lost and the message is resent with the same
     * <code>MessageDeduplicationId</code> after the deduplication interval, Amazon SQS can't detect duplicate messages.
     * </p>
     * </note>
     * <p>
     * The length of <code>MessageDeduplicationId</code> is 128 characters. <code>MessageDeduplicationId</code> can
     * contain alphanumeric characters (<code>a-z</code>, <code>A-Z</code>, <code>0-9</code>) and punctuation (
     * <code>!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~</code>).
     * </p>
     * <p>
     * For best practices of using <code>MessageDeduplicationId</code>, see <a href=
     * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queue-recommendations.html#using-messagededuplicationid-property"
     * >Using the MessageDeduplicationId Property</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
     * </p>
     * 
     * @return This parameter applies only to FIFO (first-in-first-out) queues.</p>
     *         <p>
     *         The token used for deduplication of sent messages. If a message with a particular
     *         <code>MessageDeduplicationId</code> is sent successfully, any messages sent with the same
     *         <code>MessageDeduplicationId</code> are accepted successfully but aren't delivered during the 5-minute
     *         deduplication interval. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-exactly-once-processing"
     *         > Exactly-Once Processing</a> in the <i>Amazon SQS Developer Guide</i>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Every message must have a unique <code>MessageDeduplicationId</code>,
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You may provide a <code>MessageDeduplicationId</code> explicitly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you aren't able to provide a <code>MessageDeduplicationId</code> and you enable
     *         <code>ContentBasedDeduplication</code> for your queue, Amazon SQS uses a SHA-256 hash to generate the
     *         <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the
     *         message).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you don't provide a <code>MessageDeduplicationId</code> and the queue doesn't have
     *         <code>ContentBasedDeduplication</code> set, the action fails with an error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the queue has <code>ContentBasedDeduplication</code> set, your <code>MessageDeduplicationId</code>
     *         overrides the generated one.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         When <code>ContentBasedDeduplication</code> is in effect, messages with identical content sent within the
     *         deduplication interval are treated as duplicates and only one copy of the message is delivered.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you send one message with <code>ContentBasedDeduplication</code> enabled and then another message with
     *         a <code>MessageDeduplicationId</code> that is the same as the one generated for the first
     *         <code>MessageDeduplicationId</code>, the two messages are treated as duplicates and only one copy of the
     *         message is delivered.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>MessageDeduplicationId</code> is available to the recipient of the message (this can be useful
     *         for troubleshooting delivery issues).
     *         </p>
     *         <p>
     *         If a message is sent successfully but the acknowledgement is lost and the message is resent with the same
     *         <code>MessageDeduplicationId</code> after the deduplication interval, Amazon SQS can't detect duplicate
     *         messages.
     *         </p>
     *         </note>
     *         <p>
     *         The length of <code>MessageDeduplicationId</code> is 128 characters. <code>MessageDeduplicationId</code>
     *         can contain alphanumeric characters (<code>a-z</code>, <code>A-Z</code>, <code>0-9</code>) and
     *         punctuation (<code>!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~</code>).
     *         </p>
     *         <p>
     *         For best practices of using <code>MessageDeduplicationId</code>, see <a href=
     *         "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queue-recommendations.html#using-messagededuplicationid-property"
     *         >Using the MessageDeduplicationId Property</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
     */
    public String messageDeduplicationId() {
        return messageDeduplicationId;
    }

    /**
     * <p>
     * This parameter applies only to FIFO (first-in-first-out) queues.
     * </p>
     * <p>
     * The tag that specifies that a message belongs to a specific message group. Messages that belong to the same
     * message group are processed in a FIFO manner (however, messages in different message groups might be processed
     * out of order). To interleave multiple ordered streams within a single queue, use <code>MessageGroupId</code>
     * values (for example, session data for multiple users). In this scenario, multiple readers can process the queue,
     * but the session data of each user is processed in a FIFO fashion.
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must associate a non-empty <code>MessageGroupId</code> with a message. If you don't provide a
     * <code>MessageGroupId</code>, the action fails.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReceiveMessage</code> might return messages with multiple <code>MessageGroupId</code> values. For each
     * <code>MessageGroupId</code>, the messages are sorted by time sent. The caller can't specify a
     * <code>MessageGroupId</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The length of <code>MessageGroupId</code> is 128 characters. Valid values are alphanumeric characters and
     * punctuation <code>(!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~)</code>.
     * </p>
     * <p>
     * For best practices of using <code>MessageGroupId</code>, see <a href=
     * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queue-recommendations.html#using-messagegroupid-property"
     * >Using the MessageGroupId Property</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
     * </p>
     * <important>
     * <p>
     * <code>MessageGroupId</code> is required for FIFO queues. You can't use it for Standard queues.
     * </p>
     * </important>
     * 
     * @return This parameter applies only to FIFO (first-in-first-out) queues.</p>
     *         <p>
     *         The tag that specifies that a message belongs to a specific message group. Messages that belong to the
     *         same message group are processed in a FIFO manner (however, messages in different message groups might be
     *         processed out of order). To interleave multiple ordered streams within a single queue, use
     *         <code>MessageGroupId</code> values (for example, session data for multiple users). In this scenario,
     *         multiple readers can process the queue, but the session data of each user is processed in a FIFO fashion.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You must associate a non-empty <code>MessageGroupId</code> with a message. If you don't provide a
     *         <code>MessageGroupId</code>, the action fails.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReceiveMessage</code> might return messages with multiple <code>MessageGroupId</code> values. For
     *         each <code>MessageGroupId</code>, the messages are sorted by time sent. The caller can't specify a
     *         <code>MessageGroupId</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The length of <code>MessageGroupId</code> is 128 characters. Valid values are alphanumeric characters and
     *         punctuation <code>(!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~)</code>.
     *         </p>
     *         <p>
     *         For best practices of using <code>MessageGroupId</code>, see <a href=
     *         "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queue-recommendations.html#using-messagegroupid-property"
     *         >Using the MessageGroupId Property</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
     *         </p>
     *         <important>
     *         <p>
     *         <code>MessageGroupId</code> is required for FIFO queues. You can't use it for Standard queues.
     *         </p>
     */
    public String messageGroupId() {
        return messageGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((queueUrl() == null) ? 0 : queueUrl().hashCode());
        hashCode = 31 * hashCode + ((messageBody() == null) ? 0 : messageBody().hashCode());
        hashCode = 31 * hashCode + ((delaySeconds() == null) ? 0 : delaySeconds().hashCode());
        hashCode = 31 * hashCode + ((messageAttributes() == null) ? 0 : messageAttributes().hashCode());
        hashCode = 31 * hashCode + ((messageDeduplicationId() == null) ? 0 : messageDeduplicationId().hashCode());
        hashCode = 31 * hashCode + ((messageGroupId() == null) ? 0 : messageGroupId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageRequest)) {
            return false;
        }
        SendMessageRequest other = (SendMessageRequest) obj;
        if (other.queueUrl() == null ^ this.queueUrl() == null) {
            return false;
        }
        if (other.queueUrl() != null && !other.queueUrl().equals(this.queueUrl())) {
            return false;
        }
        if (other.messageBody() == null ^ this.messageBody() == null) {
            return false;
        }
        if (other.messageBody() != null && !other.messageBody().equals(this.messageBody())) {
            return false;
        }
        if (other.delaySeconds() == null ^ this.delaySeconds() == null) {
            return false;
        }
        if (other.delaySeconds() != null && !other.delaySeconds().equals(this.delaySeconds())) {
            return false;
        }
        if (other.messageAttributes() == null ^ this.messageAttributes() == null) {
            return false;
        }
        if (other.messageAttributes() != null && !other.messageAttributes().equals(this.messageAttributes())) {
            return false;
        }
        if (other.messageDeduplicationId() == null ^ this.messageDeduplicationId() == null) {
            return false;
        }
        if (other.messageDeduplicationId() != null && !other.messageDeduplicationId().equals(this.messageDeduplicationId())) {
            return false;
        }
        if (other.messageGroupId() == null ^ this.messageGroupId() == null) {
            return false;
        }
        if (other.messageGroupId() != null && !other.messageGroupId().equals(this.messageGroupId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (queueUrl() != null) {
            sb.append("QueueUrl: ").append(queueUrl()).append(",");
        }
        if (messageBody() != null) {
            sb.append("MessageBody: ").append(messageBody()).append(",");
        }
        if (delaySeconds() != null) {
            sb.append("DelaySeconds: ").append(delaySeconds()).append(",");
        }
        if (messageAttributes() != null) {
            sb.append("MessageAttributes: ").append(messageAttributes()).append(",");
        }
        if (messageDeduplicationId() != null) {
            sb.append("MessageDeduplicationId: ").append(messageDeduplicationId()).append(",");
        }
        if (messageGroupId() != null) {
            sb.append("MessageGroupId: ").append(messageGroupId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SendMessageRequest> {
        /**
         * <p>
         * The URL of the Amazon SQS queue to which a message is sent.
         * </p>
         * <p>
         * Queue URLs are case-sensitive.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the Amazon SQS queue to which a message is sent.</p>
         *        <p>
         *        Queue URLs are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * The message to send. The maximum string size is 256 KB.
         * </p>
         * <important>
         * <p>
         * A message can include only XML, JSON, and unformatted text. The following Unicode characters are allowed:
         * </p>
         * <p>
         * <code>#x9</code> | <code>#xA</code> | <code>#xD</code> | <code>#x20</code> to <code>#xD7FF</code> |
         * <code>#xE000</code> to <code>#xFFFD</code> | <code>#x10000</code> to <code>#x10FFFF</code>
         * </p>
         * <p>
         * Any characters not included in this list will be rejected. For more information, see the <a
         * href="http://www.w3.org/TR/REC-xml/#charsets">W3C specification for characters</a>.
         * </p>
         * </important>
         * 
         * @param messageBody
         *        The message to send. The maximum string size is 256 KB.</p> <important>
         *        <p>
         *        A message can include only XML, JSON, and unformatted text. The following Unicode characters are
         *        allowed:
         *        </p>
         *        <p>
         *        <code>#x9</code> | <code>#xA</code> | <code>#xD</code> | <code>#x20</code> to <code>#xD7FF</code> |
         *        <code>#xE000</code> to <code>#xFFFD</code> | <code>#x10000</code> to <code>#x10FFFF</code>
         *        </p>
         *        <p>
         *        Any characters not included in this list will be rejected. For more information, see the <a
         *        href="http://www.w3.org/TR/REC-xml/#charsets">W3C specification for characters</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageBody(String messageBody);

        /**
         * <p>
         * The length of time, in seconds, for which to delay a specific message. Valid values: 0 to 900. Maximum: 15
         * minutes. Messages with a positive <code>DelaySeconds</code> value become available for processing after the
         * delay period is finished. If you don't specify a value, the default value for the queue applies.
         * </p>
         * <note>
         * <p>
         * When you set <code>FifoQueue</code>, you can't set <code>DelaySeconds</code> per message. You can set this
         * parameter only on a queue level.
         * </p>
         * </note>
         * 
         * @param delaySeconds
         *        The length of time, in seconds, for which to delay a specific message. Valid values: 0 to 900.
         *        Maximum: 15 minutes. Messages with a positive <code>DelaySeconds</code> value become available for
         *        processing after the delay period is finished. If you don't specify a value, the default value for the
         *        queue applies. </p> <note>
         *        <p>
         *        When you set <code>FifoQueue</code>, you can't set <code>DelaySeconds</code> per message. You can set
         *        this parameter only on a queue level.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delaySeconds(Integer delaySeconds);

        /**
         * <p>
         * Each message attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>. For more
         * information, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-attributes.html#message-attributes-items-validation"
         * >Message Attribute Items and Validation</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * 
         * @param messageAttributes
         *        Each message attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>. For
         *        more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-attributes.html#message-attributes-items-validation"
         *        >Message Attribute Items and Validation</a> in the <i>Amazon SQS Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes);

        /**
         * <p>
         * This parameter applies only to FIFO (first-in-first-out) queues.
         * </p>
         * <p>
         * The token used for deduplication of sent messages. If a message with a particular
         * <code>MessageDeduplicationId</code> is sent successfully, any messages sent with the same
         * <code>MessageDeduplicationId</code> are accepted successfully but aren't delivered during the 5-minute
         * deduplication interval. For more information, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-exactly-once-processing"
         * > Exactly-Once Processing</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Every message must have a unique <code>MessageDeduplicationId</code>,
         * </p>
         * <ul>
         * <li>
         * <p>
         * You may provide a <code>MessageDeduplicationId</code> explicitly.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you aren't able to provide a <code>MessageDeduplicationId</code> and you enable
         * <code>ContentBasedDeduplication</code> for your queue, Amazon SQS uses a SHA-256 hash to generate the
         * <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't provide a <code>MessageDeduplicationId</code> and the queue doesn't have
         * <code>ContentBasedDeduplication</code> set, the action fails with an error.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the queue has <code>ContentBasedDeduplication</code> set, your <code>MessageDeduplicationId</code>
         * overrides the generated one.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * When <code>ContentBasedDeduplication</code> is in effect, messages with identical content sent within the
         * deduplication interval are treated as duplicates and only one copy of the message is delivered.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you send one message with <code>ContentBasedDeduplication</code> enabled and then another message with a
         * <code>MessageDeduplicationId</code> that is the same as the one generated for the first
         * <code>MessageDeduplicationId</code>, the two messages are treated as duplicates and only one copy of the
         * message is delivered.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>MessageDeduplicationId</code> is available to the recipient of the message (this can be useful for
         * troubleshooting delivery issues).
         * </p>
         * <p>
         * If a message is sent successfully but the acknowledgement is lost and the message is resent with the same
         * <code>MessageDeduplicationId</code> after the deduplication interval, Amazon SQS can't detect duplicate
         * messages.
         * </p>
         * </note>
         * <p>
         * The length of <code>MessageDeduplicationId</code> is 128 characters. <code>MessageDeduplicationId</code> can
         * contain alphanumeric characters (<code>a-z</code>, <code>A-Z</code>, <code>0-9</code>) and punctuation (
         * <code>!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~</code>).
         * </p>
         * <p>
         * For best practices of using <code>MessageDeduplicationId</code>, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queue-recommendations.html#using-messagededuplicationid-property"
         * >Using the MessageDeduplicationId Property</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
         * </p>
         * 
         * @param messageDeduplicationId
         *        This parameter applies only to FIFO (first-in-first-out) queues.</p>
         *        <p>
         *        The token used for deduplication of sent messages. If a message with a particular
         *        <code>MessageDeduplicationId</code> is sent successfully, any messages sent with the same
         *        <code>MessageDeduplicationId</code> are accepted successfully but aren't delivered during the 5-minute
         *        deduplication interval. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-exactly-once-processing"
         *        > Exactly-Once Processing</a> in the <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Every message must have a unique <code>MessageDeduplicationId</code>,
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You may provide a <code>MessageDeduplicationId</code> explicitly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you aren't able to provide a <code>MessageDeduplicationId</code> and you enable
         *        <code>ContentBasedDeduplication</code> for your queue, Amazon SQS uses a SHA-256 hash to generate the
         *        <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the
         *        message).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't provide a <code>MessageDeduplicationId</code> and the queue doesn't have
         *        <code>ContentBasedDeduplication</code> set, the action fails with an error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the queue has <code>ContentBasedDeduplication</code> set, your <code>MessageDeduplicationId</code>
         *        overrides the generated one.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        When <code>ContentBasedDeduplication</code> is in effect, messages with identical content sent within
         *        the deduplication interval are treated as duplicates and only one copy of the message is delivered.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you send one message with <code>ContentBasedDeduplication</code> enabled and then another message
         *        with a <code>MessageDeduplicationId</code> that is the same as the one generated for the first
         *        <code>MessageDeduplicationId</code>, the two messages are treated as duplicates and only one copy of
         *        the message is delivered.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>MessageDeduplicationId</code> is available to the recipient of the message (this can be
         *        useful for troubleshooting delivery issues).
         *        </p>
         *        <p>
         *        If a message is sent successfully but the acknowledgement is lost and the message is resent with the
         *        same <code>MessageDeduplicationId</code> after the deduplication interval, Amazon SQS can't detect
         *        duplicate messages.
         *        </p>
         *        </note>
         *        <p>
         *        The length of <code>MessageDeduplicationId</code> is 128 characters.
         *        <code>MessageDeduplicationId</code> can contain alphanumeric characters (<code>a-z</code>,
         *        <code>A-Z</code>, <code>0-9</code>) and punctuation (
         *        <code>!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~</code>).
         *        </p>
         *        <p>
         *        For best practices of using <code>MessageDeduplicationId</code>, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queue-recommendations.html#using-messagededuplicationid-property"
         *        >Using the MessageDeduplicationId Property</a> in the <i>Amazon Simple Queue Service Developer
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageDeduplicationId(String messageDeduplicationId);

        /**
         * <p>
         * This parameter applies only to FIFO (first-in-first-out) queues.
         * </p>
         * <p>
         * The tag that specifies that a message belongs to a specific message group. Messages that belong to the same
         * message group are processed in a FIFO manner (however, messages in different message groups might be
         * processed out of order). To interleave multiple ordered streams within a single queue, use
         * <code>MessageGroupId</code> values (for example, session data for multiple users). In this scenario, multiple
         * readers can process the queue, but the session data of each user is processed in a FIFO fashion.
         * </p>
         * <ul>
         * <li>
         * <p>
         * You must associate a non-empty <code>MessageGroupId</code> with a message. If you don't provide a
         * <code>MessageGroupId</code>, the action fails.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReceiveMessage</code> might return messages with multiple <code>MessageGroupId</code> values. For each
         * <code>MessageGroupId</code>, the messages are sorted by time sent. The caller can't specify a
         * <code>MessageGroupId</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The length of <code>MessageGroupId</code> is 128 characters. Valid values are alphanumeric characters and
         * punctuation <code>(!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~)</code>.
         * </p>
         * <p>
         * For best practices of using <code>MessageGroupId</code>, see <a href=
         * "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queue-recommendations.html#using-messagegroupid-property"
         * >Using the MessageGroupId Property</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
         * </p>
         * <important>
         * <p>
         * <code>MessageGroupId</code> is required for FIFO queues. You can't use it for Standard queues.
         * </p>
         * </important>
         * 
         * @param messageGroupId
         *        This parameter applies only to FIFO (first-in-first-out) queues.</p>
         *        <p>
         *        The tag that specifies that a message belongs to a specific message group. Messages that belong to the
         *        same message group are processed in a FIFO manner (however, messages in different message groups might
         *        be processed out of order). To interleave multiple ordered streams within a single queue, use
         *        <code>MessageGroupId</code> values (for example, session data for multiple users). In this scenario,
         *        multiple readers can process the queue, but the session data of each user is processed in a FIFO
         *        fashion.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You must associate a non-empty <code>MessageGroupId</code> with a message. If you don't provide a
         *        <code>MessageGroupId</code>, the action fails.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReceiveMessage</code> might return messages with multiple <code>MessageGroupId</code> values.
         *        For each <code>MessageGroupId</code>, the messages are sorted by time sent. The caller can't specify a
         *        <code>MessageGroupId</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The length of <code>MessageGroupId</code> is 128 characters. Valid values are alphanumeric characters
         *        and punctuation <code>(!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~)</code>.
         *        </p>
         *        <p>
         *        For best practices of using <code>MessageGroupId</code>, see <a href=
         *        "http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queue-recommendations.html#using-messagegroupid-property"
         *        >Using the MessageGroupId Property</a> in the <i>Amazon Simple Queue Service Developer Guide</i>.
         *        </p>
         *        <important>
         *        <p>
         *        <code>MessageGroupId</code> is required for FIFO queues. You can't use it for Standard queues.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageGroupId(String messageGroupId);
    }

    private static final class BuilderImpl implements Builder {
        private String queueUrl;

        private String messageBody;

        private Integer delaySeconds;

        private Map<String, MessageAttributeValue> messageAttributes = new SdkInternalMap<>();

        private String messageDeduplicationId;

        private String messageGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageRequest model) {
            setQueueUrl(model.queueUrl);
            setMessageBody(model.messageBody);
            setDelaySeconds(model.delaySeconds);
            setMessageAttributes(model.messageAttributes);
            setMessageDeduplicationId(model.messageDeduplicationId);
            setMessageGroupId(model.messageGroupId);
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final String getMessageBody() {
            return messageBody;
        }

        @Override
        public final Builder messageBody(String messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public final void setMessageBody(String messageBody) {
            this.messageBody = messageBody;
        }

        public final Integer getDelaySeconds() {
            return delaySeconds;
        }

        @Override
        public final Builder delaySeconds(Integer delaySeconds) {
            this.delaySeconds = delaySeconds;
            return this;
        }

        public final void setDelaySeconds(Integer delaySeconds) {
            this.delaySeconds = delaySeconds;
        }

        public final Map<String, MessageAttributeValue> getMessageAttributes() {
            return messageAttributes;
        }

        @Override
        public final Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageBodyAttributeMapCopier.copy(messageAttributes);
            return this;
        }

        public final void setMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageBodyAttributeMapCopier.copy(messageAttributes);
        }

        public final String getMessageDeduplicationId() {
            return messageDeduplicationId;
        }

        @Override
        public final Builder messageDeduplicationId(String messageDeduplicationId) {
            this.messageDeduplicationId = messageDeduplicationId;
            return this;
        }

        public final void setMessageDeduplicationId(String messageDeduplicationId) {
            this.messageDeduplicationId = messageDeduplicationId;
        }

        public final String getMessageGroupId() {
            return messageGroupId;
        }

        @Override
        public final Builder messageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
            return this;
        }

        public final void setMessageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
        }

        @Override
        public SendMessageRequest build() {
            return new SendMessageRequest(this);
        }
    }
}
