/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.sqs.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * AddPermissionRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AddPermissionRequestMarshaller implements Marshaller<Request<AddPermissionRequest>, AddPermissionRequest> {

    public Request<AddPermissionRequest> marshall(AddPermissionRequest addPermissionRequest) {

        if (addPermissionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<AddPermissionRequest> request = new DefaultRequest<AddPermissionRequest>(addPermissionRequest, "SQSClient");
        request.addParameter("Action", "AddPermission");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);

        if (addPermissionRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(addPermissionRequest.queueUrl()));
        }

        if (addPermissionRequest.label() != null) {
            request.addParameter("Label", StringUtils.fromString(addPermissionRequest.label()));
        }

        software.amazon.awssdk.runtime.SdkInternalList<String> aWSAccountIdsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) addPermissionRequest
                .awsAccountIds();
        if (!aWSAccountIdsList.isEmpty() || !aWSAccountIdsList.isAutoConstruct()) {
            int aWSAccountIdsListIndex = 1;

            for (String aWSAccountIdsListValue : aWSAccountIdsList) {
                if (aWSAccountIdsListValue != null) {
                    request.addParameter("AWSAccountId." + aWSAccountIdsListIndex, StringUtils.fromString(aWSAccountIdsListValue));
                }
                aWSAccountIdsListIndex++;
            }
        }

        software.amazon.awssdk.runtime.SdkInternalList<String> actionsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) addPermissionRequest
                .actions();
        if (!actionsList.isEmpty() || !actionsList.isAutoConstruct()) {
            int actionsListIndex = 1;

            for (String actionsListValue : actionsList) {
                if (actionsListValue != null) {
                    request.addParameter("ActionName." + actionsListIndex, StringUtils.fromString(actionsListValue));
                }
                actionsListIndex++;
            }
        }

        return request;
    }

}
