/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.transform;

import java.util.Map;
import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.sqs.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * SendMessageBatchRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SendMessageBatchRequestMarshaller implements Marshaller<Request<SendMessageBatchRequest>, SendMessageBatchRequest> {

    public Request<SendMessageBatchRequest> marshall(SendMessageBatchRequest sendMessageBatchRequest) {

        if (sendMessageBatchRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<SendMessageBatchRequest> request = new DefaultRequest<SendMessageBatchRequest>(sendMessageBatchRequest,
                "SQSClient");
        request.addParameter("Action", "SendMessageBatch");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);

        if (sendMessageBatchRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(sendMessageBatchRequest.queueUrl()));
        }

        software.amazon.awssdk.runtime.SdkInternalList<SendMessageBatchRequestEntry> entriesList = (software.amazon.awssdk.runtime.SdkInternalList<SendMessageBatchRequestEntry>) sendMessageBatchRequest
                .entries();
        if (!entriesList.isEmpty() || !entriesList.isAutoConstruct()) {
            int entriesListIndex = 1;

            for (SendMessageBatchRequestEntry entriesListValue : entriesList) {

                if (entriesListValue.id() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".Id",
                            StringUtils.fromString(entriesListValue.id()));
                }

                if (entriesListValue.messageBody() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageBody",
                            StringUtils.fromString(entriesListValue.messageBody()));
                }

                if (entriesListValue.delaySeconds() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".DelaySeconds",
                            StringUtils.fromInteger(entriesListValue.delaySeconds()));
                }

                java.util.Map<String, MessageAttributeValue> messageAttributes = entriesListValue.messageAttributes();
                int messageAttributesListIndex = 1;
                for (Map.Entry<String, MessageAttributeValue> entry : messageAttributes.entrySet()) {
                    if (entry.getKey() != null) {
                        request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute."
                                + messageAttributesListIndex + ".Name", StringUtils.fromString(entry.getKey()));
                    }
                    if (entry.getValue() != null) {

                        if (entry.getValue().stringValue() != null) {
                            request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute."
                                    + messageAttributesListIndex + ".Value.StringValue",
                                    StringUtils.fromString(entry.getValue().stringValue()));
                        }

                        if (entry.getValue().binaryValue() != null) {
                            request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute."
                                    + messageAttributesListIndex + ".Value.BinaryValue",
                                    StringUtils.fromByteBuffer(entry.getValue().binaryValue()));
                        }

                        software.amazon.awssdk.runtime.SdkInternalList<String> stringListValuesList = (software.amazon.awssdk.runtime.SdkInternalList<String>) entry
                                .getValue().stringListValues();
                        if (!stringListValuesList.isEmpty() || !stringListValuesList.isAutoConstruct()) {
                            int stringListValuesListIndex = 1;

                            for (String stringListValuesListValue : stringListValuesList) {
                                if (stringListValuesListValue != null) {
                                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex
                                            + ".MessageAttribute." + messageAttributesListIndex + ".Value.StringListValue."
                                            + stringListValuesListIndex, StringUtils.fromString(stringListValuesListValue));
                                }
                                stringListValuesListIndex++;
                            }
                        }

                        software.amazon.awssdk.runtime.SdkInternalList<java.nio.ByteBuffer> binaryListValuesList = (software.amazon.awssdk.runtime.SdkInternalList<java.nio.ByteBuffer>) entry
                                .getValue().binaryListValues();
                        if (!binaryListValuesList.isEmpty() || !binaryListValuesList.isAutoConstruct()) {
                            int binaryListValuesListIndex = 1;

                            for (java.nio.ByteBuffer binaryListValuesListValue : binaryListValuesList) {
                                if (binaryListValuesListValue != null) {
                                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex
                                            + ".MessageAttribute." + messageAttributesListIndex + ".Value.BinaryListValue."
                                            + binaryListValuesListIndex, StringUtils.fromByteBuffer(binaryListValuesListValue));
                                }
                                binaryListValuesListIndex++;
                            }
                        }

                        if (entry.getValue().dataType() != null) {
                            request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute."
                                    + messageAttributesListIndex + ".Value.DataType",
                                    StringUtils.fromString(entry.getValue().dataType()));
                        }
                    }
                    messageAttributesListIndex++;
                }

                if (entriesListValue.messageDeduplicationId() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageDeduplicationId",
                            StringUtils.fromString(entriesListValue.messageDeduplicationId()));
                }

                if (entriesListValue.messageGroupId() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageGroupId",
                            StringUtils.fromString(entriesListValue.messageGroupId()));
                }
                entriesListIndex++;
            }
        }

        return request;
    }

}
