/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.buffered;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.AmazonClientException;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.sqs.SQSAsyncClient;
import software.amazon.awssdk.services.sqs.buffered.QueueBufferCallback;
import software.amazon.awssdk.services.sqs.buffered.QueueBufferConfig;
import software.amazon.awssdk.services.sqs.buffered.QueueBufferFuture;
import software.amazon.awssdk.services.sqs.buffered.ResultConverter;
import software.amazon.awssdk.services.sqs.buffered.SqsBufferedAsyncClient;
import software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResultEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResultEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResultEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;

public class SendQueueBuffer {
    private static Log log = LogFactory.getLog(SendQueueBuffer.class);
    private final QueueBufferConfig config;
    private final String qUrl;
    private final SQSAsyncClient sqsClient;
    private final Executor executor;
    private final Object sendMessageLock = new Object();
    private final Object deleteMessageLock = new Object();
    private final Object changeMessageVisibilityLock = new Object();
    private final SendMessageBatchTask[] openSendMessageBatchTask = new SendMessageBatchTask[1];
    private final DeleteMessageBatchTask[] openDeleteMessageBatchTask = new DeleteMessageBatchTask[1];
    private final ChangeMessageVisibilityBatchTask[] openChangeMessageVisibilityBatchTask = new ChangeMessageVisibilityBatchTask[1];
    private final Semaphore inflightSendMessageBatches;
    private final Semaphore inflightDeleteMessageBatches;
    private final Semaphore inflightChangeMessageVisibilityBatches;

    SendQueueBuffer(SQSAsyncClient sqsClient, Executor executor, QueueBufferConfig paramConfig, String url) {
        this.sqsClient = sqsClient;
        this.executor = executor;
        this.config = paramConfig;
        this.qUrl = url;
        int maxBatch = this.config.getMaxInflightOutboundBatches();
        maxBatch = maxBatch > 0 ? maxBatch : 1;
        this.inflightSendMessageBatches = new Semaphore(maxBatch);
        this.inflightDeleteMessageBatches = new Semaphore(maxBatch);
        this.inflightChangeMessageVisibilityBatches = new Semaphore(maxBatch);
    }

    public QueueBufferConfig getConfig() {
        return this.config;
    }

    public QueueBufferFuture<SendMessageRequest, SendMessageResponse> sendMessage(SendMessageRequest request, QueueBufferCallback<SendMessageRequest, SendMessageResponse> callback) {
        return this.submitOutboundRequest(this.sendMessageLock, this.openSendMessageBatchTask, request, this.inflightSendMessageBatches, callback);
    }

    public QueueBufferFuture<DeleteMessageRequest, DeleteMessageResponse> deleteMessage(DeleteMessageRequest request, QueueBufferCallback<DeleteMessageRequest, DeleteMessageResponse> callback) {
        return this.submitOutboundRequest(this.deleteMessageLock, this.openDeleteMessageBatchTask, request, this.inflightDeleteMessageBatches, callback);
    }

    public QueueBufferFuture<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResponse> changeMessageVisibility(ChangeMessageVisibilityRequest request, QueueBufferCallback<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResponse> callback) {
        return this.submitOutboundRequest(this.changeMessageVisibilityLock, this.openChangeMessageVisibilityBatchTask, request, this.inflightChangeMessageVisibilityBatches, callback);
    }

    private <R extends AmazonWebServiceRequest, ResultT> OutboundBatchTask<R, ResultT> newOutboundBatchTask(R request) {
        if (request instanceof SendMessageRequest) {
            return new SendMessageBatchTask();
        }
        if (request instanceof DeleteMessageRequest) {
            return new DeleteMessageBatchTask();
        }
        if (request instanceof ChangeMessageVisibilityRequest) {
            return new ChangeMessageVisibilityBatchTask();
        }
        throw new IllegalArgumentException("Unsupported request type " + request.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        try {
            Object object = this.sendMessageLock;
            synchronized (object) {
                this.inflightSendMessageBatches.acquire(this.config.getMaxInflightOutboundBatches());
                this.inflightSendMessageBatches.release(this.config.getMaxInflightOutboundBatches());
            }
            object = this.deleteMessageLock;
            synchronized (object) {
                this.inflightDeleteMessageBatches.acquire(this.config.getMaxInflightOutboundBatches());
                this.inflightDeleteMessageBatches.release(this.config.getMaxInflightOutboundBatches());
            }
            object = this.changeMessageVisibilityLock;
            synchronized (object) {
                this.inflightChangeMessageVisibilityBatches.acquire(this.config.getMaxInflightOutboundBatches());
                this.inflightChangeMessageVisibilityBatches.release(this.config.getMaxInflightOutboundBatches());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <OBT extends OutboundBatchTask<R, ResultT>, R extends AmazonWebServiceRequest, ResultT> QueueBufferFuture<R, ResultT> submitOutboundRequest(Object operationLock, OBT[] openOutboundBatchTask, R request, final Semaphore inflightOperationBatches, QueueBufferCallback<R, ResultT> callback) {
        QueueBufferFuture<R, ResultT> theFuture = null;
        try {
            Object object = operationLock;
            synchronized (object) {
                if (openOutboundBatchTask[0] != null) {
                    theFuture = ((OutboundBatchTask)openOutboundBatchTask[0]).addRequest(request, callback);
                }
                if (openOutboundBatchTask[0] == null || theFuture == null) {
                    OutboundBatchTask<R, ResultT> obt = this.newOutboundBatchTask(request);
                    inflightOperationBatches.acquire();
                    openOutboundBatchTask[0] = obt;
                    ((OutboundBatchTask)openOutboundBatchTask[0]).setOnCompleted(new Listener<OutboundBatchTask<R, ResultT>>(){

                        @Override
                        public void invoke(OutboundBatchTask<R, ResultT> task) {
                            inflightOperationBatches.release();
                        }
                    });
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Queue " + this.qUrl + " created new batch for " + request.getClass().toString() + " " + inflightOperationBatches.availablePermits() + " free slots remain"));
                    }
                    theFuture = ((OutboundBatchTask)openOutboundBatchTask[0]).addRequest(request, callback);
                    this.executor.execute((Runnable)openOutboundBatchTask[0]);
                    if (null == theFuture) {
                        throw new AmazonClientException("Failed to schedule request " + request + " for execution");
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            AmazonClientException toThrow = new AmazonClientException("Interrupted while waiting for lock.");
            toThrow.initCause((Throwable)e);
            throw toThrow;
        }
        return theFuture;
    }

    private class ChangeMessageVisibilityBatchTask
    extends OutboundBatchTask<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResponse> {
        private ChangeMessageVisibilityBatchTask() {
        }

        @Override
        protected void process(List<ChangeMessageVisibilityRequest> requests, List<QueueBufferFuture<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResponse>> futures) {
            int index;
            if (requests.isEmpty()) {
                return;
            }
            ChangeMessageVisibilityBatchRequest.Builder batchRequestBuilder = ChangeMessageVisibilityBatchRequest.builder().queueUrl(SendQueueBuffer.this.qUrl);
            ArrayList<ChangeMessageVisibilityBatchRequestEntry> entries = new ArrayList<ChangeMessageVisibilityBatchRequestEntry>(requests.size());
            int n = requests.size();
            for (int i = 0; i < n; ++i) {
                entries.add((ChangeMessageVisibilityBatchRequestEntry)ChangeMessageVisibilityBatchRequestEntry.builder().id(Integer.toString(i)).receiptHandle(requests.get(i).receiptHandle()).visibilityTimeout(requests.get(i).visibilityTimeout()).build());
            }
            ChangeMessageVisibilityBatchRequest batchRequest = (ChangeMessageVisibilityBatchRequest)((Object)batchRequestBuilder.entries(entries).build());
            ResultConverter.appendUserAgent(batchRequest, SqsBufferedAsyncClient.USER_AGENT);
            ChangeMessageVisibilityBatchResponse batchResult = SendQueueBuffer.this.sqsClient.changeMessageVisibilityBatch(batchRequest).join();
            for (ChangeMessageVisibilityBatchResultEntry entry : batchResult.successful()) {
                index = Integer.parseInt(entry.id());
                futures.get(index).setSuccess(null);
            }
            for (BatchResultErrorEntry errorEntry : batchResult.failed()) {
                index = Integer.parseInt(errorEntry.id());
                if (errorEntry.senderFault().booleanValue()) {
                    futures.get(index).setFailure(ResultConverter.convert(errorEntry));
                    continue;
                }
                try {
                    SendQueueBuffer.this.sqsClient.changeMessageVisibility(requests.get(index));
                    futures.get(index).setSuccess(null);
                }
                catch (AmazonClientException ace) {
                    futures.get(index).setFailure((Exception)((Object)ace));
                }
            }
        }
    }

    private class DeleteMessageBatchTask
    extends OutboundBatchTask<DeleteMessageRequest, DeleteMessageResponse> {
        private DeleteMessageBatchTask() {
        }

        @Override
        protected void process(List<DeleteMessageRequest> requests, List<QueueBufferFuture<DeleteMessageRequest, DeleteMessageResponse>> futures) {
            int index;
            if (requests.isEmpty()) {
                return;
            }
            DeleteMessageBatchRequest.Builder batchRequestBuilder = DeleteMessageBatchRequest.builder().queueUrl(SendQueueBuffer.this.qUrl);
            ArrayList<DeleteMessageBatchRequestEntry> entries = new ArrayList<DeleteMessageBatchRequestEntry>(requests.size());
            int n = requests.size();
            for (int i = 0; i < n; ++i) {
                entries.add((DeleteMessageBatchRequestEntry)DeleteMessageBatchRequestEntry.builder().id(Integer.toString(i)).receiptHandle(requests.get(i).receiptHandle()).build());
            }
            DeleteMessageBatchRequest batchRequest = (DeleteMessageBatchRequest)((Object)batchRequestBuilder.entries(entries).build());
            ResultConverter.appendUserAgent(batchRequest, SqsBufferedAsyncClient.USER_AGENT);
            DeleteMessageBatchResponse batchResult = SendQueueBuffer.this.sqsClient.deleteMessageBatch(batchRequest).join();
            for (DeleteMessageBatchResultEntry entry : batchResult.successful()) {
                index = Integer.parseInt(entry.id());
                futures.get(index).setSuccess(null);
            }
            for (BatchResultErrorEntry errorEntry : batchResult.failed()) {
                index = Integer.parseInt(errorEntry.id());
                if (errorEntry.senderFault().booleanValue()) {
                    futures.get(index).setFailure(ResultConverter.convert(errorEntry));
                    continue;
                }
                try {
                    SendQueueBuffer.this.sqsClient.deleteMessage(requests.get(index));
                    futures.get(index).setSuccess(null);
                }
                catch (AmazonClientException ace) {
                    futures.get(index).setFailure((Exception)((Object)ace));
                }
            }
        }
    }

    private class SendMessageBatchTask
    extends OutboundBatchTask<SendMessageRequest, SendMessageResponse> {
        int batchSizeBytes;

        private SendMessageBatchTask() {
            this.batchSizeBytes = 0;
        }

        @Override
        protected boolean isOkToAdd(SendMessageRequest request) {
            return this.requests.size() < SendQueueBuffer.this.config.getMaxBatchSize() && (long)(request.messageBody().getBytes().length + this.batchSizeBytes) < SendQueueBuffer.this.config.getMaxBatchSizeBytes();
        }

        @Override
        protected void onRequestAdded(SendMessageRequest request) {
            this.batchSizeBytes += request.messageBody().getBytes().length;
        }

        @Override
        protected boolean isFull() {
            return this.requests.size() >= SendQueueBuffer.this.config.getMaxBatchSize() || (long)this.batchSizeBytes >= SendQueueBuffer.this.config.getMaxBatchSizeBytes();
        }

        @Override
        protected void process(List<SendMessageRequest> requests, List<QueueBufferFuture<SendMessageRequest, SendMessageResponse>> futures) {
            int index;
            if (requests.isEmpty()) {
                return;
            }
            SendMessageBatchRequest.Builder batchRequestBuilder = SendMessageBatchRequest.builder().queueUrl(SendQueueBuffer.this.qUrl);
            ArrayList<SendMessageBatchRequestEntry> entries = new ArrayList<SendMessageBatchRequestEntry>(requests.size());
            int n = requests.size();
            for (int i = 0; i < n; ++i) {
                entries.add((SendMessageBatchRequestEntry)SendMessageBatchRequestEntry.builder().id(Integer.toString(i)).messageBody(requests.get(i).messageBody()).delaySeconds(requests.get(i).delaySeconds()).messageAttributes(requests.get(i).messageAttributes()).build());
            }
            SendMessageBatchRequest batchRequest = (SendMessageBatchRequest)((Object)batchRequestBuilder.entries(entries).build());
            ResultConverter.appendUserAgent(batchRequest, SqsBufferedAsyncClient.USER_AGENT);
            SendMessageBatchResponse batchResult = SendQueueBuffer.this.sqsClient.sendMessageBatch(batchRequest).join();
            for (SendMessageBatchResultEntry entry : batchResult.successful()) {
                index = Integer.parseInt(entry.id());
                futures.get(index).setSuccess(ResultConverter.convert(entry));
            }
            for (BatchResultErrorEntry errorEntry : batchResult.failed()) {
                index = Integer.parseInt(errorEntry.id());
                if (errorEntry.senderFault().booleanValue()) {
                    futures.get(index).setFailure(ResultConverter.convert(errorEntry));
                    continue;
                }
                try {
                    futures.get(index).setSuccess(SendQueueBuffer.this.sqsClient.sendMessage(requests.get(index)).join());
                }
                catch (AmazonClientException ace) {
                    futures.get(index).setFailure((Exception)((Object)ace));
                }
            }
        }
    }

    private abstract class OutboundBatchTask<R extends AmazonWebServiceRequest, ResultT>
    implements Runnable {
        protected final List<R> requests;
        protected final ArrayList<QueueBufferFuture<R, ResultT>> futures;
        private boolean closed;
        private volatile Listener<OutboundBatchTask<R, ResultT>> onCompleted;

        public OutboundBatchTask() {
            this.requests = new ArrayList<R>(SendQueueBuffer.this.config.getMaxBatchSize());
            this.futures = new ArrayList(SendQueueBuffer.this.config.getMaxBatchSize());
        }

        public void setOnCompleted(Listener<OutboundBatchTask<R, ResultT>> value) {
            this.onCompleted = value;
        }

        public synchronized QueueBufferFuture<R, ResultT> addRequest(R request, QueueBufferCallback<R, ResultT> callback) {
            if (this.closed) {
                return null;
            }
            QueueBufferFuture<R, ResultT> theFuture = this.addIfAllowed(request, callback);
            if (null == theFuture || this.isFull()) {
                this.closed = true;
                this.notify();
            }
            return theFuture;
        }

        private QueueBufferFuture<R, ResultT> addIfAllowed(R request, QueueBufferCallback<R, ResultT> callback) {
            if (this.isOkToAdd(request)) {
                this.requests.add(request);
                QueueBufferFuture<R, ResultT> theFuture = new QueueBufferFuture<R, ResultT>(callback);
                this.futures.add(theFuture);
                this.onRequestAdded(request);
                return theFuture;
            }
            return null;
        }

        protected boolean isOkToAdd(R request) {
            return this.requests.size() < SendQueueBuffer.this.config.getMaxBatchSize();
        }

        protected void onRequestAdded(R request) {
        }

        protected boolean isFull() {
            return this.requests.size() >= SendQueueBuffer.this.config.getMaxBatchSize();
        }

        protected abstract void process(List<R> var1, List<QueueBufferFuture<R, ResultT>> var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                ArrayList<QueueBufferFuture<R, ResultT>> futures;
                ArrayList<R> requests;
                long deadlineMs = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS) + SendQueueBuffer.this.config.getMaxBatchOpenMs() + 1L;
                long t = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
                OutboundBatchTask outboundBatchTask = this;
                synchronized (outboundBatchTask) {
                    while (!this.closed && t < deadlineMs) {
                        t = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
                        long toWait = Math.max(1L, deadlineMs - t);
                        this.wait(toWait);
                    }
                    this.closed = true;
                    requests = new ArrayList<R>(this.requests);
                    futures = new ArrayList<QueueBufferFuture<R, ResultT>>(this.futures);
                }
                this.process(requests, futures);
            }
            catch (InterruptedException e) {
                this.failAll(e);
            }
            catch (AmazonClientException e) {
                this.failAll((Exception)((Object)e));
            }
            catch (RuntimeException e) {
                this.failAll(e);
                throw e;
            }
            catch (Error e) {
                this.failAll((Exception)((Object)new AmazonClientException("Error encountered", (Throwable)e)));
                throw e;
            }
            finally {
                Listener<OutboundBatchTask<R, ResultT>> listener = this.onCompleted;
                if (listener != null) {
                    listener.invoke(this);
                }
            }
        }

        private void failAll(Exception e) {
            for (QueueBufferFuture<R, ResultT> f : this.futures) {
                f.setFailure(e);
            }
        }
    }

    private static interface Listener<T> {
        public void invoke(T var1);
    }
}

