/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.sqs.model.AttributeNameListCopier;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetQueueAttributesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetQueueAttributesRequest> {
    private final String queueUrl;
    private final List<String> attributeNames;

    private GetQueueAttributesRequest(BuilderImpl builder) {
        this.queueUrl = builder.queueUrl;
        this.attributeNames = builder.attributeNames;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public List<String> attributeNames() {
        return this.attributeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.queueUrl() == null ? 0 : this.queueUrl().hashCode());
        hashCode = 31 * hashCode + (this.attributeNames() == null ? 0 : this.attributeNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueueAttributesRequest)) {
            return false;
        }
        GetQueueAttributesRequest other = (GetQueueAttributesRequest)((Object)obj);
        if (other.queueUrl() == null ^ this.queueUrl() == null) {
            return false;
        }
        if (other.queueUrl() != null && !other.queueUrl().equals(this.queueUrl())) {
            return false;
        }
        if (other.attributeNames() == null ^ this.attributeNames() == null) {
            return false;
        }
        return other.attributeNames() == null || other.attributeNames().equals(this.attributeNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.queueUrl() != null) {
            sb.append("QueueUrl: ").append(this.queueUrl()).append(",");
        }
        if (this.attributeNames() != null) {
            sb.append("AttributeNames: ").append(this.attributeNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String queueUrl;
        private List<String> attributeNames = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueueAttributesRequest model) {
            this.setQueueUrl(model.queueUrl);
            this.setAttributeNames(model.attributeNames);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Collection<String> getAttributeNames() {
            return this.attributeNames;
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            if (this.attributeNames == null) {
                this.attributeNames = new SdkInternalList(attributeNames.length);
            }
            for (String e : attributeNames) {
                this.attributeNames.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(QueueAttributeName ... attributeNames) {
            if (this.attributeNames == null) {
                this.attributeNames = new SdkInternalList(attributeNames.length);
            }
            for (QueueAttributeName ele : attributeNames) {
                this.attributeNames.add(ele.toString());
            }
            return this;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        @SafeVarargs
        public final void setAttributeNames(String ... attributeNames) {
            if (this.attributeNames == null) {
                this.attributeNames = new SdkInternalList(attributeNames.length);
            }
            for (String e : attributeNames) {
                this.attributeNames.add(e);
            }
        }

        @SafeVarargs
        public final void setAttributeNames(QueueAttributeName ... attributeNames) {
            if (this.attributeNames == null) {
                this.attributeNames = new SdkInternalList(attributeNames.length);
            }
            for (QueueAttributeName ele : attributeNames) {
                this.attributeNames.add(ele.toString());
            }
        }

        public GetQueueAttributesRequest build() {
            return new GetQueueAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetQueueAttributesRequest> {
        public Builder queueUrl(String var1);

        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);

        public Builder attributeNames(QueueAttributeName ... var1);
    }
}

