/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.sqs.model.QueueUrlListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListQueuesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListQueuesResponse> {
    private final List<String> queueUrls;

    private ListQueuesResponse(BuilderImpl builder) {
        this.queueUrls = builder.queueUrls;
    }

    public List<String> queueUrls() {
        return this.queueUrls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.queueUrls() == null ? 0 : this.queueUrls().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuesResponse)) {
            return false;
        }
        ListQueuesResponse other = (ListQueuesResponse)((Object)obj);
        if (other.queueUrls() == null ^ this.queueUrls() == null) {
            return false;
        }
        return other.queueUrls() == null || other.queueUrls().equals(this.queueUrls());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.queueUrls() != null) {
            sb.append("QueueUrls: ").append(this.queueUrls()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> queueUrls = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueuesResponse model) {
            this.setQueueUrls(model.queueUrls);
        }

        public final Collection<String> getQueueUrls() {
            return this.queueUrls;
        }

        @Override
        public final Builder queueUrls(Collection<String> queueUrls) {
            this.queueUrls = QueueUrlListCopier.copy(queueUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueUrls(String ... queueUrls) {
            if (this.queueUrls == null) {
                this.queueUrls = new SdkInternalList(queueUrls.length);
            }
            for (String e : queueUrls) {
                this.queueUrls.add(e);
            }
            return this;
        }

        public final void setQueueUrls(Collection<String> queueUrls) {
            this.queueUrls = QueueUrlListCopier.copy(queueUrls);
        }

        @SafeVarargs
        public final void setQueueUrls(String ... queueUrls) {
            if (this.queueUrls == null) {
                this.queueUrls = new SdkInternalList(queueUrls.length);
            }
            for (String e : queueUrls) {
                this.queueUrls.add(e);
            }
        }

        public ListQueuesResponse build() {
            return new ListQueuesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListQueuesResponse> {
        public Builder queueUrls(Collection<String> var1);

        public Builder queueUrls(String ... var1);
    }
}

