/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ChangeMessageVisibilityRequest extends SQSRequest implements
        ToCopyableBuilder<ChangeMessageVisibilityRequest.Builder, ChangeMessageVisibilityRequest> {
    private final String queueUrl;

    private final String receiptHandle;

    private final Integer visibilityTimeout;

    private ChangeMessageVisibilityRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.receiptHandle = builder.receiptHandle;
        this.visibilityTimeout = builder.visibilityTimeout;
    }

    /**
     * <p>
     * The URL of the Amazon SQS queue whose message's visibility is changed.
     * </p>
     * <p>
     * Queue URLs are case-sensitive.
     * </p>
     * 
     * @return The URL of the Amazon SQS queue whose message's visibility is changed.</p>
     *         <p>
     *         Queue URLs are case-sensitive.
     */
    public String queueUrl() {
        return queueUrl;
    }

    /**
     * <p>
     * The receipt handle associated with the message whose visibility timeout is changed. This parameter is returned by
     * the <code> <a>ReceiveMessage</a> </code> action.
     * </p>
     * 
     * @return The receipt handle associated with the message whose visibility timeout is changed. This parameter is
     *         returned by the <code> <a>ReceiveMessage</a> </code> action.
     */
    public String receiptHandle() {
        return receiptHandle;
    }

    /**
     * <p>
     * The new value for the message's visibility timeout (in seconds). Values values: <code>0</code> to
     * <code>43200</code>. Maximum: 12 hours.
     * </p>
     * 
     * @return The new value for the message's visibility timeout (in seconds). Values values: <code>0</code> to
     *         <code>43200</code>. Maximum: 12 hours.
     */
    public Integer visibilityTimeout() {
        return visibilityTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(receiptHandle());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityTimeout());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeMessageVisibilityRequest)) {
            return false;
        }
        ChangeMessageVisibilityRequest other = (ChangeMessageVisibilityRequest) obj;
        return Objects.equals(queueUrl(), other.queueUrl()) && Objects.equals(receiptHandle(), other.receiptHandle())
                && Objects.equals(visibilityTimeout(), other.visibilityTimeout());
    }

    @Override
    public String toString() {
        return ToString.builder("ChangeMessageVisibilityRequest").add("QueueUrl", queueUrl())
                .add("ReceiptHandle", receiptHandle()).add("VisibilityTimeout", visibilityTimeout()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueUrl":
            return Optional.of(clazz.cast(queueUrl()));
        case "ReceiptHandle":
            return Optional.of(clazz.cast(receiptHandle()));
        case "VisibilityTimeout":
            return Optional.of(clazz.cast(visibilityTimeout()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SQSRequest.Builder, CopyableBuilder<Builder, ChangeMessageVisibilityRequest> {
        /**
         * <p>
         * The URL of the Amazon SQS queue whose message's visibility is changed.
         * </p>
         * <p>
         * Queue URLs are case-sensitive.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the Amazon SQS queue whose message's visibility is changed.</p>
         *        <p>
         *        Queue URLs are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * The receipt handle associated with the message whose visibility timeout is changed. This parameter is
         * returned by the <code> <a>ReceiveMessage</a> </code> action.
         * </p>
         * 
         * @param receiptHandle
         *        The receipt handle associated with the message whose visibility timeout is changed. This parameter is
         *        returned by the <code> <a>ReceiveMessage</a> </code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiptHandle(String receiptHandle);

        /**
         * <p>
         * The new value for the message's visibility timeout (in seconds). Values values: <code>0</code> to
         * <code>43200</code>. Maximum: 12 hours.
         * </p>
         * 
         * @param visibilityTimeout
         *        The new value for the message's visibility timeout (in seconds). Values values: <code>0</code> to
         *        <code>43200</code>. Maximum: 12 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibilityTimeout(Integer visibilityTimeout);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SQSRequest.BuilderImpl implements Builder {
        private String queueUrl;

        private String receiptHandle;

        private Integer visibilityTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeMessageVisibilityRequest model) {
            super(model);
            queueUrl(model.queueUrl);
            receiptHandle(model.receiptHandle);
            visibilityTimeout(model.visibilityTimeout);
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final String getReceiptHandle() {
            return receiptHandle;
        }

        @Override
        public final Builder receiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
            return this;
        }

        public final void setReceiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
        }

        public final Integer getVisibilityTimeout() {
            return visibilityTimeout;
        }

        @Override
        public final Builder visibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        public final void setVisibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ChangeMessageVisibilityRequest build() {
            return new ChangeMessageVisibilityRequest(this);
        }
    }
}
