/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of your dead letter source queues.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDeadLetterSourceQueuesResponse extends SQSResponse implements
        ToCopyableBuilder<ListDeadLetterSourceQueuesResponse.Builder, ListDeadLetterSourceQueuesResponse> {
    private final List<String> queueUrls;

    private ListDeadLetterSourceQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.queueUrls = builder.queueUrls;
    }

    /**
     * <p>
     * A list of source queue URLs that have the <code>RedrivePolicy</code> queue attribute configured with a
     * dead-letter queue.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of source queue URLs that have the <code>RedrivePolicy</code> queue attribute configured with a
     *         dead-letter queue.
     */
    public List<String> queueUrls() {
        return queueUrls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueUrls());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeadLetterSourceQueuesResponse)) {
            return false;
        }
        ListDeadLetterSourceQueuesResponse other = (ListDeadLetterSourceQueuesResponse) obj;
        return Objects.equals(queueUrls(), other.queueUrls());
    }

    @Override
    public String toString() {
        return ToString.builder("ListDeadLetterSourceQueuesResponse").add("QueueUrls", queueUrls()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queueUrls":
            return Optional.of(clazz.cast(queueUrls()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SQSResponse.Builder, CopyableBuilder<Builder, ListDeadLetterSourceQueuesResponse> {
        /**
         * <p>
         * A list of source queue URLs that have the <code>RedrivePolicy</code> queue attribute configured with a
         * dead-letter queue.
         * </p>
         * 
         * @param queueUrls
         *        A list of source queue URLs that have the <code>RedrivePolicy</code> queue attribute configured with a
         *        dead-letter queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrls(Collection<String> queueUrls);

        /**
         * <p>
         * A list of source queue URLs that have the <code>RedrivePolicy</code> queue attribute configured with a
         * dead-letter queue.
         * </p>
         * 
         * @param queueUrls
         *        A list of source queue URLs that have the <code>RedrivePolicy</code> queue attribute configured with a
         *        dead-letter queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrls(String... queueUrls);
    }

    static final class BuilderImpl extends SQSResponse.BuilderImpl implements Builder {
        private List<String> queueUrls;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeadLetterSourceQueuesResponse model) {
            super(model);
            queueUrls(model.queueUrls);
        }

        public final Collection<String> getQueueUrls() {
            return queueUrls;
        }

        @Override
        public final Builder queueUrls(Collection<String> queueUrls) {
            this.queueUrls = QueueUrlListCopier.copy(queueUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueUrls(String... queueUrls) {
            queueUrls(Arrays.asList(queueUrls));
            return this;
        }

        public final void setQueueUrls(Collection<String> queueUrls) {
            this.queueUrls = QueueUrlListCopier.copy(queueUrls);
        }

        @Override
        public ListDeadLetterSourceQueuesResponse build() {
            return new ListDeadLetterSourceQueuesResponse(this);
        }
    }
}
