/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListQueuesRequest extends SQSRequest implements ToCopyableBuilder<ListQueuesRequest.Builder, ListQueuesRequest> {
    private final String queueNamePrefix;

    private ListQueuesRequest(BuilderImpl builder) {
        super(builder);
        this.queueNamePrefix = builder.queueNamePrefix;
    }

    /**
     * <p>
     * A string to use for filtering the list results. Only those queues whose name begins with the specified string are
     * returned.
     * </p>
     * <p>
     * Queue names are case-sensitive.
     * </p>
     * 
     * @return A string to use for filtering the list results. Only those queues whose name begins with the specified
     *         string are returned.</p>
     *         <p>
     *         Queue names are case-sensitive.
     */
    public String queueNamePrefix() {
        return queueNamePrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueNamePrefix());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuesRequest)) {
            return false;
        }
        ListQueuesRequest other = (ListQueuesRequest) obj;
        return Objects.equals(queueNamePrefix(), other.queueNamePrefix());
    }

    @Override
    public String toString() {
        return ToString.builder("ListQueuesRequest").add("QueueNamePrefix", queueNamePrefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueNamePrefix":
            return Optional.of(clazz.cast(queueNamePrefix()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SQSRequest.Builder, CopyableBuilder<Builder, ListQueuesRequest> {
        /**
         * <p>
         * A string to use for filtering the list results. Only those queues whose name begins with the specified string
         * are returned.
         * </p>
         * <p>
         * Queue names are case-sensitive.
         * </p>
         * 
         * @param queueNamePrefix
         *        A string to use for filtering the list results. Only those queues whose name begins with the specified
         *        string are returned.</p>
         *        <p>
         *        Queue names are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueNamePrefix(String queueNamePrefix);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SQSRequest.BuilderImpl implements Builder {
        private String queueNamePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueuesRequest model) {
            super(model);
            queueNamePrefix(model.queueNamePrefix);
        }

        public final String getQueueNamePrefix() {
            return queueNamePrefix;
        }

        @Override
        public final Builder queueNamePrefix(String queueNamePrefix) {
            this.queueNamePrefix = queueNamePrefix;
            return this;
        }

        public final void setQueueNamePrefix(String queueNamePrefix) {
            this.queueNamePrefix = queueNamePrefix;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListQueuesRequest build() {
            return new ListQueuesRequest(this);
        }
    }
}
