/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class RemovePermissionRequest extends SQSRequest implements
        ToCopyableBuilder<RemovePermissionRequest.Builder, RemovePermissionRequest> {
    private final String queueUrl;

    private final String label;

    private RemovePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.label = builder.label;
    }

    /**
     * <p>
     * The URL of the Amazon SQS queue from which permissions are removed.
     * </p>
     * <p>
     * Queue URLs are case-sensitive.
     * </p>
     * 
     * @return The URL of the Amazon SQS queue from which permissions are removed.</p>
     *         <p>
     *         Queue URLs are case-sensitive.
     */
    public String queueUrl() {
        return queueUrl;
    }

    /**
     * <p>
     * The identification of the permission to remove. This is the label added using the
     * <code> <a>AddPermission</a> </code> action.
     * </p>
     * 
     * @return The identification of the permission to remove. This is the label added using the
     *         <code> <a>AddPermission</a> </code> action.
     */
    public String label() {
        return label;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemovePermissionRequest)) {
            return false;
        }
        RemovePermissionRequest other = (RemovePermissionRequest) obj;
        return Objects.equals(queueUrl(), other.queueUrl()) && Objects.equals(label(), other.label());
    }

    @Override
    public String toString() {
        return ToString.builder("RemovePermissionRequest").add("QueueUrl", queueUrl()).add("Label", label()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueUrl":
            return Optional.of(clazz.cast(queueUrl()));
        case "Label":
            return Optional.of(clazz.cast(label()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SQSRequest.Builder, CopyableBuilder<Builder, RemovePermissionRequest> {
        /**
         * <p>
         * The URL of the Amazon SQS queue from which permissions are removed.
         * </p>
         * <p>
         * Queue URLs are case-sensitive.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the Amazon SQS queue from which permissions are removed.</p>
         *        <p>
         *        Queue URLs are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * The identification of the permission to remove. This is the label added using the
         * <code> <a>AddPermission</a> </code> action.
         * </p>
         * 
         * @param label
         *        The identification of the permission to remove. This is the label added using the
         *        <code> <a>AddPermission</a> </code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SQSRequest.BuilderImpl implements Builder {
        private String queueUrl;

        private String label;

        private BuilderImpl() {
        }

        private BuilderImpl(RemovePermissionRequest model) {
            super(model);
            queueUrl(model.queueUrl);
            label(model.label);
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final String getLabel() {
            return label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RemovePermissionRequest build() {
            return new RemovePermissionRequest(this);
        }
    }
}
