/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class SendMessageBatchRequest extends SQSRequest implements
        ToCopyableBuilder<SendMessageBatchRequest.Builder, SendMessageBatchRequest> {
    private final String queueUrl;

    private final List<SendMessageBatchRequestEntry> entries;

    private SendMessageBatchRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.entries = builder.entries;
    }

    /**
     * <p>
     * The URL of the Amazon SQS queue to which batched messages are sent.
     * </p>
     * <p>
     * Queue URLs are case-sensitive.
     * </p>
     * 
     * @return The URL of the Amazon SQS queue to which batched messages are sent.</p>
     *         <p>
     *         Queue URLs are case-sensitive.
     */
    public String queueUrl() {
        return queueUrl;
    }

    /**
     * <p>
     * A list of <code> <a>SendMessageBatchRequestEntry</a> </code> items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code> <a>SendMessageBatchRequestEntry</a> </code> items.
     */
    public List<SendMessageBatchRequestEntry> entries() {
        return entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(entries());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageBatchRequest)) {
            return false;
        }
        SendMessageBatchRequest other = (SendMessageBatchRequest) obj;
        return Objects.equals(queueUrl(), other.queueUrl()) && Objects.equals(entries(), other.entries());
    }

    @Override
    public String toString() {
        return ToString.builder("SendMessageBatchRequest").add("QueueUrl", queueUrl()).add("Entries", entries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueUrl":
            return Optional.of(clazz.cast(queueUrl()));
        case "Entries":
            return Optional.of(clazz.cast(entries()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SQSRequest.Builder, CopyableBuilder<Builder, SendMessageBatchRequest> {
        /**
         * <p>
         * The URL of the Amazon SQS queue to which batched messages are sent.
         * </p>
         * <p>
         * Queue URLs are case-sensitive.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the Amazon SQS queue to which batched messages are sent.</p>
         *        <p>
         *        Queue URLs are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * A list of <code> <a>SendMessageBatchRequestEntry</a> </code> items.
         * </p>
         * 
         * @param entries
         *        A list of <code> <a>SendMessageBatchRequestEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<SendMessageBatchRequestEntry> entries);

        /**
         * <p>
         * A list of <code> <a>SendMessageBatchRequestEntry</a> </code> items.
         * </p>
         * 
         * @param entries
         *        A list of <code> <a>SendMessageBatchRequestEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(SendMessageBatchRequestEntry... entries);

        /**
         * <p>
         * A list of <code> <a>SendMessageBatchRequestEntry</a> </code> items.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SendMessageBatchRequestEntry>.Builder}
         * avoiding the need to create one manually via {@link List<SendMessageBatchRequestEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SendMessageBatchRequestEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #entries(List<SendMessageBatchRequestEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on {@link List<SendMessageBatchRequestEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(List<SendMessageBatchRequestEntry>)
         */
        Builder entries(Consumer<SendMessageBatchRequestEntry.Builder>... entries);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SQSRequest.BuilderImpl implements Builder {
        private String queueUrl;

        private List<SendMessageBatchRequestEntry> entries;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageBatchRequest model) {
            super(model);
            queueUrl(model.queueUrl);
            entries(model.entries);
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Collection<SendMessageBatchRequestEntry.Builder> getEntries() {
            return entries != null ? entries.stream().map(SendMessageBatchRequestEntry::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder entries(Collection<SendMessageBatchRequestEntry> entries) {
            this.entries = SendMessageBatchRequestEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(SendMessageBatchRequestEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<SendMessageBatchRequestEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> SendMessageBatchRequestEntry.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntries(Collection<SendMessageBatchRequestEntry.BuilderImpl> entries) {
            this.entries = SendMessageBatchRequestEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SendMessageBatchRequest build() {
            return new SendMessageBatchRequest(this);
        }
    }
}
