/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For each message in the batch, the response contains a <code> <a>SendMessageBatchResultEntry</a> </code> tag if the
 * message succeeds or a <code> <a>BatchResultErrorEntry</a> </code> tag if the message fails.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SendMessageBatchResponse extends SQSResponse implements
        ToCopyableBuilder<SendMessageBatchResponse.Builder, SendMessageBatchResponse> {
    private final List<SendMessageBatchResultEntry> successful;

    private final List<BatchResultErrorEntry> failed;

    private SendMessageBatchResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    /**
     * <p>
     * A list of <code> <a>SendMessageBatchResultEntry</a> </code> items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code> <a>SendMessageBatchResultEntry</a> </code> items.
     */
    public List<SendMessageBatchResultEntry> successful() {
        return successful;
    }

    /**
     * <p>
     * A list of <code> <a>BatchResultErrorEntry</a> </code> items with error details about each message that can't be
     * enqueued.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code> <a>BatchResultErrorEntry</a> </code> items with error details about each message that
     *         can't be enqueued.
     */
    public List<BatchResultErrorEntry> failed() {
        return failed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(successful());
        hashCode = 31 * hashCode + Objects.hashCode(failed());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageBatchResponse)) {
            return false;
        }
        SendMessageBatchResponse other = (SendMessageBatchResponse) obj;
        return Objects.equals(successful(), other.successful()) && Objects.equals(failed(), other.failed());
    }

    @Override
    public String toString() {
        return ToString.builder("SendMessageBatchResponse").add("Successful", successful()).add("Failed", failed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Successful":
            return Optional.of(clazz.cast(successful()));
        case "Failed":
            return Optional.of(clazz.cast(failed()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SQSResponse.Builder, CopyableBuilder<Builder, SendMessageBatchResponse> {
        /**
         * <p>
         * A list of <code> <a>SendMessageBatchResultEntry</a> </code> items.
         * </p>
         * 
         * @param successful
         *        A list of <code> <a>SendMessageBatchResultEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Collection<SendMessageBatchResultEntry> successful);

        /**
         * <p>
         * A list of <code> <a>SendMessageBatchResultEntry</a> </code> items.
         * </p>
         * 
         * @param successful
         *        A list of <code> <a>SendMessageBatchResultEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(SendMessageBatchResultEntry... successful);

        /**
         * <p>
         * A list of <code> <a>SendMessageBatchResultEntry</a> </code> items.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SendMessageBatchResultEntry>.Builder}
         * avoiding the need to create one manually via {@link List<SendMessageBatchResultEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SendMessageBatchResultEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #successful(List<SendMessageBatchResultEntry>)}.
         * 
         * @param successful
         *        a consumer that will call methods on {@link List<SendMessageBatchResultEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successful(List<SendMessageBatchResultEntry>)
         */
        Builder successful(Consumer<SendMessageBatchResultEntry.Builder>... successful);

        /**
         * <p>
         * A list of <code> <a>BatchResultErrorEntry</a> </code> items with error details about each message that can't
         * be enqueued.
         * </p>
         * 
         * @param failed
         *        A list of <code> <a>BatchResultErrorEntry</a> </code> items with error details about each message that
         *        can't be enqueued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Collection<BatchResultErrorEntry> failed);

        /**
         * <p>
         * A list of <code> <a>BatchResultErrorEntry</a> </code> items with error details about each message that can't
         * be enqueued.
         * </p>
         * 
         * @param failed
         *        A list of <code> <a>BatchResultErrorEntry</a> </code> items with error details about each message that
         *        can't be enqueued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(BatchResultErrorEntry... failed);

        /**
         * <p>
         * A list of <code> <a>BatchResultErrorEntry</a> </code> items with error details about each message that can't
         * be enqueued.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchResultErrorEntry>.Builder} avoiding
         * the need to create one manually via {@link List<BatchResultErrorEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchResultErrorEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #failed(List<BatchResultErrorEntry>)}.
         * 
         * @param failed
         *        a consumer that will call methods on {@link List<BatchResultErrorEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failed(List<BatchResultErrorEntry>)
         */
        Builder failed(Consumer<BatchResultErrorEntry.Builder>... failed);
    }

    static final class BuilderImpl extends SQSResponse.BuilderImpl implements Builder {
        private List<SendMessageBatchResultEntry> successful;

        private List<BatchResultErrorEntry> failed;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageBatchResponse model) {
            super(model);
            successful(model.successful);
            failed(model.failed);
        }

        public final Collection<SendMessageBatchResultEntry.Builder> getSuccessful() {
            return successful != null ? successful.stream().map(SendMessageBatchResultEntry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successful(Collection<SendMessageBatchResultEntry> successful) {
            this.successful = SendMessageBatchResultEntryListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(SendMessageBatchResultEntry... successful) {
            successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<SendMessageBatchResultEntry.Builder>... successful) {
            successful(Stream.of(successful).map(c -> SendMessageBatchResultEntry.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessful(Collection<SendMessageBatchResultEntry.BuilderImpl> successful) {
            this.successful = SendMessageBatchResultEntryListCopier.copyFromBuilder(successful);
        }

        public final Collection<BatchResultErrorEntry.Builder> getFailed() {
            return failed != null ? failed.stream().map(BatchResultErrorEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failed(Collection<BatchResultErrorEntry> failed) {
            this.failed = BatchResultErrorEntryListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchResultErrorEntry... failed) {
            failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<BatchResultErrorEntry.Builder>... failed) {
            failed(Stream.of(failed).map(c -> BatchResultErrorEntry.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailed(Collection<BatchResultErrorEntry.BuilderImpl> failed) {
            this.failed = BatchResultErrorEntryListCopier.copyFromBuilder(failed);
        }

        @Override
        public SendMessageBatchResponse build() {
            return new SendMessageBatchResponse(this);
        }
    }
}
