/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class TagQueueRequest extends SQSRequest implements ToCopyableBuilder<TagQueueRequest.Builder, TagQueueRequest> {
    private final String queueUrl;

    private final Map<String, String> tags;

    private TagQueueRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The URL of the queue.
     * </p>
     * 
     * @return The URL of the queue.
     */
    public String queueUrl() {
        return queueUrl;
    }

    /**
     * <p>
     * The list of tags to be added to the specified queue.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of tags to be added to the specified queue.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagQueueRequest)) {
            return false;
        }
        TagQueueRequest other = (TagQueueRequest) obj;
        return Objects.equals(queueUrl(), other.queueUrl()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("TagQueueRequest").add("QueueUrl", queueUrl()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueUrl":
            return Optional.of(clazz.cast(queueUrl()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SQSRequest.Builder, CopyableBuilder<Builder, TagQueueRequest> {
        /**
         * <p>
         * The URL of the queue.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * The list of tags to be added to the specified queue.
         * </p>
         * 
         * @param tags
         *        The list of tags to be added to the specified queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SQSRequest.BuilderImpl implements Builder {
        private String queueUrl;

        private Map<String, String> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(TagQueueRequest model) {
            super(model);
            queueUrl(model.queueUrl);
            tags(model.tags);
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public TagQueueRequest build() {
            return new TagQueueRequest(this);
        }
    }
}
