/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.sqs.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * AddPermissionRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AddPermissionRequestMarshaller implements Marshaller<Request<AddPermissionRequest>, AddPermissionRequest> {

    public Request<AddPermissionRequest> marshall(AddPermissionRequest addPermissionRequest) {

        if (addPermissionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<AddPermissionRequest> request = new DefaultRequest<AddPermissionRequest>(addPermissionRequest, "SQSClient");
        request.addParameter("Action", "AddPermission");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);

        if (addPermissionRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(addPermissionRequest.queueUrl()));
        }

        if (addPermissionRequest.label() != null) {
            request.addParameter("Label", StringUtils.fromString(addPermissionRequest.label()));
        }

        java.util.List<String> aWSAccountIdsList = addPermissionRequest.awsAccountIds();

        if (aWSAccountIdsList != null) {
            if (!aWSAccountIdsList.isEmpty()) {
                int aWSAccountIdsListIndex = 1;

                for (String aWSAccountIdsListValue : aWSAccountIdsList) {
                    if (aWSAccountIdsListValue != null) {
                        request.addParameter("AWSAccountId." + aWSAccountIdsListIndex,
                                StringUtils.fromString(aWSAccountIdsListValue));
                    }
                    aWSAccountIdsListIndex++;
                }
            } else {
                request.addParameter("AWSAccountId", "");
            }
        }

        java.util.List<String> actionsList = addPermissionRequest.actions();

        if (actionsList != null) {
            if (!actionsList.isEmpty()) {
                int actionsListIndex = 1;

                for (String actionsListValue : actionsList) {
                    if (actionsListValue != null) {
                        request.addParameter("ActionName." + actionsListIndex, StringUtils.fromString(actionsListValue));
                    }
                    actionsListIndex++;
                }
            } else {
                request.addParameter("ActionName", "");
            }
        }

        return request;
    }

}
