/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.sqs.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ListQueueTagsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListQueueTagsRequestMarshaller implements Marshaller<Request<ListQueueTagsRequest>, ListQueueTagsRequest> {

    public Request<ListQueueTagsRequest> marshall(ListQueueTagsRequest listQueueTagsRequest) {

        if (listQueueTagsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ListQueueTagsRequest> request = new DefaultRequest<ListQueueTagsRequest>(listQueueTagsRequest, "SQSClient");
        request.addParameter("Action", "ListQueueTags");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);

        if (listQueueTagsRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(listQueueTagsRequest.queueUrl()));
        }

        return request;
    }

}
