/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.sqs.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * ListQueuesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListQueuesResponseUnmarshaller implements Unmarshaller<ListQueuesResponse, StaxUnmarshallerContext> {

    public ListQueuesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListQueuesResponse.Builder listQueuesResponse = ListQueuesResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<String> queueUrls = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listQueuesResponse.queueUrls(queueUrls);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("QueueUrl", targetDepth)) {
                    if (queueUrls == null) {
                        queueUrls = new ArrayList<>();
                    }
                    queueUrls.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listQueuesResponse.queueUrls(queueUrls);
                    break;
                }
            }
        }
        return listQueuesResponse.build();
    }

    private static final ListQueuesResponseUnmarshaller INSTANCE = new ListQueuesResponseUnmarshaller();

    public static ListQueuesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
