/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.sqs.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ReceiveMessageRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ReceiveMessageRequestMarshaller implements Marshaller<Request<ReceiveMessageRequest>, ReceiveMessageRequest> {

    public Request<ReceiveMessageRequest> marshall(ReceiveMessageRequest receiveMessageRequest) {

        if (receiveMessageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ReceiveMessageRequest> request = new DefaultRequest<ReceiveMessageRequest>(receiveMessageRequest, "SQSClient");
        request.addParameter("Action", "ReceiveMessage");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);

        if (receiveMessageRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(receiveMessageRequest.queueUrl()));
        }

        java.util.List<String> attributeNamesList = receiveMessageRequest.attributeNamesAsStrings();

        if (attributeNamesList != null) {
            if (!attributeNamesList.isEmpty()) {
                int attributeNamesListIndex = 1;

                for (String attributeNamesListValue : attributeNamesList) {
                    if (attributeNamesListValue != null) {
                        request.addParameter("AttributeName." + attributeNamesListIndex,
                                StringUtils.fromString(attributeNamesListValue));
                    }
                    attributeNamesListIndex++;
                }
            } else {
                request.addParameter("AttributeName", "");
            }
        }

        java.util.List<String> messageAttributeNamesList = receiveMessageRequest.messageAttributeNames();

        if (messageAttributeNamesList != null) {
            if (!messageAttributeNamesList.isEmpty()) {
                int messageAttributeNamesListIndex = 1;

                for (String messageAttributeNamesListValue : messageAttributeNamesList) {
                    if (messageAttributeNamesListValue != null) {
                        request.addParameter("MessageAttributeName." + messageAttributeNamesListIndex,
                                StringUtils.fromString(messageAttributeNamesListValue));
                    }
                    messageAttributeNamesListIndex++;
                }
            } else {
                request.addParameter("MessageAttributeName", "");
            }
        }

        if (receiveMessageRequest.maxNumberOfMessages() != null) {
            request.addParameter("MaxNumberOfMessages", StringUtils.fromInteger(receiveMessageRequest.maxNumberOfMessages()));
        }

        if (receiveMessageRequest.visibilityTimeout() != null) {
            request.addParameter("VisibilityTimeout", StringUtils.fromInteger(receiveMessageRequest.visibilityTimeout()));
        }

        if (receiveMessageRequest.waitTimeSeconds() != null) {
            request.addParameter("WaitTimeSeconds", StringUtils.fromInteger(receiveMessageRequest.waitTimeSeconds()));
        }

        if (receiveMessageRequest.receiveRequestAttemptId() != null) {
            request.addParameter("ReceiveRequestAttemptId",
                    StringUtils.fromString(receiveMessageRequest.receiveRequestAttemptId()));
        }

        return request;
    }

}
