/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.sqs.model.AttributeNameListCopier;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.services.sqs.model.SQSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetQueueAttributesRequest
extends SQSRequest
implements ToCopyableBuilder<Builder, GetQueueAttributesRequest> {
    private final String queueUrl;
    private final List<String> attributeNames;

    private GetQueueAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.attributeNames = builder.attributeNames;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public List<QueueAttributeName> attributeNames() {
        return TypeConverter.convert(this.attributeNames, QueueAttributeName::fromValue);
    }

    public List<String> attributeNamesAsStrings() {
        return this.attributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeNamesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueueAttributesRequest)) {
            return false;
        }
        GetQueueAttributesRequest other = (GetQueueAttributesRequest)((Object)obj);
        return Objects.equals(this.queueUrl(), other.queueUrl()) && Objects.equals(this.attributeNamesAsStrings(), other.attributeNamesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"GetQueueAttributesRequest").add("QueueUrl", (Object)this.queueUrl()).add("AttributeNames", this.attributeNamesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueUrl": {
                return Optional.of(clazz.cast(this.queueUrl()));
            }
            case "AttributeNames": {
                return Optional.of(clazz.cast(this.attributeNamesAsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SQSRequest.BuilderImpl
    implements Builder {
        private String queueUrl;
        private List<String> attributeNames;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueueAttributesRequest model) {
            super(model);
            this.queueUrl(model.queueUrl);
            this.attributeNames(model.attributeNames);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Collection<String> getAttributeNames() {
            return this.attributeNames;
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetQueueAttributesRequest build() {
            return new GetQueueAttributesRequest(this);
        }
    }

    public static interface Builder
    extends SQSRequest.Builder,
    CopyableBuilder<Builder, GetQueueAttributesRequest> {
        public Builder queueUrl(String var1);

        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

