/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry;
import software.amazon.awssdk.services.sqs.model.BatchResultErrorEntryListCopier;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResultEntry;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResultEntryListCopier;
import software.amazon.awssdk.services.sqs.model.SqsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteMessageBatchResponse
extends SqsResponse
implements ToCopyableBuilder<Builder, DeleteMessageBatchResponse> {
    private final List<DeleteMessageBatchResultEntry> successful;
    private final List<BatchResultErrorEntry> failed;

    private DeleteMessageBatchResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    public List<DeleteMessageBatchResultEntry> successful() {
        return this.successful;
    }

    public List<BatchResultErrorEntry> failed() {
        return this.failed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.successful());
        hashCode = 31 * hashCode + Objects.hashCode(this.failed());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMessageBatchResponse)) {
            return false;
        }
        DeleteMessageBatchResponse other = (DeleteMessageBatchResponse)((Object)obj);
        return Objects.equals(this.successful(), other.successful()) && Objects.equals(this.failed(), other.failed());
    }

    public String toString() {
        return ToString.builder((String)"DeleteMessageBatchResponse").add("Successful", this.successful()).add("Failed", this.failed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Successful": {
                return Optional.ofNullable(clazz.cast(this.successful()));
            }
            case "Failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SqsResponse.BuilderImpl
    implements Builder {
        private List<DeleteMessageBatchResultEntry> successful = DefaultSdkAutoConstructList.getInstance();
        private List<BatchResultErrorEntry> failed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMessageBatchResponse model) {
            super(model);
            this.successful(model.successful);
            this.failed(model.failed);
        }

        public final Collection<DeleteMessageBatchResultEntry.Builder> getSuccessful() {
            return this.successful != null ? (Collection)this.successful.stream().map(DeleteMessageBatchResultEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successful(Collection<DeleteMessageBatchResultEntry> successful) {
            this.successful = DeleteMessageBatchResultEntryListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(DeleteMessageBatchResultEntry ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<DeleteMessageBatchResultEntry.Builder> ... successful) {
            this.successful(Stream.of(successful).map(c -> (DeleteMessageBatchResultEntry)((DeleteMessageBatchResultEntry.Builder)DeleteMessageBatchResultEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessful(Collection<DeleteMessageBatchResultEntry.BuilderImpl> successful) {
            this.successful = DeleteMessageBatchResultEntryListCopier.copyFromBuilder(successful);
        }

        public final Collection<BatchResultErrorEntry.Builder> getFailed() {
            return this.failed != null ? (Collection)this.failed.stream().map(BatchResultErrorEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failed(Collection<BatchResultErrorEntry> failed) {
            this.failed = BatchResultErrorEntryListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchResultErrorEntry ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<BatchResultErrorEntry.Builder> ... failed) {
            this.failed(Stream.of(failed).map(c -> (BatchResultErrorEntry)((BatchResultErrorEntry.Builder)BatchResultErrorEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailed(Collection<BatchResultErrorEntry.BuilderImpl> failed) {
            this.failed = BatchResultErrorEntryListCopier.copyFromBuilder(failed);
        }

        @Override
        public DeleteMessageBatchResponse build() {
            return new DeleteMessageBatchResponse(this);
        }
    }

    public static interface Builder
    extends SqsResponse.Builder,
    CopyableBuilder<Builder, DeleteMessageBatchResponse> {
        public Builder successful(Collection<DeleteMessageBatchResultEntry> var1);

        public Builder successful(DeleteMessageBatchResultEntry ... var1);

        public Builder successful(Consumer<DeleteMessageBatchResultEntry.Builder> ... var1);

        public Builder failed(Collection<BatchResultErrorEntry> var1);

        public Builder failed(BatchResultErrorEntry ... var1);

        public Builder failed(Consumer<BatchResultErrorEntry.Builder> ... var1);
    }
}

