/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;

public class ChangeMessageVisibilityRequestMarshaller
implements Marshaller<Request<ChangeMessageVisibilityRequest>, ChangeMessageVisibilityRequest> {
    public Request<ChangeMessageVisibilityRequest> marshall(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) {
        if (changeMessageVisibilityRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)changeMessageVisibilityRequest, "SqsClient");
        request.addParameter("Action", "ChangeMessageVisibility");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (changeMessageVisibilityRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringConversion.fromString((String)changeMessageVisibilityRequest.queueUrl()));
        }
        if (changeMessageVisibilityRequest.receiptHandle() != null) {
            request.addParameter("ReceiptHandle", StringConversion.fromString((String)changeMessageVisibilityRequest.receiptHandle()));
        }
        if (changeMessageVisibilityRequest.visibilityTimeout() != null) {
            request.addParameter("VisibilityTimeout", StringConversion.fromInteger((Integer)changeMessageVisibilityRequest.visibilityTimeout()));
        }
        return request;
    }
}

