/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;

public class ReceiveMessageRequestMarshaller
implements Marshaller<Request<ReceiveMessageRequest>, ReceiveMessageRequest> {
    public Request<ReceiveMessageRequest> marshall(ReceiveMessageRequest receiveMessageRequest) {
        if (receiveMessageRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)receiveMessageRequest, "SqsClient");
        request.addParameter("Action", "ReceiveMessage");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (receiveMessageRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringConversion.fromString((String)receiveMessageRequest.queueUrl()));
        }
        if (receiveMessageRequest.attributeNamesAsStrings().isEmpty() && !(receiveMessageRequest.attributeNamesAsStrings() instanceof SdkAutoConstructList)) {
            request.addParameter("AttributeName", "");
        } else if (!receiveMessageRequest.attributeNamesAsStrings().isEmpty() && !(receiveMessageRequest.attributeNamesAsStrings() instanceof SdkAutoConstructList)) {
            List<String> attributeNamesList = receiveMessageRequest.attributeNamesAsStrings();
            int attributeNamesListIndex = 1;
            for (String attributeNamesListValue : attributeNamesList) {
                if (attributeNamesListValue != null) {
                    request.addParameter("AttributeName." + attributeNamesListIndex, StringConversion.fromString((String)attributeNamesListValue));
                }
                ++attributeNamesListIndex;
            }
        }
        if (receiveMessageRequest.messageAttributeNames().isEmpty() && !(receiveMessageRequest.messageAttributeNames() instanceof SdkAutoConstructList)) {
            request.addParameter("MessageAttributeName", "");
        } else if (!receiveMessageRequest.messageAttributeNames().isEmpty() && !(receiveMessageRequest.messageAttributeNames() instanceof SdkAutoConstructList)) {
            List<String> messageAttributeNamesList = receiveMessageRequest.messageAttributeNames();
            int messageAttributeNamesListIndex = 1;
            for (String messageAttributeNamesListValue : messageAttributeNamesList) {
                if (messageAttributeNamesListValue != null) {
                    request.addParameter("MessageAttributeName." + messageAttributeNamesListIndex, StringConversion.fromString((String)messageAttributeNamesListValue));
                }
                ++messageAttributeNamesListIndex;
            }
        }
        if (receiveMessageRequest.maxNumberOfMessages() != null) {
            request.addParameter("MaxNumberOfMessages", StringConversion.fromInteger((Integer)receiveMessageRequest.maxNumberOfMessages()));
        }
        if (receiveMessageRequest.visibilityTimeout() != null) {
            request.addParameter("VisibilityTimeout", StringConversion.fromInteger((Integer)receiveMessageRequest.visibilityTimeout()));
        }
        if (receiveMessageRequest.waitTimeSeconds() != null) {
            request.addParameter("WaitTimeSeconds", StringConversion.fromInteger((Integer)receiveMessageRequest.waitTimeSeconds()));
        }
        if (receiveMessageRequest.receiveRequestAttemptId() != null) {
            request.addParameter("ReceiveRequestAttemptId", StringConversion.fromString((String)receiveMessageRequest.receiveRequestAttemptId()));
        }
        return request;
    }
}

