/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapEntry;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.transform.MessageAttributeValueUnmarshaller;

public class SendMessageBatchRequestEntryUnmarshaller
implements Unmarshaller<SendMessageBatchRequestEntry, StaxUnmarshallerContext> {
    private static final SendMessageBatchRequestEntryUnmarshaller INSTANCE = new SendMessageBatchRequestEntryUnmarshaller();

    public SendMessageBatchRequestEntry unmarshall(StaxUnmarshallerContext context) throws Exception {
        SendMessageBatchRequestEntry.Builder sendMessageBatchRequestEntry;
        block10: {
            sendMessageBatchRequestEntry = SendMessageBatchRequestEntry.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            HashMap<String, MessageAttributeValue> messageAttributes = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    sendMessageBatchRequestEntry.messageAttributes(messageAttributes);
                    break block10;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Id", targetDepth)) {
                        sendMessageBatchRequestEntry.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MessageBody", targetDepth)) {
                        sendMessageBatchRequestEntry.messageBody(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DelaySeconds", targetDepth)) {
                        sendMessageBatchRequestEntry.delaySeconds(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MessageAttribute", targetDepth)) {
                        if (messageAttributes == null) {
                            messageAttributes = new HashMap<String, MessageAttributeValue>();
                        }
                        Map.Entry<String, MessageAttributeValue> entry = MessageAttributesMapEntryUnmarshaller.getInstance().unmarshall(context);
                        messageAttributes.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    if (context.testExpression("MessageDeduplicationId", targetDepth)) {
                        sendMessageBatchRequestEntry.messageDeduplicationId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("MessageGroupId", targetDepth)) continue;
                    sendMessageBatchRequestEntry.messageGroupId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            sendMessageBatchRequestEntry.messageAttributes(messageAttributes);
        }
        return (SendMessageBatchRequestEntry)sendMessageBatchRequestEntry.build();
    }

    public static SendMessageBatchRequestEntryUnmarshaller getInstance() {
        return INSTANCE;
    }

    private static class MessageAttributesMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, MessageAttributeValue>, StaxUnmarshallerContext> {
        private static final MessageAttributesMapEntryUnmarshaller INSTANCE = new MessageAttributesMapEntryUnmarshaller();

        private MessageAttributesMapEntryUnmarshaller() {
        }

        public Map.Entry<String, MessageAttributeValue> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Name", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Value", targetDepth)) continue;
                    entry.setValue((Object)MessageAttributeValueUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static MessageAttributesMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }
    }
}

