/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sqs.model.UntagQueueRequest;

public class UntagQueueRequestMarshaller
implements Marshaller<Request<UntagQueueRequest>, UntagQueueRequest> {
    public Request<UntagQueueRequest> marshall(UntagQueueRequest untagQueueRequest) {
        if (untagQueueRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)untagQueueRequest, "SqsClient");
        request.addParameter("Action", "UntagQueue");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (untagQueueRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringConversion.fromString((String)untagQueueRequest.queueUrl()));
        }
        if (untagQueueRequest.tagKeys().isEmpty() && !(untagQueueRequest.tagKeys() instanceof SdkAutoConstructList)) {
            request.addParameter("TagKey", "");
        } else if (!untagQueueRequest.tagKeys().isEmpty() && !(untagQueueRequest.tagKeys() instanceof SdkAutoConstructList)) {
            List<String> tagKeysList = untagQueueRequest.tagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKey." + tagKeysListIndex, StringConversion.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        return request;
    }
}

