/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sqs.model.AddPermissionRequest;

public class AddPermissionRequestMarshaller
implements Marshaller<Request<AddPermissionRequest>, AddPermissionRequest> {
    public Request<AddPermissionRequest> marshall(AddPermissionRequest addPermissionRequest) {
        if (addPermissionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)addPermissionRequest, "SqsClient");
        request.addParameter("Action", "AddPermission");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (addPermissionRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringConversion.fromString((String)addPermissionRequest.queueUrl()));
        }
        if (addPermissionRequest.label() != null) {
            request.addParameter("Label", StringConversion.fromString((String)addPermissionRequest.label()));
        }
        if (addPermissionRequest.awsAccountIds().isEmpty() && !(addPermissionRequest.awsAccountIds() instanceof SdkAutoConstructList)) {
            request.addParameter("AWSAccountId", "");
        } else if (!addPermissionRequest.awsAccountIds().isEmpty() && !(addPermissionRequest.awsAccountIds() instanceof SdkAutoConstructList)) {
            List<String> aWSAccountIdsList = addPermissionRequest.awsAccountIds();
            int aWSAccountIdsListIndex = 1;
            for (String aWSAccountIdsListValue : aWSAccountIdsList) {
                if (aWSAccountIdsListValue != null) {
                    request.addParameter("AWSAccountId." + aWSAccountIdsListIndex, StringConversion.fromString((String)aWSAccountIdsListValue));
                }
                ++aWSAccountIdsListIndex;
            }
        }
        if (addPermissionRequest.actions().isEmpty() && !(addPermissionRequest.actions() instanceof SdkAutoConstructList)) {
            request.addParameter("ActionName", "");
        } else if (!addPermissionRequest.actions().isEmpty() && !(addPermissionRequest.actions() instanceof SdkAutoConstructList)) {
            List<String> actionsList = addPermissionRequest.actions();
            int actionsListIndex = 1;
            for (String actionsListValue : actionsList) {
                if (actionsListValue != null) {
                    request.addParameter("ActionName." + actionsListIndex, StringConversion.fromString((String)actionsListValue));
                }
                ++actionsListIndex;
            }
        }
        return request;
    }
}

