/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry;

public class DeleteMessageBatchRequestMarshaller
implements Marshaller<Request<DeleteMessageBatchRequest>, DeleteMessageBatchRequest> {
    public Request<DeleteMessageBatchRequest> marshall(DeleteMessageBatchRequest deleteMessageBatchRequest) {
        if (deleteMessageBatchRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteMessageBatchRequest, "SqsClient");
        request.addParameter("Action", "DeleteMessageBatch");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteMessageBatchRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringConversion.fromString((String)deleteMessageBatchRequest.queueUrl()));
        }
        if (deleteMessageBatchRequest.entries().isEmpty() && !(deleteMessageBatchRequest.entries() instanceof SdkAutoConstructList)) {
            request.addParameter("DeleteMessageBatchRequestEntry", "");
        } else if (!deleteMessageBatchRequest.entries().isEmpty() && !(deleteMessageBatchRequest.entries() instanceof SdkAutoConstructList)) {
            List<DeleteMessageBatchRequestEntry> entriesList = deleteMessageBatchRequest.entries();
            int entriesListIndex = 1;
            for (DeleteMessageBatchRequestEntry entriesListValue : entriesList) {
                if (entriesListValue.id() != null) {
                    request.addParameter("DeleteMessageBatchRequestEntry." + entriesListIndex + ".Id", StringConversion.fromString((String)entriesListValue.id()));
                }
                if (entriesListValue.receiptHandle() != null) {
                    request.addParameter("DeleteMessageBatchRequestEntry." + entriesListIndex + ".ReceiptHandle", StringConversion.fromString((String)entriesListValue.receiptHandle()));
                }
                ++entriesListIndex;
            }
        }
        return request;
    }
}

