/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest;

public class GetQueueAttributesRequestMarshaller
implements Marshaller<Request<GetQueueAttributesRequest>, GetQueueAttributesRequest> {
    public Request<GetQueueAttributesRequest> marshall(GetQueueAttributesRequest getQueueAttributesRequest) {
        if (getQueueAttributesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getQueueAttributesRequest, "SqsClient");
        request.addParameter("Action", "GetQueueAttributes");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (getQueueAttributesRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringConversion.fromString((String)getQueueAttributesRequest.queueUrl()));
        }
        if (getQueueAttributesRequest.attributeNamesAsStrings().isEmpty() && !(getQueueAttributesRequest.attributeNamesAsStrings() instanceof SdkAutoConstructList)) {
            request.addParameter("AttributeName", "");
        } else if (!getQueueAttributesRequest.attributeNamesAsStrings().isEmpty() && !(getQueueAttributesRequest.attributeNamesAsStrings() instanceof SdkAutoConstructList)) {
            List<String> attributeNamesList = getQueueAttributesRequest.attributeNamesAsStrings();
            int attributeNamesListIndex = 1;
            for (String attributeNamesListValue : attributeNamesList) {
                if (attributeNamesListValue != null) {
                    request.addParameter("AttributeName." + attributeNamesListIndex, StringConversion.fromString((String)attributeNamesListValue));
                }
                ++attributeNamesListIndex;
            }
        }
        return request;
    }
}

