/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;

public class SendMessageBatchRequestMarshaller
implements Marshaller<Request<SendMessageBatchRequest>, SendMessageBatchRequest> {
    public Request<SendMessageBatchRequest> marshall(SendMessageBatchRequest sendMessageBatchRequest) {
        if (sendMessageBatchRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)sendMessageBatchRequest, "SqsClient");
        request.addParameter("Action", "SendMessageBatch");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendMessageBatchRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringConversion.fromString((String)sendMessageBatchRequest.queueUrl()));
        }
        if (sendMessageBatchRequest.entries().isEmpty() && !(sendMessageBatchRequest.entries() instanceof SdkAutoConstructList)) {
            request.addParameter("SendMessageBatchRequestEntry", "");
        } else if (!sendMessageBatchRequest.entries().isEmpty() && !(sendMessageBatchRequest.entries() instanceof SdkAutoConstructList)) {
            List<SendMessageBatchRequestEntry> entriesList = sendMessageBatchRequest.entries();
            int entriesListIndex = 1;
            for (SendMessageBatchRequestEntry entriesListValue : entriesList) {
                Map<String, MessageAttributeValue> messageAttributes;
                if (entriesListValue.id() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".Id", StringConversion.fromString((String)entriesListValue.id()));
                }
                if (entriesListValue.messageBody() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageBody", StringConversion.fromString((String)entriesListValue.messageBody()));
                }
                if (entriesListValue.delaySeconds() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".DelaySeconds", StringConversion.fromInteger((Integer)entriesListValue.delaySeconds()));
                }
                if ((messageAttributes = entriesListValue.messageAttributes()) != null) {
                    int messageAttributesListIndex = 1;
                    for (Map.Entry<String, MessageAttributeValue> entry : messageAttributes.entrySet()) {
                        if (entry.getKey() != null) {
                            request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Name", StringConversion.fromString((String)entry.getKey()));
                        }
                        if (entry.getValue() != null) {
                            if (entry.getValue().stringValue() != null) {
                                request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.StringValue", StringConversion.fromString((String)entry.getValue().stringValue()));
                            }
                            if (entry.getValue().binaryValue() != null) {
                                request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.BinaryValue", StringConversion.fromSdkBytes((SdkBytes)entry.getValue().binaryValue()));
                            }
                            if (entry.getValue().stringListValues().isEmpty() && !(entry.getValue().stringListValues() instanceof SdkAutoConstructList)) {
                                request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.StringListValue", "");
                            } else if (!entry.getValue().stringListValues().isEmpty() && !(entry.getValue().stringListValues() instanceof SdkAutoConstructList)) {
                                List<String> stringListValuesList = entry.getValue().stringListValues();
                                int stringListValuesListIndex = 1;
                                for (String stringListValuesListValue : stringListValuesList) {
                                    if (stringListValuesListValue != null) {
                                        request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.StringListValue." + stringListValuesListIndex, StringConversion.fromString((String)stringListValuesListValue));
                                    }
                                    ++stringListValuesListIndex;
                                }
                            }
                            if (entry.getValue().binaryListValues().isEmpty() && !(entry.getValue().binaryListValues() instanceof SdkAutoConstructList)) {
                                request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.BinaryListValue", "");
                            } else if (!entry.getValue().binaryListValues().isEmpty() && !(entry.getValue().binaryListValues() instanceof SdkAutoConstructList)) {
                                List<SdkBytes> binaryListValuesList = entry.getValue().binaryListValues();
                                int binaryListValuesListIndex = 1;
                                for (SdkBytes binaryListValuesListValue : binaryListValuesList) {
                                    if (binaryListValuesListValue != null) {
                                        request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.BinaryListValue." + binaryListValuesListIndex, StringConversion.fromSdkBytes((SdkBytes)binaryListValuesListValue));
                                    }
                                    ++binaryListValuesListIndex;
                                }
                            }
                            if (entry.getValue().dataType() != null) {
                                request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.DataType", StringConversion.fromString((String)entry.getValue().dataType()));
                            }
                        }
                        ++messageAttributesListIndex;
                    }
                }
                if (entriesListValue.messageDeduplicationId() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageDeduplicationId", StringConversion.fromString((String)entriesListValue.messageDeduplicationId()));
                }
                if (entriesListValue.messageGroupId() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageGroupId", StringConversion.fromString((String)entriesListValue.messageGroupId()));
                }
                ++entriesListIndex;
            }
        }
        return request;
    }
}

