/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.internal;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.http.SdkHttpFullRequest;

public class SqsRequestHandler
extends RequestHandler {
    private static final Map<String, String> NONSTANDARD_ENDPOINT_MAP = new HashMap<String, String>();

    public SdkHttpFullRequest beforeRequest(SdkHttpFullRequest request) {
        URI endpoint = request.getEndpoint();
        if (NONSTANDARD_ENDPOINT_MAP.containsKey(endpoint.getHost())) {
            String newHost = NONSTANDARD_ENDPOINT_MAP.get(endpoint.getHost());
            String newEndpoint = endpoint.toString().replaceFirst(endpoint.getHost(), newHost);
            return (SdkHttpFullRequest)((SdkHttpFullRequest.Builder)request.toBuilder()).endpoint(URI.create(newEndpoint)).build();
        }
        return request;
    }

    static {
        NONSTANDARD_ENDPOINT_MAP.put("queue.amazonaws.com", "sqs.us-east-1.amazonaws.com");
        NONSTANDARD_ENDPOINT_MAP.put("us-west-1.queue.amazonaws.com", "sqs.us-west-1.amazonaws.com");
        NONSTANDARD_ENDPOINT_MAP.put("us-west-2.queue.amazonaws.com", "sqs.us-west-2.amazonaws.com");
        NONSTANDARD_ENDPOINT_MAP.put("eu-west-1.queue.amazonaws.com", "sqs.eu-west-1.amazonaws.com");
        NONSTANDARD_ENDPOINT_MAP.put("ap-southeast-1.queue.amazonaws.com", "sqs.ap-southeast-1.amazonaws.com");
        NONSTANDARD_ENDPOINT_MAP.put("ap-northeast-1.queue.amazonaws.com", "sqs.ap-northeast-1.amazonaws.com");
        NONSTANDARD_ENDPOINT_MAP.put("sa-east-1.queue.amazonaws.com", "sqs.sa-east-1.amazonaws.com");
        NONSTANDARD_ENDPOINT_MAP.put("us-gov-west-1.queue.amazonaws.com", "sqs.us-gov-west-1.amazonaws.com");
        NONSTANDARD_ENDPOINT_MAP.put("ap-southeast-2.queue.amazonaws.com", "sqs.ap-southeast-2.amazonaws.com");
    }
}

