/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.sqs.model.BinaryListCopier;
import software.amazon.awssdk.services.sqs.model.StringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MessageAttributeValue
implements ToCopyableBuilder<Builder, MessageAttributeValue> {
    private final String stringValue;
    private final ByteBuffer binaryValue;
    private final List<String> stringListValues;
    private final List<ByteBuffer> binaryListValues;
    private final String dataType;

    private MessageAttributeValue(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.binaryValue = builder.binaryValue;
        this.stringListValues = builder.stringListValues;
        this.binaryListValues = builder.binaryListValues;
        this.dataType = builder.dataType;
    }

    public String stringValue() {
        return this.stringValue;
    }

    public ByteBuffer binaryValue() {
        return this.binaryValue == null ? null : this.binaryValue.asReadOnlyBuffer();
    }

    public List<String> stringListValues() {
        return this.stringListValues;
    }

    public List<ByteBuffer> binaryListValues() {
        return this.binaryListValues;
    }

    public String dataType() {
        return this.dataType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stringValue() == null ? 0 : this.stringValue().hashCode());
        hashCode = 31 * hashCode + (this.binaryValue() == null ? 0 : this.binaryValue().hashCode());
        hashCode = 31 * hashCode + (this.stringListValues() == null ? 0 : this.stringListValues().hashCode());
        hashCode = 31 * hashCode + (this.binaryListValues() == null ? 0 : this.binaryListValues().hashCode());
        hashCode = 31 * hashCode + (this.dataType() == null ? 0 : this.dataType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageAttributeValue)) {
            return false;
        }
        MessageAttributeValue other = (MessageAttributeValue)obj;
        if (other.stringValue() == null ^ this.stringValue() == null) {
            return false;
        }
        if (other.stringValue() != null && !other.stringValue().equals(this.stringValue())) {
            return false;
        }
        if (other.binaryValue() == null ^ this.binaryValue() == null) {
            return false;
        }
        if (other.binaryValue() != null && !other.binaryValue().equals(this.binaryValue())) {
            return false;
        }
        if (other.stringListValues() == null ^ this.stringListValues() == null) {
            return false;
        }
        if (other.stringListValues() != null && !other.stringListValues().equals(this.stringListValues())) {
            return false;
        }
        if (other.binaryListValues() == null ^ this.binaryListValues() == null) {
            return false;
        }
        if (other.binaryListValues() != null && !other.binaryListValues().equals(this.binaryListValues())) {
            return false;
        }
        if (other.dataType() == null ^ this.dataType() == null) {
            return false;
        }
        return other.dataType() == null || other.dataType().equals(this.dataType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stringValue() != null) {
            sb.append("StringValue: ").append(this.stringValue()).append(",");
        }
        if (this.binaryValue() != null) {
            sb.append("BinaryValue: ").append(this.binaryValue()).append(",");
        }
        if (this.stringListValues() != null) {
            sb.append("StringListValues: ").append(this.stringListValues()).append(",");
        }
        if (this.binaryListValues() != null) {
            sb.append("BinaryListValues: ").append(this.binaryListValues()).append(",");
        }
        if (this.dataType() != null) {
            sb.append("DataType: ").append(this.dataType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String stringValue;
        private ByteBuffer binaryValue;
        private List<String> stringListValues;
        private List<ByteBuffer> binaryListValues;
        private String dataType;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageAttributeValue model) {
            this.setStringValue(model.stringValue);
            this.setBinaryValue(model.binaryValue);
            this.setStringListValues(model.stringListValues);
            this.setBinaryListValues(model.binaryListValues);
            this.setDataType(model.dataType);
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public final ByteBuffer getBinaryValue() {
            return this.binaryValue;
        }

        @Override
        public final Builder binaryValue(ByteBuffer binaryValue) {
            this.binaryValue = StandardMemberCopier.copy((ByteBuffer)binaryValue);
            return this;
        }

        public final void setBinaryValue(ByteBuffer binaryValue) {
            this.binaryValue = StandardMemberCopier.copy((ByteBuffer)binaryValue);
        }

        public final Collection<String> getStringListValues() {
            return this.stringListValues;
        }

        @Override
        public final Builder stringListValues(Collection<String> stringListValues) {
            this.stringListValues = StringListCopier.copy(stringListValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringListValues(String ... stringListValues) {
            this.stringListValues(Arrays.asList(stringListValues));
            return this;
        }

        public final void setStringListValues(Collection<String> stringListValues) {
            this.stringListValues = StringListCopier.copy(stringListValues);
        }

        @SafeVarargs
        public final void setStringListValues(String ... stringListValues) {
            this.stringListValues(Arrays.asList(stringListValues));
        }

        public final Collection<ByteBuffer> getBinaryListValues() {
            return this.binaryListValues;
        }

        @Override
        public final Builder binaryListValues(Collection<ByteBuffer> binaryListValues) {
            this.binaryListValues = BinaryListCopier.copy(binaryListValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binaryListValues(ByteBuffer ... binaryListValues) {
            this.binaryListValues(Arrays.asList(binaryListValues));
            return this;
        }

        public final void setBinaryListValues(Collection<ByteBuffer> binaryListValues) {
            this.binaryListValues = BinaryListCopier.copy(binaryListValues);
        }

        @SafeVarargs
        public final void setBinaryListValues(ByteBuffer ... binaryListValues) {
            this.binaryListValues(Arrays.asList(binaryListValues));
        }

        public final String getDataType() {
            return this.dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public MessageAttributeValue build() {
            return new MessageAttributeValue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MessageAttributeValue> {
        public Builder stringValue(String var1);

        public Builder binaryValue(ByteBuffer var1);

        public Builder stringListValues(Collection<String> var1);

        public Builder stringListValues(String ... var1);

        public Builder binaryListValues(Collection<ByteBuffer> var1);

        public Builder binaryListValues(ByteBuffer ... var1);

        public Builder dataType(String var1);
    }
}

