/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendMessageBatchRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SendMessageBatchRequest> {
    private final String queueUrl;
    private final List<SendMessageBatchRequestEntry> entries;

    private SendMessageBatchRequest(BuilderImpl builder) {
        this.queueUrl = builder.queueUrl;
        this.entries = builder.entries;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public List<SendMessageBatchRequestEntry> entries() {
        return this.entries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.queueUrl() == null ? 0 : this.queueUrl().hashCode());
        hashCode = 31 * hashCode + (this.entries() == null ? 0 : this.entries().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageBatchRequest)) {
            return false;
        }
        SendMessageBatchRequest other = (SendMessageBatchRequest)((Object)obj);
        if (other.queueUrl() == null ^ this.queueUrl() == null) {
            return false;
        }
        if (other.queueUrl() != null && !other.queueUrl().equals(this.queueUrl())) {
            return false;
        }
        if (other.entries() == null ^ this.entries() == null) {
            return false;
        }
        return other.entries() == null || other.entries().equals(this.entries());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.queueUrl() != null) {
            sb.append("QueueUrl: ").append(this.queueUrl()).append(",");
        }
        if (this.entries() != null) {
            sb.append("Entries: ").append(this.entries()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String queueUrl;
        private List<SendMessageBatchRequestEntry> entries;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageBatchRequest model) {
            this.setQueueUrl(model.queueUrl);
            this.setEntries(model.entries);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Collection<SendMessageBatchRequestEntry> getEntries() {
            return this.entries;
        }

        @Override
        public final Builder entries(Collection<SendMessageBatchRequestEntry> entries) {
            this.entries = SendMessageBatchRequestEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(SendMessageBatchRequestEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        public final void setEntries(Collection<SendMessageBatchRequestEntry> entries) {
            this.entries = SendMessageBatchRequestEntryListCopier.copy(entries);
        }

        @SafeVarargs
        public final void setEntries(SendMessageBatchRequestEntry ... entries) {
            this.entries(Arrays.asList(entries));
        }

        public SendMessageBatchRequest build() {
            return new SendMessageBatchRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SendMessageBatchRequest> {
        public Builder queueUrl(String var1);

        public Builder entries(Collection<SendMessageBatchRequestEntry> var1);

        public Builder entries(SendMessageBatchRequestEntry ... var1);
    }
}

