/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry;
import software.amazon.awssdk.util.StringUtils;

public class DeleteMessageBatchRequestMarshaller
implements Marshaller<Request<DeleteMessageBatchRequest>, DeleteMessageBatchRequest> {
    public Request<DeleteMessageBatchRequest> marshall(DeleteMessageBatchRequest deleteMessageBatchRequest) {
        List<DeleteMessageBatchRequestEntry> entriesList;
        if (deleteMessageBatchRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteMessageBatchRequest, "SQSClient");
        request.addParameter("Action", "DeleteMessageBatch");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteMessageBatchRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)deleteMessageBatchRequest.queueUrl()));
        }
        if ((entriesList = deleteMessageBatchRequest.entries()) != null) {
            if (!entriesList.isEmpty()) {
                int entriesListIndex = 1;
                for (DeleteMessageBatchRequestEntry entriesListValue : entriesList) {
                    if (entriesListValue.id() != null) {
                        request.addParameter("DeleteMessageBatchRequestEntry." + entriesListIndex + ".Id", StringUtils.fromString((String)entriesListValue.id()));
                    }
                    if (entriesListValue.receiptHandle() != null) {
                        request.addParameter("DeleteMessageBatchRequestEntry." + entriesListIndex + ".ReceiptHandle", StringUtils.fromString((String)entriesListValue.receiptHandle()));
                    }
                    ++entriesListIndex;
                }
            } else {
                request.addParameter("DeleteMessageBatchRequestEntry", "");
            }
        }
        return request;
    }
}

